﻿using System.ServiceModel;
using HIPS.CommonSchemas;
using HIPS.HpiiSchemas;

namespace HIPS.ServiceContracts.ServiceInterfaces
{
    /// <summary>
    /// Web service interface for the HPI-I service.
    /// </summary>
    [WCFExtras.Wsdl.Documentation.XmlComments]
    [ServiceContract(Namespace = "http://schemas.HIPS/Services/2012/01", Name = "HpiiService")]
    public interface IHpiiService
    {
        /// <summary>
        /// Performs an HPII Batch Retrieve against the HPII Service.
        /// </summary>
        /// <param name="hpiiBatchAsyncRetrieveRequest">The HPII identifier query.</param>
        /// <param name="user">The user.</param>
        /// <returns>HPI-I Batch Asynchronous Retrieve Response.</returns>
        [OperationContract]
        HpiiBatchAsyncRetrieveResponse HpiiBatchRetrieve(HpiiBatchAsyncRetrieveRequest hpiiBatchAsyncRetrieveRequest, UserDetails user);

        /// <summary>
        /// Performs an HPII Batch Submit against the HPII Service.
        /// </summary>
        /// <param name="hpiiBatchAsyncSubmitRequest">The hpii batch asynchronous submit request.</param>
        /// <param name="user">The user.</param>
        /// <returns>HPI-I Batch Asynchronous Submit Response.</returns>
        [OperationContract]
        HpiiBatchAsyncSubmitResponse HpiiBatchSubmit(HpiiBatchAsyncSubmitRequest hpiiBatchAsyncSubmitRequest, UserDetails user);

        /// <summary>
        /// Performs an HPII Demographic query against the HPII Service.
        /// </summary>
        /// <param name="hpiiDemographicQuery">The HPII demographic query.</param>
        /// <param name="user">The user.</param>
        /// <returns>Found HPII information</returns>
        [OperationContract]
        HpiiQueryResponse HpiiDemographicSearch(HpiiDemographicQuery hpiiDemographicQuery, UserDetails user);

        /// <summary>
        /// Performs an HPII Validation query against the HPII Service.
        /// </summary>
        /// <param name="hpiiIdentifierQuery">The HPII identifier query.</param>
        /// <param name="user">The user.</param>
        /// <returns>Validated HPII information</returns>
        [OperationContract]
        HpiiQueryResponse HpiiValidation(HpiiIdentifierQuery hpiiIdentifierQuery, UserDetails user);
    }
}