﻿// -----------------------------------------------------------------------
// <copyright file="SignedXmlForPcehr.cs" company="NEHTA">
// Developed by Chamonix for NEHTA.
// </copyright>
// -----------------------------------------------------------------------

using System.Security.Cryptography.Xml;
using System.Xml;

namespace Test.CommonCcaNoc.Helpers
{
    /// <summary>
    /// Subclass of the Microsoft SignedXml class that can find elements referenced
    /// using the xml:id attribute. This is necessary because the base SignedXml class
    /// only recognises Id attributes.
    /// </summary>
    public class SignedXmlForPcehr : SignedXml
    {
        public SignedXmlForPcehr(XmlDocument document)
            : base(document)
        {
            return;
        }

        /// <summary>
        /// Returns the element that is referenced by the given identifier.
        /// </summary>
        /// <param name="document">An XML document.</param>
        /// <param name="idValue">The identifier.</param>
        /// <returns>The element that is referenced.</returns>
        public override XmlElement GetIdElement(XmlDocument document, string idValue)
        {
            if ((document == null) || (idValue == null))
            {
                return null;
            }
            XmlNamespaceManager nsmgr = new XmlNamespaceManager(new NameTable());
            nsmgr.AddNamespace("xml", "http://www.w3.org/XML/1998/namespace");
            XmlNode node = document.SelectSingleNode("//*[@xml:id='" + idValue + "']", nsmgr);
            return node as XmlElement;
        }
    }
}