﻿using HIPS.CommonSchemas;
using HIPS.HpiiSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using nehta.mcaR50.ProviderSearchForProviderIndividual;
using Test.CommonCcaNoc.Helpers;
using Test.Helpers;

namespace Test.HiCcaNoc.CCA.UC_330
{
    /// <summary>
    /// The software shall create an error log for all error messages received
    /// from the HI Service including those that are resolved automatically.  
    /// The log shall include the error date/time, in hours and minutes unless,
    /// the system is capable of more precision the error number, the message
    /// and message ID reported by the HI Service.
    /// </summary>
    [TestClass]
    public class HI_CCA_330_005873 : CcaTest
    {
        /// <summary>
        /// Perform a patient registration operation which includes an error being returned from the HI Service.
        /// 
        /// View log entries in the local software.
        /// a. Verify that software created log entries for all error messages received from the HI Service including those that are resolved automatically.
        /// b. Verify that log entries include the error date/time, in hours and minutes unless the system is capable of more precision the error number, the message and message ID reported by the HI Service.
        /// c. Verify that log entries include the error number reported by the HI Service.
        /// d. Verify that log entries include the message reported by the HI Service.
        /// e. Verify that log entries include the message identifier reported by the HI Service.
        /// </summary>
        [TestMethod]
        [TestCategory("HI_CCA_UC_330")]
        public void HI_CCA_330_005873_1()
        {
            UserDetails user = new ProviderTestHelpersBase().GetTestUser();
            provider = CcaProviders.GetProvider("NOC ID 1");
            
            HpiiIdentifierQuery query = new HpiiIdentifierQuery();
            query.HpioNumber = provider.TestProviderHpioNumber;
            query.HpiiNumber = provider.TestProviderHpiiNumber;
            query.FamilyName = provider.TestProviderFamilyName;
            query.Sex = (SexType?)provider.TestProviderSex;
            
            HpiiQueryResponse hpiiResponse = ProxyHelper.HpiiProxy.HpiiValidation(query, user);
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, hpiiResponse.HipsResponse, DialogueResource.HipsServiceHpiiValidation);
            LogAssert.AreEqual(provider.TestProviderHpiiNumber, hpiiResponse.HpiiNumber, DialogueResource.HpiiNumber);

            var audit = provider.GetLastHpiiLookupAudit();
            LogAssert.IsTrue(string.IsNullOrEmpty(audit.Message), "Message is empty.", "Message is not empty.");            
        }
    
    }
}
