﻿using System.Collections;
using System.Collections.Generic;
using HIPS.CommonSchemas;
using HIPS.HpiiSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using nehta.mcaR50.ProviderSearchForProviderIndividual;
using Test.Helpers;
using Test.CommonCcaNoc.Helpers;

namespace Test.MedicareCCA.NoticeOfConnection.HPII
{
    [TestClass]
    public class NOC_HPIIBatchAsynSearch : CcaTest
    {
        private static Hashtable prop;

        [ClassInitialize()]
        public static void ClassInit(TestContext context)
        {
            prop = new Hashtable(2);
        }

        /// HPII Batch Inquiry Search via B2B (Reference: TECH.SIS.HI.33)
        /// Test 22.1 - Positive 2 Provider Individual Hpii Validation Submit (Related to 22.2)
        /// </summary>
        [TestMethod]
        [TestCategory("HI_NOC_HPI-I_BatchAsync")]
        public void HI_NOC_TECH_SIS_HI_33_TEST_22_1()
        {
            UserDetails user = new ProviderTestHelpersBase().GetTestAuthorisedEmployee();

            HpiiBatchAsyncSubmitRequest hpiiBatchAsyncSubmitRequest = new HpiiBatchAsyncSubmitRequest();
            hpiiBatchAsyncSubmitRequest.HpiiIdentifierQueries = new List<HpiiIdentifierQuery>();
            hpiiBatchAsyncSubmitRequest.HpiiDemographicQueries = new List<HpiiDemographicQuery>();

            //first provider
            provider = CcaProviders.GetProvider("NOC ID 1");

            //setup overarching HPIO
            hpiiBatchAsyncSubmitRequest.HpioNumber = provider.TestProviderHpioNumber;

            HpiiIdentifierQuery query = new HpiiIdentifierQuery();
            query.HpioNumber = provider.TestProviderHpioNumber;
            query.HpiiNumber = provider.TestProviderHpiiNumber;
            query.FamilyName = provider.TestProviderFamilyName;
            query.Sex = (SexType?)provider.TestProviderSex;

            hpiiBatchAsyncSubmitRequest.HpiiIdentifierQueries.Add(query);

            //second provider
            provider = CcaProviders.GetProvider("NOC ID 3");

            query = new HpiiIdentifierQuery();
            query.HpioNumber = provider.TestProviderHpioNumber;
            query.HpiiNumber = provider.TestProviderHpiiNumber;
            query.FamilyName = provider.TestProviderFamilyName;
            query.Sex = (SexType?)provider.TestProviderSex;

            hpiiBatchAsyncSubmitRequest.HpiiIdentifierQueries.Add(query);

            //process submit
            HpiiBatchAsyncSubmitResponse hpiiBatchAsyncSubmitResponse = ProxyHelper.HpiiProxy.HpiiBatchSubmit(hpiiBatchAsyncSubmitRequest, user);

            //save batch identifier for next test
            prop.Add(DialogueResource.HI_NOC_TECH_SIS_HI_33_TEST_22_1_BatchIdentifier, hpiiBatchAsyncSubmitResponse.BatchIdentifier);
            batching = true;

            LogAssert.ExpectResponse(HipsResponseIndicator.OK, hpiiBatchAsyncSubmitResponse.HipsResponse, DialogueResource.HipsServiceHpiiValidation);
            LogAssert.IsNotNull(hpiiBatchAsyncSubmitResponse.BatchIdentifier, string.Format(DialogueResource.HpiiBatchIdentifier, hpiiBatchAsyncSubmitResponse.BatchIdentifier));
        }

        /// HPII Batch Inquiry Search via B2B (Reference: TECH.SIS.HI.33)
        /// Test 22.2 - Positive 2 Provider Individual Hpii Validation Retrieve (Related to 22.1)
        /// </summary>
        [TestMethod]
        [TestCategory("HI_NOC_HPI-I_BatchAsync")]
        public void HI_NOC_TECH_SIS_HI_33_TEST_22_2()
        {
            UserDetails user = new ProviderTestHelpersBase().GetTestAuthorisedEmployee();

            provider = CcaProviders.GetProvider("NOC ID 1");

            HpiiBatchAsyncRetrieveRequest hpiiBatchAsyncRetrieveRequest = new HpiiBatchAsyncRetrieveRequest();
            hpiiBatchAsyncRetrieveRequest.HpioNumber = provider.TestProviderHpioNumber;

            if (prop.ContainsKey(DialogueResource.HI_NOC_TECH_SIS_HI_33_TEST_22_1_BatchIdentifier))
            {
                string batchIdentifier = (string)prop[DialogueResource.HI_NOC_TECH_SIS_HI_33_TEST_22_1_BatchIdentifier];
                hpiiBatchAsyncRetrieveRequest.BatchIdentifier = batchIdentifier;
            }

            //process submit
            HpiiBatchAsyncRetrieveResponse hpiiBatchAsyncRetrieveResponse = ProxyHelper.HpiiProxy.HpiiBatchRetrieve(hpiiBatchAsyncRetrieveRequest, user);

            //save batch identifier for next test
            batching = true;

            LogAssert.ExpectResponse(HipsResponseIndicator.OK, hpiiBatchAsyncRetrieveResponse.HipsResponse, DialogueResource.HipsServiceHpiiValidation);
            LogAssert.AreEqual(hpiiBatchAsyncRetrieveRequest.BatchIdentifier, hpiiBatchAsyncRetrieveResponse.BatchIdentifier, string.Format(DialogueResource.HpiiBatchIdentifier, hpiiBatchAsyncRetrieveResponse.BatchIdentifier));
        }

        /// HPII Batch Inquiry Search via B2B (Reference: TECH.SIS.HI.33)
        /// Test 22.3 - Positive 2 Provider Individual Hpii Validation Submit (Related to 22.4)
        /// First Provider has correct data using HPII
        /// Second Provider has incorrect dummy data for Registration ID
        /// </summary>
        [TestMethod]
        [TestCategory("HI_NOC_HPI-I_BatchAsync")]
        public void HI_NOC_TECH_SIS_HI_33_TEST_22_3()
        {
            UserDetails user = new ProviderTestHelpersBase().GetTestAuthorisedEmployee();

            HpiiBatchAsyncSubmitRequest hpiiBatchAsyncSubmitRequest = new HpiiBatchAsyncSubmitRequest();
            hpiiBatchAsyncSubmitRequest.HpiiIdentifierQueries = new List<HpiiIdentifierQuery>();
            hpiiBatchAsyncSubmitRequest.HpiiDemographicQueries = new List<HpiiDemographicQuery>();

            //first provider - Correct HPII Data
            provider = CcaProviders.GetProvider("NOC ID 1");

            //setup overarching HPIO
            hpiiBatchAsyncSubmitRequest.HpioNumber = provider.TestProviderHpioNumber;

            HpiiIdentifierQuery query = new HpiiIdentifierQuery();
            query.HpioNumber = provider.TestProviderHpioNumber;
            query.HpiiNumber = provider.TestProviderHpiiNumber;
            query.FamilyName = provider.TestProviderFamilyName;
            query.Sex = (SexType?)provider.TestProviderSex;

            hpiiBatchAsyncSubmitRequest.HpiiIdentifierQueries.Add(query);

            //second provider - Incorrect dummy Registration Id
            provider = CcaProviders.GetProvider("NOC ID 2");

            query = new HpiiIdentifierQuery();
            query.HpioNumber = provider.TestProviderHpioNumber;
            query.RegistrationId = "123456789";
            query.FamilyName = provider.TestProviderFamilyName;
            query.Sex = (SexType?)provider.TestProviderSex;

            hpiiBatchAsyncSubmitRequest.HpiiIdentifierQueries.Add(query);

            //process submit
            HpiiBatchAsyncSubmitResponse hpiiBatchAsyncSubmitResponse = ProxyHelper.HpiiProxy.HpiiBatchSubmit(hpiiBatchAsyncSubmitRequest, user);

            //save batch identifier for next test
            prop.Add(DialogueResource.HI_NOC_TECH_SIS_HI_33_TEST_22_3_BatchIdentifier, hpiiBatchAsyncSubmitResponse.BatchIdentifier);
            batching = true;

            LogAssert.ExpectResponse(HipsResponseIndicator.OK, hpiiBatchAsyncSubmitResponse.HipsResponse, DialogueResource.HipsServiceHpiiValidation);
            LogAssert.IsNotNull(hpiiBatchAsyncSubmitResponse.BatchIdentifier, string.Format(DialogueResource.HpiiBatchIdentifier, hpiiBatchAsyncSubmitResponse.BatchIdentifier));
        }

        /// HPII Batch Inquiry Search via B2B (Reference: TECH.SIS.HI.33)
        /// Test 22.4 - Positive 2 Provider Individual Hpii Validation Retrieve (Related to 22.3)
        /// First Provider has correct data using HPII
        /// Second Provider has incorrect dummy data for Registration ID
        /// </summary>
        [TestMethod]
        [TestCategory("HI_NOC_HPI-I_BatchAsync")]
        public void HI_NOC_TECH_SIS_HI_33_TEST_22_4()
        {
            UserDetails user = new ProviderTestHelpersBase().GetTestAuthorisedEmployee();

            provider = CcaProviders.GetProvider("NOC ID 1");

            HpiiBatchAsyncRetrieveRequest hpiiBatchAsyncRetrieveRequest = new HpiiBatchAsyncRetrieveRequest();
            hpiiBatchAsyncRetrieveRequest.HpioNumber = provider.TestProviderHpioNumber;

            if (prop.ContainsKey(DialogueResource.HI_NOC_TECH_SIS_HI_33_TEST_22_3_BatchIdentifier))
            {
                string batchIdentifier = (string)prop[DialogueResource.HI_NOC_TECH_SIS_HI_33_TEST_22_3_BatchIdentifier];
                hpiiBatchAsyncRetrieveRequest.BatchIdentifier = batchIdentifier;
            }

            //process submit
            HpiiBatchAsyncRetrieveResponse hpiiBatchAsyncRetrieveResponse = ProxyHelper.HpiiProxy.HpiiBatchRetrieve(hpiiBatchAsyncRetrieveRequest, user);

            //save batch identifier for next test
            batching = true;

            LogAssert.ExpectResponse(HipsResponseIndicator.OK, hpiiBatchAsyncRetrieveResponse.HipsResponse, DialogueResource.HipsServiceHpiiValidation);
            LogAssert.AreEqual(hpiiBatchAsyncRetrieveRequest.BatchIdentifier, hpiiBatchAsyncRetrieveResponse.BatchIdentifier, string.Format(DialogueResource.HpiiBatchIdentifier, hpiiBatchAsyncRetrieveResponse.BatchIdentifier));
        }

        /// HPII Batch Inquiry Search via B2B (Reference: TECH.SIS.HI.33)
        /// Test 22.5 - Positive 2 Provider Individual Hpii Demographic Search Submit (Related to 22.6)
        /// </summary>
        [TestMethod]
        [TestCategory("HI_NOC_HPI-I_BatchAsync")]
        public void HI_NOC_TECH_SIS_HI_33_TEST_22_5()
        {
            UserDetails user = new ProviderTestHelpersBase().GetTestAuthorisedEmployee();

            HpiiBatchAsyncSubmitRequest hpiiBatchAsyncSubmitRequest = new HpiiBatchAsyncSubmitRequest();
            hpiiBatchAsyncSubmitRequest.HpiiIdentifierQueries = new List<HpiiIdentifierQuery>();
            hpiiBatchAsyncSubmitRequest.HpiiDemographicQueries = new List<HpiiDemographicQuery>();

            //first provider
            provider = CcaProviders.GetProvider("NOC ID 1");

            //setup overarching HPIO
            hpiiBatchAsyncSubmitRequest.HpioNumber = provider.TestProviderHpioNumber;

            HpiiDemographicQuery query = new HpiiDemographicQuery();
            query.HpioNumber = provider.TestProviderHpioNumber;
            query.FamilyName = provider.TestProviderFamilyName;
            query.DateofBirth = provider.TestProviderDateOfBirth;
            string[] names = new string[2];
            names[0] = provider.TestProviderFirstGivenName;
            //query.GivenName = names;
            query.Sex = (SexType?)provider.TestProviderSex;

            query.AustralianAddress = new AustralianAddress();
            query.AustralianAddress.Suburb = provider.TestProviderSuburb;
            query.AustralianAddress.State = provider.TestProviderState;
            query.AustralianAddress.PostCode = provider.TestProviderPostCode;
            //oddly this is expected when it is not stated in the specifications
            query.AustralianAddress.StreetName = provider.TestProviderStreetName;

            hpiiBatchAsyncSubmitRequest.HpiiDemographicQueries.Add(query);

            //second provider
            provider = CcaProviders.GetProvider("NOC ID 3");

            query = new HpiiDemographicQuery();
            query.HpioNumber = provider.TestProviderHpioNumber;
            query.FamilyName = provider.TestProviderFamilyName;
            query.DateofBirth = provider.TestProviderDateOfBirth;
            names = new string[2];
            names[0] = provider.TestProviderFirstGivenName;
            //query.GivenName = names;
            query.Sex = (SexType?)provider.TestProviderSex;

            query.AustralianAddress = new AustralianAddress();
            query.AustralianAddress.Suburb = provider.TestProviderSuburb;
            query.AustralianAddress.State = provider.TestProviderState;
            query.AustralianAddress.PostCode = provider.TestProviderPostCode;
            //oddly this is expected when it is not stated in the specifications
            query.AustralianAddress.StreetName = provider.TestProviderStreetName;

            hpiiBatchAsyncSubmitRequest.HpiiDemographicQueries.Add(query);

            //process submit
            HpiiBatchAsyncSubmitResponse hpiiBatchAsyncSubmitResponse = ProxyHelper.HpiiProxy.HpiiBatchSubmit(hpiiBatchAsyncSubmitRequest, user);

            //save batch identifier for next test
            prop.Add(DialogueResource.HI_NOC_TECH_SIS_HI_33_TEST_22_5_BatchIdentifier, hpiiBatchAsyncSubmitResponse.BatchIdentifier);
            batching = true;

            LogAssert.ExpectResponse(HipsResponseIndicator.OK, hpiiBatchAsyncSubmitResponse.HipsResponse, DialogueResource.HipsServiceHpiiValidation);
            LogAssert.IsNotNull(hpiiBatchAsyncSubmitResponse.BatchIdentifier, string.Format(DialogueResource.HpiiBatchIdentifier, hpiiBatchAsyncSubmitResponse.BatchIdentifier));
        }

        /// HPII Batch Inquiry Search via B2B (Reference: TECH.SIS.HI.33)
        /// Test 22.6 - Positive 2 Provider Individual Hpii Demographic Search Retrieve (Related to 22.5)
        /// </summary>
        [TestMethod]
        [TestCategory("HI_NOC_HPI-I_BatchAsync")]
        public void HI_NOC_TECH_SIS_HI_33_TEST_22_6()
        {
            UserDetails user = new ProviderTestHelpersBase().GetTestAuthorisedEmployee();

            provider = CcaProviders.GetProvider("NOC ID 1");

            HpiiBatchAsyncRetrieveRequest hpiiBatchAsyncRetrieveRequest = new HpiiBatchAsyncRetrieveRequest();
            hpiiBatchAsyncRetrieveRequest.HpioNumber = provider.TestProviderHpioNumber;

            if (prop.ContainsKey(DialogueResource.HI_NOC_TECH_SIS_HI_33_TEST_22_5_BatchIdentifier))
            {
                string batchIdentifier = (string)prop[DialogueResource.HI_NOC_TECH_SIS_HI_33_TEST_22_5_BatchIdentifier];
                hpiiBatchAsyncRetrieveRequest.BatchIdentifier = batchIdentifier;
            }

            //process submit
            HpiiBatchAsyncRetrieveResponse hpiiBatchAsyncRetrieveResponse = ProxyHelper.HpiiProxy.HpiiBatchRetrieve(hpiiBatchAsyncRetrieveRequest, user);

            //save batch identifier for next test
            batching = true;

            LogAssert.ExpectResponse(HipsResponseIndicator.OK, hpiiBatchAsyncRetrieveResponse.HipsResponse, DialogueResource.HipsServiceHpiiValidation);
            LogAssert.AreEqual(hpiiBatchAsyncRetrieveRequest.BatchIdentifier, hpiiBatchAsyncRetrieveResponse.BatchIdentifier, string.Format(DialogueResource.HpiiBatchIdentifier, hpiiBatchAsyncRetrieveResponse.BatchIdentifier));
        }

        /// HPII Batch Inquiry Search via B2B (Reference: TECH.SIS.HI.33)
        /// Test 22.7 - Positive 1 Provider Individual Hpii Demographic Search with multiple given names Submit (Related to 22.8)
        /// </summary>
        [TestMethod]
        [TestCategory("HI_NOC_HPI-I_BatchAsync")]
        public void HI_NOC_TECH_SIS_HI_33_TEST_22_7()
        {
            UserDetails user = new ProviderTestHelpersBase().GetTestAuthorisedEmployee();

            HpiiBatchAsyncSubmitRequest hpiiBatchAsyncSubmitRequest = new HpiiBatchAsyncSubmitRequest();
            hpiiBatchAsyncSubmitRequest.HpiiIdentifierQueries = new List<HpiiIdentifierQuery>();
            hpiiBatchAsyncSubmitRequest.HpiiDemographicQueries = new List<HpiiDemographicQuery>();

            provider = CcaProviders.GetProvider("NOC ID 3");

            //setup overarching HPIO
            hpiiBatchAsyncSubmitRequest.HpioNumber = provider.TestProviderHpioNumber;

            HpiiDemographicQuery query = new HpiiDemographicQuery();
            query.HpioNumber = provider.TestProviderHpioNumber;
            query.FamilyName = provider.TestProviderFamilyName;
            query.DateofBirth = provider.TestProviderDateOfBirth;
            string[] names = new string[2];
            names[0] = provider.TestProviderFirstGivenName;
            names[1] = provider.TestProviderSecondGivenName;
            query.GivenName = names;
            query.Sex = (SexType?)provider.TestProviderSex;

            query.AustralianAddress = new AustralianAddress();
            query.AustralianAddress.Suburb = provider.TestProviderSuburb;
            query.AustralianAddress.State = provider.TestProviderState;
            query.AustralianAddress.PostCode = provider.TestProviderPostCode;
            //oddly this is expected when it is not stated in the specifications
            query.AustralianAddress.StreetName = provider.TestProviderStreetName;

            hpiiBatchAsyncSubmitRequest.HpiiDemographicQueries.Add(query);

            //process submit
            HpiiBatchAsyncSubmitResponse hpiiBatchAsyncSubmitResponse = ProxyHelper.HpiiProxy.HpiiBatchSubmit(hpiiBatchAsyncSubmitRequest, user);

            //save batch identifier for next test
            prop.Add(DialogueResource.HI_NOC_TECH_SIS_HI_33_TEST_22_7_BatchIdentifier, hpiiBatchAsyncSubmitResponse.BatchIdentifier);
            batching = true;

            LogAssert.ExpectResponse(HipsResponseIndicator.OK, hpiiBatchAsyncSubmitResponse.HipsResponse, DialogueResource.HipsServiceHpiiValidation);
            LogAssert.IsNotNull(hpiiBatchAsyncSubmitResponse.BatchIdentifier, string.Format(DialogueResource.HpiiBatchIdentifier, hpiiBatchAsyncSubmitResponse.BatchIdentifier));
        }

        /// HPII Batch Inquiry Search via B2B (Reference: TECH.SIS.HI.33)
        /// Test 22.8 - Positive 1 Provider Individual Hpii Demographic Search with multiple given names Retrieve (Related to 22.7)
        /// </summary>
        [TestMethod]
        [TestCategory("HI_NOC_HPI-I_BatchAsync")]
        public void HI_NOC_TECH_SIS_HI_33_TEST_22_8()
        {
            UserDetails user = new ProviderTestHelpersBase().GetTestAuthorisedEmployee();

            provider = CcaProviders.GetProvider("NOC ID 1");

            HpiiBatchAsyncRetrieveRequest hpiiBatchAsyncRetrieveRequest = new HpiiBatchAsyncRetrieveRequest();
            hpiiBatchAsyncRetrieveRequest.HpioNumber = provider.TestProviderHpioNumber;

            if (prop.ContainsKey(DialogueResource.HI_NOC_TECH_SIS_HI_33_TEST_22_7_BatchIdentifier))
            {
                string batchIdentifier = (string)prop[DialogueResource.HI_NOC_TECH_SIS_HI_33_TEST_22_7_BatchIdentifier];
                hpiiBatchAsyncRetrieveRequest.BatchIdentifier = batchIdentifier;
            }

            //process submit
            HpiiBatchAsyncRetrieveResponse hpiiBatchAsyncRetrieveResponse = ProxyHelper.HpiiProxy.HpiiBatchRetrieve(hpiiBatchAsyncRetrieveRequest, user);

            //save batch identifier for next test
            batching = true;

            LogAssert.ExpectResponse(HipsResponseIndicator.OK, hpiiBatchAsyncRetrieveResponse.HipsResponse, DialogueResource.HipsServiceHpiiValidation);
            LogAssert.AreEqual(hpiiBatchAsyncRetrieveRequest.BatchIdentifier, hpiiBatchAsyncRetrieveResponse.BatchIdentifier, string.Format(DialogueResource.HpiiBatchIdentifier, hpiiBatchAsyncRetrieveResponse.BatchIdentifier));
        }

        /// HPII Batch Inquiry Search via B2B (Reference: TECH.SIS.HI.33)
        /// Test 22.9 - Negative-Error Hpii Batchh Retrieve with incorrect batch ID
        /// </summary>
        [TestMethod]
        [TestCategory("HI_NOC_HPI-I_BatchAsync")]
        public void HI_NOC_TECH_SIS_HI_33_TEST_22_9()
        {
            UserDetails user = new ProviderTestHelpersBase().GetTestAuthorisedEmployee();

            provider = CcaProviders.GetProvider("NOC ID 1");

            HpiiBatchAsyncRetrieveRequest hpiiBatchAsyncRetrieveRequest = new HpiiBatchAsyncRetrieveRequest();
            hpiiBatchAsyncRetrieveRequest.HpioNumber = provider.TestProviderHpioNumber;

            hpiiBatchAsyncRetrieveRequest.BatchIdentifier = "123456789";

            //process submit
            HpiiBatchAsyncRetrieveResponse hpiiBatchAsyncRetrieveResponse = ProxyHelper.HpiiProxy.HpiiBatchRetrieve(hpiiBatchAsyncRetrieveRequest, user);

            //save batch identifier for next test
            batching = true;

            LogAssert.ExpectResponse(HipsResponseIndicator.HiServiceError, hpiiBatchAsyncRetrieveResponse.HipsResponse, DialogueResource.HipsServiceHpiiValidation);
            LogAssert.AreEqual("WSE9042", hpiiBatchAsyncRetrieveResponse.HipsResponse.ResponseCode, "Response Code");
            LogAssert.AreEqual("Batch Identifier 123456789 cannot be found.", hpiiBatchAsyncRetrieveResponse.HipsResponse.HipsErrorMessage, "Message");
        }
    }
}