﻿using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_201
{
    /// <summary>
    /// Conformance Test Specification: Clinical Documents
    ///                                 Version 1.2 — 12 September 2012
    /// Use Case #:	    CPCD_Common_Producer
    /// Use Case Name:	Produce a clinical document
    /// User story:
    /// A conformant clinical document is produced by the user using the software or automatically by the software.
    /// </summary>
    [TestClass]
    public class CPCD_P_CP441_2 : CcaTest
    {
        /// <summary>
        /// If the clinical document is to be sent to the PCEHR System:
        ///
        /// a. Author a CDA document that references an attachment that is one of the disallowed types.
        ///
        /// b. Verify the software does not allow the attachment to be included in a CDA package to be sent to the PCEHR System.
        /// </summary>
        [TestMethod]
        [TestCategory("CD_CCA")]
        public void ClinicalDocuments_CPCD_P_CP441_2()
        {
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "CCA ID IHI_85");
            Episode episode = patient.TargetEpisode;
            CdaDocument cdaDocument = patient.CreateNewDocument(SampleDocumentType.DischargeSummary3A);

            Attachment[] attachments = new Attachment[]
            {
                new Attachment()
                {
                    FileName = "BAD.EXE",
                    Contents = new byte[] { 2, 3, 4 }
                }
            };
            HipsResponse response = ProxyHelper.PcehrProxy.UploadOrSupersedeDocument(
                cdaDocument.GetBytes(), patient.TargetPatientIdentifier, patient.GetTestUser(), 
                attachments, patient.TargetEpisode.AdmissionDate, cdaDocument.GetFormatCode());
            LogAssert.ExpectResponse(HipsResponseIndicator.InvalidDocument, response, DialogueResource.HipsServiceUploadDocument);
            LogAssert.AreEqual("Attachment BAD.EXE is not a supported type for uploading to PCEHR.", response.HipsErrorMessage, "HIPS error message");
        }
    }
}