﻿using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_202
{
    /// <summary>
    /// Conformance Test Specification: Clinical Information Systems Connecting to the PCEHR System
    ///                                 Version 1.6 — 27 September 2012
    /// Use Case #:	    UC.CIS.202
    /// Use Case Name:	Supersede a Clinical Document
    /// Test Case ID:   PCEHR_CIS_019378
    /// Objective:
    /// To check there is a capability to create audit logs for interactions with the PCEHR System.
    /// </summary>
    [TestClass]
    public class PCEHR_CIS_019378 : CcaTest
    {
        /// <summary>
        /// Perform an operation to invoke provide&RegisterDocumentSet service on the PCEHR System.
        /// a. Demonstrate that an audit capability exists.
        /// </summary>
        [TestMethod]
        [TestCategory("CIS_CCA_202")]
        public void CIS_202_019378_A()
        {
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false);
            Episode episode = patient.TargetEpisode;

            // Upload the initial version
            CdaDocument cdaDocument1 = patient.CreateNewDocument(SampleDocumentType.DischargeSummary3A);
            HipsResponse uploadResponse = ProxyHelper.PcehrProxy.UploadOrSupersedeDocument(
                cdaDocument1.GetBytes(), patient.TargetPatientIdentifier, patient.GetTestUser(),
                new Attachment[0], patient.TargetEpisode.AdmissionDate, cdaDocument1.GetFormatCode());
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, uploadResponse, DialogueResource.HipsServiceUploadDocument1);
            QueueHelper.WaitForQueuedOperation(patient, LogAssert, DialogueResource.UploadWaitTimeout);

            // Upload the amended version
            CdaDocument cdaDocument2 = patient.CreateAmendedDocument(cdaDocument1);
            HipsResponse supersedeResponse = ProxyHelper.PcehrProxy.UploadOrSupersedeDocument(
                cdaDocument2.GetBytes(), patient.TargetPatientIdentifier, patient.GetTestUser(), 
                new Attachment[0], patient.TargetEpisode.AdmissionDate, cdaDocument2.GetFormatCode());
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, supersedeResponse, DialogueResource.HipsServiceUploadDocument2);
            QueueHelper.WaitForQueuedOperation(patient, LogAssert, DialogueResource.UploadWaitTimeout);

            // Check that the PCEHR service invocation was audited
            PcehrAudit audit = patient.GetLastPcehrAudit();
            LogAssert.AreEqual(patient.TargetPatientMasterId, audit.PatientMasterId, DialogueResource.PcehrAuditPatientMasterId);
            LogAssert.AreEqual(AuditOperationNames.UploadDocument, audit.ServiceName, DialogueResource.PcehrAuditServiceName);
        }
    }
}