﻿using System.Text;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using HIPS.PcehrSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_203
{
    /// <summary>
    /// Conformance Test Specification: Clinical Information Systems Connecting to the PCEHR System
    ///                                 Version 1.6 — 27 September 2012
    /// Use Case #:	    UC.CIS.203
    /// Use Case Name:	Remove a Clinical Document
    /// Test Case ID:   PCEHR_CIS_017887
    /// Objective:
    /// To check the existence of a mechanism to identify locally created
    /// clinical documents that have been removed from the PCEHR System.
    /// </summary>
    [TestClass]
    public class PCEHR_CIS_017887 : CcaTest
    {
        /// <summary>
        /// Create a clinical document for a healthcare recipient using the
        /// software, and upload the clinical document to the PCEHR System.
        /// Perform an operation to remove the document from the PCEHR System.
        /// Perform an operation to identify the document on the local system:
        /// a. Verify that the software provides a mechanism in the local
        ///    system to identify that clinical document that has been removed
        ///    from the PCEHR System.
        /// </summary>
        [TestMethod]
        [TestCategory("CIS_CCA_203")]
        public void CIS_203_017887_A()
        {
            // Create and upload the initial version of the document
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "CCA ID IHI_22");
            CdaDocument cdaDocument = patient.CreateNewDocument(SampleDocumentType.DischargeSummary3A);
            QueueHelper.UploadDocumentAndWaitUntilProcessed(patient, LogAssert, cdaDocument);

            // Perform an operation to remove the document from the PCEHR System.
            byte[] auditInformation = Encoding.UTF8.GetBytes("CIS_203_017887_A");
            HipsResponse response = ProxyHelper.PcehrProxy.Remove(patient.TargetPatientIdentifier, patient.TargetEpisode.AdmissionDate, cdaDocument.GetSetId(), RemovalReason.Withdrawn, patient.GetTestUser(), auditInformation);
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, response, "Remove");
            QueueHelper.WaitForQueuedOperation(patient, LogAssert, DialogueResource.RemoveWaitTimeout);

            // Perform an operation to identify the document on the local system.
            OperationStatus statusResponse = ProxyHelper.PcehrProxy.GetOperationStatus(patient.TargetPatientIdentifier, patient.TargetEpisode.AdmissionDate, patient.GetTestUser());
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, statusResponse.Response, "Get Operation Status");

            // Identify that clinical document has been removed from the PCEHR system.
            LogAssert.AreEqual((int)ClinicalDocumentStatus.Removed, statusResponse.UploadedDocuments[0].ClinicalDocumentStatusId, "Status of uploaded document");
        }
    }
}