SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[els].[Delegate]') AND type in (N'U'))
BEGIN
CREATE TABLE [els].[Delegate](
	[DelegateId] [int] IDENTITY(1,1) NOT NULL,
	[IntermediaryId] [int] NULL,
	[QualifiedIdentifier] [varchar](900) NOT NULL,
	[Name] [varchar](255) NULL,
	[AdditionalComments] [varchar](1024) NULL,
	[IsActive] [bit] NOT NULL,
	[PriorityNumber] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Delegate] PRIMARY KEY CLUSTERED 
(
	[DelegateId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[els].[FK_Delegate_Intermediary]') AND parent_object_id = OBJECT_ID(N'[els].[Delegate]'))
ALTER TABLE [els].[Delegate]  WITH CHECK ADD  CONSTRAINT [FK_Delegate_Intermediary] FOREIGN KEY([IntermediaryId])
REFERENCES [els].[Intermediary] ([IntermediaryId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[els].[FK_Delegate_Intermediary]') AND parent_object_id = OBJECT_ID(N'[els].[Delegate]'))
ALTER TABLE [els].[Delegate] CHECK CONSTRAINT [FK_Delegate_Intermediary]
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'els', N'TABLE',N'Delegate', N'COLUMN',N'QualifiedIdentifier'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This URI identifies the secure messaging delegate, formerly known as service provider.' , @level0type=N'SCHEMA',@level0name=N'els', @level1type=N'TABLE',@level1name=N'Delegate', @level2type=N'COLUMN',@level2name=N'QualifiedIdentifier'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[els].[DocumentType]') AND type in (N'U'))
BEGIN
CREATE TABLE [els].[DocumentType](
	[DocumentTypeId] [int] IDENTITY(1,1) NOT NULL,
	[Code] [varchar](20) NOT NULL,
	[Description] [varchar](50) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_DocumentType] PRIMARY KEY CLUSTERED 
(
	[DocumentTypeId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'els', N'TABLE',N'DocumentType', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description (e.g. Discharge Summary, Event Summary, e-Referral)' , @level0type=N'SCHEMA',@level0name=N'els', @level1type=N'TABLE',@level1name=N'DocumentType', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'els', N'TABLE',N'DocumentType', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a type of clinical document' , @level0type=N'SCHEMA',@level0name=N'els', @level1type=N'TABLE',@level1name=N'DocumentType'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[els].[InteractionRecord]') AND type in (N'U'))
BEGIN
CREATE TABLE [els].[InteractionRecord](
	[InteractionRecordId] [int] IDENTITY(1,1) NOT NULL,
	[ProviderOrganisationId] [int] NOT NULL,
	[DelegateId] [int] NOT NULL,
	[PayloadSchemeId] [int] NOT NULL,
	[ServiceInterfaceId] [int] NOT NULL,
	[ServiceEndpointUri] [varchar](1024) NOT NULL,
	[Certificate] [varchar](max) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_InteractionRecord] PRIMARY KEY CLUSTERED 
(
	[InteractionRecordId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[els].[FK_InteractionRecord_Delegate]') AND parent_object_id = OBJECT_ID(N'[els].[InteractionRecord]'))
ALTER TABLE [els].[InteractionRecord]  WITH CHECK ADD  CONSTRAINT [FK_InteractionRecord_Delegate] FOREIGN KEY([DelegateId])
REFERENCES [els].[Delegate] ([DelegateId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[els].[FK_InteractionRecord_Delegate]') AND parent_object_id = OBJECT_ID(N'[els].[InteractionRecord]'))
ALTER TABLE [els].[InteractionRecord] CHECK CONSTRAINT [FK_InteractionRecord_Delegate]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[els].[FK_InteractionRecord_PayloadScheme]') AND parent_object_id = OBJECT_ID(N'[els].[InteractionRecord]'))
ALTER TABLE [els].[InteractionRecord]  WITH CHECK ADD  CONSTRAINT [FK_InteractionRecord_PayloadScheme] FOREIGN KEY([PayloadSchemeId])
REFERENCES [els].[PayloadScheme] ([PayloadSchemeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[els].[FK_InteractionRecord_PayloadScheme]') AND parent_object_id = OBJECT_ID(N'[els].[InteractionRecord]'))
ALTER TABLE [els].[InteractionRecord] CHECK CONSTRAINT [FK_InteractionRecord_PayloadScheme]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[els].[FK_InteractionRecord_ProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[els].[InteractionRecord]'))
ALTER TABLE [els].[InteractionRecord]  WITH CHECK ADD  CONSTRAINT [FK_InteractionRecord_ProviderOrganisation] FOREIGN KEY([ProviderOrganisationId])
REFERENCES [nhsd].[ProviderOrganisation] ([ProviderOrganisationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[els].[FK_InteractionRecord_ProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[els].[InteractionRecord]'))
ALTER TABLE [els].[InteractionRecord] CHECK CONSTRAINT [FK_InteractionRecord_ProviderOrganisation]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[els].[FK_InteractionRecord_ServiceInterface]') AND parent_object_id = OBJECT_ID(N'[els].[InteractionRecord]'))
ALTER TABLE [els].[InteractionRecord]  WITH CHECK ADD  CONSTRAINT [FK_InteractionRecord_ServiceInterface] FOREIGN KEY([ServiceInterfaceId])
REFERENCES [els].[ServiceInterface] ([ServiceInterfaceId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[els].[FK_InteractionRecord_ServiceInterface]') AND parent_object_id = OBJECT_ID(N'[els].[InteractionRecord]'))
ALTER TABLE [els].[InteractionRecord] CHECK CONSTRAINT [FK_InteractionRecord_ServiceInterface]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[els].[Intermediary]') AND type in (N'U'))
BEGIN
CREATE TABLE [els].[Intermediary](
	[IntermediaryId] [int] IDENTITY(1,1) NOT NULL,
	[ServiceEndpointUri] [varchar](900) NOT NULL,
	[Name] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Intermediary] PRIMARY KEY CLUSTERED 
(
	[IntermediaryId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[els].[PayloadPackaging]') AND type in (N'U'))
BEGIN
CREATE TABLE [els].[PayloadPackaging](
	[PayloadPackagingId] [int] IDENTITY(1,1) NOT NULL,
	[Description] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PayloadPackaging] PRIMARY KEY CLUSTERED 
(
	[PayloadPackagingId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[els].[PayloadScheme]') AND type in (N'U'))
BEGIN
CREATE TABLE [els].[PayloadScheme](
	[PayloadSchemeId] [int] IDENTITY(1,1) NOT NULL,
	[PayloadPackagingId] [int] NOT NULL,
	[DocumentTypeId] [int] NOT NULL,
	[QualifiedIdentifier] [varchar](900) NOT NULL,
	[Name] [varchar](255) NULL,
	[AdditionalComments] [varchar](1024) NULL,
	[IsActive] [bit] NOT NULL,
	[PriorityNumber] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ServiceCategory] PRIMARY KEY CLUSTERED 
(
	[PayloadSchemeId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[els].[FK_PayloadScheme_DocumentType]') AND parent_object_id = OBJECT_ID(N'[els].[PayloadScheme]'))
ALTER TABLE [els].[PayloadScheme]  WITH CHECK ADD  CONSTRAINT [FK_PayloadScheme_DocumentType] FOREIGN KEY([DocumentTypeId])
REFERENCES [els].[DocumentType] ([DocumentTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[els].[FK_PayloadScheme_DocumentType]') AND parent_object_id = OBJECT_ID(N'[els].[PayloadScheme]'))
ALTER TABLE [els].[PayloadScheme] CHECK CONSTRAINT [FK_PayloadScheme_DocumentType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[els].[FK_PayloadScheme_PayloadPackaging]') AND parent_object_id = OBJECT_ID(N'[els].[PayloadScheme]'))
ALTER TABLE [els].[PayloadScheme]  WITH CHECK ADD  CONSTRAINT [FK_PayloadScheme_PayloadPackaging] FOREIGN KEY([PayloadPackagingId])
REFERENCES [els].[PayloadPackaging] ([PayloadPackagingId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[els].[FK_PayloadScheme_PayloadPackaging]') AND parent_object_id = OBJECT_ID(N'[els].[PayloadScheme]'))
ALTER TABLE [els].[PayloadScheme] CHECK CONSTRAINT [FK_PayloadScheme_PayloadPackaging]
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'els', N'TABLE',N'PayloadScheme', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Value that represents the business aspects of an interaction record, including a document type and payload packaging format. Defined in ATS 5546-2013 (E-health endpoint location service). Replaces the term Service Category defined in NEHTA 1156-2010 (Endpoint Location Service Solution Design).' , @level0type=N'SCHEMA',@level0name=N'els', @level1type=N'TABLE',@level1name=N'PayloadScheme'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[els].[ServiceInterface]') AND type in (N'U'))
BEGIN
CREATE TABLE [els].[ServiceInterface](
	[ServiceInterfaceId] [int] IDENTITY(1,1) NOT NULL,
	[QualifiedIdentifier] [varchar](900) NOT NULL,
	[Name] [varchar](255) NULL,
	[AdditionalComments] [varchar](1024) NULL,
	[PriorityNumber] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ServiceInterface] PRIMARY KEY CLUSTERED 
(
	[ServiceInterfaceId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[neps].[AreaOfInterest]') AND type in (N'U'))
BEGIN
CREATE TABLE [neps].[AreaOfInterest](
	[AreaOfInterestId] [int] IDENTITY(1,1) NOT NULL,
	[NepsSubscriptionId] [int] NOT NULL,
	[Code] [varchar](64) NOT NULL,
	[Description] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_AreaOfInterest] PRIMARY KEY CLUSTERED 
(
	[AreaOfInterestId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_AreaOfInterest_NepsSubscription]') AND parent_object_id = OBJECT_ID(N'[neps].[AreaOfInterest]'))
ALTER TABLE [neps].[AreaOfInterest]  WITH CHECK ADD  CONSTRAINT [FK_AreaOfInterest_NepsSubscription] FOREIGN KEY([NepsSubscriptionId])
REFERENCES [neps].[Subscription] ([NepsSubscriptionId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_AreaOfInterest_NepsSubscription]') AND parent_object_id = OBJECT_ID(N'[neps].[AreaOfInterest]'))
ALTER TABLE [neps].[AreaOfInterest] CHECK CONSTRAINT [FK_AreaOfInterest_NepsSubscription]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[neps].[AreaOfInterestGeographicalArea]') AND type in (N'U'))
BEGIN
CREATE TABLE [neps].[AreaOfInterestGeographicalArea](
	[AreaOfInterestGeographicalAreaId] [int] IDENTITY(1,1) NOT NULL,
	[AreaOfInterestId] [int] NOT NULL,
	[StateReferenceItemId] [int] NULL,
	[SuburbReferenceItemId] [int] NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_AreaOfInterestGeographicalArea] PRIMARY KEY CLUSTERED 
(
	[AreaOfInterestGeographicalAreaId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_AreaOfInterestGeographicalArea_AreaOfInterest]') AND parent_object_id = OBJECT_ID(N'[neps].[AreaOfInterestGeographicalArea]'))
ALTER TABLE [neps].[AreaOfInterestGeographicalArea]  WITH CHECK ADD  CONSTRAINT [FK_AreaOfInterestGeographicalArea_AreaOfInterest] FOREIGN KEY([AreaOfInterestId])
REFERENCES [neps].[AreaOfInterest] ([AreaOfInterestId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_AreaOfInterestGeographicalArea_AreaOfInterest]') AND parent_object_id = OBJECT_ID(N'[neps].[AreaOfInterestGeographicalArea]'))
ALTER TABLE [neps].[AreaOfInterestGeographicalArea] CHECK CONSTRAINT [FK_AreaOfInterestGeographicalArea_AreaOfInterest]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_AreaOfInterestGeographicalArea_SuburbReferenceItem]') AND parent_object_id = OBJECT_ID(N'[neps].[AreaOfInterestGeographicalArea]'))
ALTER TABLE [neps].[AreaOfInterestGeographicalArea]  WITH CHECK ADD  CONSTRAINT [FK_AreaOfInterestGeographicalArea_SuburbReferenceItem] FOREIGN KEY([SuburbReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_AreaOfInterestGeographicalArea_SuburbReferenceItem]') AND parent_object_id = OBJECT_ID(N'[neps].[AreaOfInterestGeographicalArea]'))
ALTER TABLE [neps].[AreaOfInterestGeographicalArea] CHECK CONSTRAINT [FK_AreaOfInterestGeographicalArea_SuburbReferenceItem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_AreaOfInterestGeographicalArea_StateReferenceItem]') AND parent_object_id = OBJECT_ID(N'[neps].[AreaOfInterestGeographicalArea]'))
ALTER TABLE [neps].[AreaOfInterestGeographicalArea]  WITH CHECK ADD  CONSTRAINT [FK_AreaOfInterestGeographicalArea_StateReferenceItem] FOREIGN KEY([StateReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_AreaOfInterestGeographicalArea_StateReferenceItem]') AND parent_object_id = OBJECT_ID(N'[neps].[AreaOfInterestGeographicalArea]'))
ALTER TABLE [neps].[AreaOfInterestGeographicalArea] CHECK CONSTRAINT [FK_AreaOfInterestGeographicalArea_StateReferenceItem]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[neps].[AreaOfInterestProviderIdentifier]') AND type in (N'U'))
BEGIN
CREATE TABLE [neps].[AreaOfInterestProviderIdentifier](
	[AreaOfInterestProviderIdentifierId] [int] IDENTITY(1,1) NOT NULL,
	[AreaOfInterestId] [int] NOT NULL,
	[ProviderIdentifierTypeId] [int] NOT NULL,
	[Value] [varchar](128) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_AreaOfInterestProviderIdentifier] PRIMARY KEY CLUSTERED 
(
	[AreaOfInterestProviderIdentifierId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_AreaOfInterestProviderIdentifier_AreaOfInterest]') AND parent_object_id = OBJECT_ID(N'[neps].[AreaOfInterestProviderIdentifier]'))
ALTER TABLE [neps].[AreaOfInterestProviderIdentifier]  WITH CHECK ADD  CONSTRAINT [FK_AreaOfInterestProviderIdentifier_AreaOfInterest] FOREIGN KEY([AreaOfInterestId])
REFERENCES [neps].[AreaOfInterest] ([AreaOfInterestId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_AreaOfInterestProviderIdentifier_AreaOfInterest]') AND parent_object_id = OBJECT_ID(N'[neps].[AreaOfInterestProviderIdentifier]'))
ALTER TABLE [neps].[AreaOfInterestProviderIdentifier] CHECK CONSTRAINT [FK_AreaOfInterestProviderIdentifier_AreaOfInterest]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_AreaOfInterestProviderIdentifier_ProviderIdentifierType]') AND parent_object_id = OBJECT_ID(N'[neps].[AreaOfInterestProviderIdentifier]'))
ALTER TABLE [neps].[AreaOfInterestProviderIdentifier]  WITH CHECK ADD  CONSTRAINT [FK_AreaOfInterestProviderIdentifier_ProviderIdentifierType] FOREIGN KEY([ProviderIdentifierTypeId])
REFERENCES [nhsd].[ProviderIdentifierType] ([ProviderIdentifierTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_AreaOfInterestProviderIdentifier_ProviderIdentifierType]') AND parent_object_id = OBJECT_ID(N'[neps].[AreaOfInterestProviderIdentifier]'))
ALTER TABLE [neps].[AreaOfInterestProviderIdentifier] CHECK CONSTRAINT [FK_AreaOfInterestProviderIdentifier_ProviderIdentifierType]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[neps].[AreaOfInterestService]') AND type in (N'U'))
BEGIN
CREATE TABLE [neps].[AreaOfInterestService](
	[AreaOfInterestId] [int] NOT NULL,
	[ServiceReferenceItemId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_AreaOfInterestOrganisationService] PRIMARY KEY CLUSTERED 
(
	[AreaOfInterestId] ASC,
	[ServiceReferenceItemId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_AreaOfInterestOrganisationService_AreaOfInterest]') AND parent_object_id = OBJECT_ID(N'[neps].[AreaOfInterestService]'))
ALTER TABLE [neps].[AreaOfInterestService]  WITH CHECK ADD  CONSTRAINT [FK_AreaOfInterestOrganisationService_AreaOfInterest] FOREIGN KEY([AreaOfInterestId])
REFERENCES [neps].[AreaOfInterest] ([AreaOfInterestId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_AreaOfInterestOrganisationService_AreaOfInterest]') AND parent_object_id = OBJECT_ID(N'[neps].[AreaOfInterestService]'))
ALTER TABLE [neps].[AreaOfInterestService] CHECK CONSTRAINT [FK_AreaOfInterestOrganisationService_AreaOfInterest]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_AreaOfInterestService_ReferenceItem]') AND parent_object_id = OBJECT_ID(N'[neps].[AreaOfInterestService]'))
ALTER TABLE [neps].[AreaOfInterestService]  WITH CHECK ADD  CONSTRAINT [FK_AreaOfInterestService_ReferenceItem] FOREIGN KEY([ServiceReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_AreaOfInterestService_ReferenceItem]') AND parent_object_id = OBJECT_ID(N'[neps].[AreaOfInterestService]'))
ALTER TABLE [neps].[AreaOfInterestService] CHECK CONSTRAINT [FK_AreaOfInterestService_ReferenceItem]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[neps].[PendingChange]') AND type in (N'U'))
BEGIN
CREATE TABLE [neps].[PendingChange](
	[PendingChangeId] [INT] IDENTITY(1,1) NOT NULL,
	[NepsSubscriptionId] [int] NOT NULL,
	[ChangeTypeId] [int] NOT NULL,
	[ProviderIdentifierTypeId] [int] NOT NULL,
	[Value] [varchar](128) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PendingChange] PRIMARY KEY CLUSTERED 
(
	[PendingChangeId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_PendingChange_Subscription]') AND parent_object_id = OBJECT_ID(N'[neps].[PendingChange]'))
ALTER TABLE [neps].[PendingChange]  WITH CHECK ADD  CONSTRAINT [FK_PendingChange_Subscription] FOREIGN KEY([NepsSubscriptionId])
REFERENCES [neps].[Subscription] ([NepsSubscriptionId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_PendingChange_Subscription]') AND parent_object_id = OBJECT_ID(N'[neps].[PendingChange]'))
ALTER TABLE [neps].[PendingChange] CHECK CONSTRAINT [FK_PendingChange_Subscription]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_PendingChange_ProviderIdentifierType]') AND parent_object_id = OBJECT_ID(N'[neps].[PendingChange]'))
ALTER TABLE [neps].[PendingChange]  WITH CHECK ADD  CONSTRAINT [FK_PendingChange_ProviderIdentifierType] FOREIGN KEY([ProviderIdentifierTypeId])
REFERENCES [nhsd].[ProviderIdentifierType] ([ProviderIdentifierTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_PendingChange_ProviderIdentifierType]') AND parent_object_id = OBJECT_ID(N'[neps].[PendingChange]'))
ALTER TABLE [neps].[PendingChange] CHECK CONSTRAINT [FK_PendingChange_ProviderIdentifierType]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_PendingChange_ChangeType]') AND parent_object_id = OBJECT_ID(N'[neps].[PendingChange]'))
ALTER TABLE [neps].[PendingChange]  WITH CHECK ADD  CONSTRAINT [FK_PendingChange_ChangeType] FOREIGN KEY([ChangeTypeId])
REFERENCES [p2p].[ChangeType] ([ChangeTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_PendingChange_ChangeType]') AND parent_object_id = OBJECT_ID(N'[neps].[PendingChange]'))
ALTER TABLE [neps].[PendingChange] CHECK CONSTRAINT [FK_PendingChange_ChangeType]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[neps].[Subscription]') AND type in (N'U'))
BEGIN
CREATE TABLE [neps].[Subscription](
	[NepsSubscriptionId] [int] NOT NULL,
	[AccessingOrganisationId] [int] NOT NULL,
	[LastSynchronisationCompleted] [datetime] NOT NULL,
	[SubscriptionSystemIdentifier] [varchar](64) NOT NULL,
	[UpdateFrequencyInDays] [INT] NOT NULL,
	[UpdateFrequencyInHours] [INT] NOT NULL,
	[UpdateFrequencyInMinutes] [INT] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_NepsSubscription] PRIMARY KEY CLUSTERED 
(
	[NepsSubscriptionId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_Subscription_AccessingOrganisation]') AND parent_object_id = OBJECT_ID(N'[neps].[Subscription]'))
ALTER TABLE [neps].[Subscription]  WITH CHECK ADD  CONSTRAINT [FK_Subscription_AccessingOrganisation] FOREIGN KEY([AccessingOrganisationId])
REFERENCES [p2p].[AccessingOrganisation] ([AccessingOrganisationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_Subscription_AccessingOrganisation]') AND parent_object_id = OBJECT_ID(N'[neps].[Subscription]'))
ALTER TABLE [neps].[Subscription] CHECK CONSTRAINT [FK_Subscription_AccessingOrganisation]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[neps].[SubscriptionMemberIndividual]') AND type in (N'U'))
BEGIN
CREATE TABLE [neps].[SubscriptionMemberIndividual](
	[NepsSubscriptionId] [int] NOT NULL,
	[ProviderIndividualId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_SubscriptionMemberIndividual] PRIMARY KEY CLUSTERED 
(
	[NepsSubscriptionId] ASC,
	[ProviderIndividualId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_SubscriptionMemberIndividual_Subscription]') AND parent_object_id = OBJECT_ID(N'[neps].[SubscriptionMemberIndividual]'))
ALTER TABLE [neps].[SubscriptionMemberIndividual]  WITH CHECK ADD  CONSTRAINT [FK_SubscriptionMemberIndividual_Subscription] FOREIGN KEY([NepsSubscriptionId])
REFERENCES [neps].[Subscription] ([NepsSubscriptionId])
GO
IF EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_SubscriptionMemberIndividual_Subscription]') AND parent_object_id = OBJECT_ID(N'[neps].[SubscriptionMemberIndividual]'))
ALTER TABLE [neps].[SubscriptionMemberIndividual] CHECK CONSTRAINT [FK_SubscriptionMemberIndividual_Subscription]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_SubscriptionMemberIndividual_ProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[neps].[SubscriptionMemberIndividual]'))
ALTER TABLE [neps].[SubscriptionMemberIndividual]  WITH CHECK ADD  CONSTRAINT [FK_SubscriptionMemberIndividual_ProviderIndividual] FOREIGN KEY([ProviderIndividualId])
REFERENCES [nhsd].[ProviderIndividual] ([ProviderIndividualId])
GO
IF EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_SubscriptionMemberIndividual_ProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[neps].[SubscriptionMemberIndividual]'))
ALTER TABLE [neps].[SubscriptionMemberIndividual] CHECK CONSTRAINT [FK_SubscriptionMemberIndividual_ProviderIndividual]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[neps].[SubscriptionMemberOrganisation]') AND type in (N'U'))
BEGIN
CREATE TABLE [neps].[SubscriptionMemberOrganisation](
	[NepsSubscriptionId] [int] NOT NULL,
	[ProviderOrganisationId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_SubscriptionMemberOrganisation] PRIMARY KEY CLUSTERED 
(
	[NepsSubscriptionId] ASC,
	[ProviderOrganisationId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_SubscriptionMemberOrganisation_Subscription]') AND parent_object_id = OBJECT_ID(N'[neps].[SubscriptionMemberOrganisation]'))
ALTER TABLE [neps].[SubscriptionMemberOrganisation]  WITH CHECK ADD  CONSTRAINT [FK_SubscriptionMemberOrganisation_Subscription] FOREIGN KEY([NepsSubscriptionId])
REFERENCES [neps].[Subscription] ([NepsSubscriptionId])
GO
IF EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_SubscriptionMemberOrganisation_Subscription]') AND parent_object_id = OBJECT_ID(N'[neps].[SubscriptionMemberOrganisation]'))
ALTER TABLE [neps].[SubscriptionMemberOrganisation] CHECK CONSTRAINT [FK_SubscriptionMemberOrganisation_Subscription]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_SubscriptionMemberOrganisation_ProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[neps].[SubscriptionMemberOrganisation]'))
ALTER TABLE [neps].[SubscriptionMemberOrganisation]  WITH CHECK ADD  CONSTRAINT [FK_SubscriptionMemberOrganisation_ProviderOrganisation] FOREIGN KEY([ProviderOrganisationId])
REFERENCES [nhsd].[ProviderOrganisation] ([ProviderOrganisationId])
GO
IF EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[neps].[FK_SubscriptionMemberOrganisation_ProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[neps].[SubscriptionMemberOrganisation]'))
ALTER TABLE [neps].[SubscriptionMemberOrganisation] CHECK CONSTRAINT [FK_SubscriptionMemberOrganisation_ProviderOrganisation]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ChannelCarrier]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ChannelCarrier](
	[ChannelCarrierId] [int] IDENTITY(1,1) NOT NULL,
	[ChannelTypeId] [int] NULL,
	[ChannelCarrierReferenceItemId] [int] NULL,
	[Preference] [bigint] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ChannelCarrier] PRIMARY KEY CLUSTERED 
(
	[ChannelCarrierId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ChannelCarrier_ChannelType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ChannelCarrier]'))
ALTER TABLE [nhsd].[ChannelCarrier]  WITH CHECK ADD  CONSTRAINT [FK_ChannelCarrier_ChannelType] FOREIGN KEY([ChannelTypeId])
REFERENCES [nhsd].[ChannelType] ([ChannelTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ChannelCarrier_ChannelType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ChannelCarrier]'))
ALTER TABLE [nhsd].[ChannelCarrier] CHECK CONSTRAINT [FK_ChannelCarrier_ChannelType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ChannelCarrier_ReferenceItem]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ChannelCarrier]'))
ALTER TABLE [nhsd].[ChannelCarrier]  WITH CHECK ADD  CONSTRAINT [FK_ChannelCarrier_ReferenceItem] FOREIGN KEY([ChannelCarrierReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ChannelCarrier_ReferenceItem]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ChannelCarrier]'))
ALTER TABLE [nhsd].[ChannelCarrier] CHECK CONSTRAINT [FK_ChannelCarrier_ReferenceItem]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ChannelCarrierProprietaryValue]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ChannelCarrierProprietaryValue](
	[ChannelCarrierProprietaryValueId] [int] IDENTITY(1,1) NOT NULL,
	[ChannelCarrierId] [int] NULL,
	[ValueTypeReferenceItemId] [int] NULL,
	[Value] [varchar](max) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ChannelCarrierProprietaryValue] PRIMARY KEY CLUSTERED 
(
	[ChannelCarrierProprietaryValueId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ChannelCarrierProprietaryValue_ChannelCarrier]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ChannelCarrierProprietaryValue]'))
ALTER TABLE [nhsd].[ChannelCarrierProprietaryValue]  WITH CHECK ADD  CONSTRAINT [FK_ChannelCarrierProprietaryValue_ChannelCarrier] FOREIGN KEY([ChannelCarrierId])
REFERENCES [nhsd].[ChannelCarrier] ([ChannelCarrierId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ChannelCarrierProprietaryValue_ChannelCarrier]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ChannelCarrierProprietaryValue]'))
ALTER TABLE [nhsd].[ChannelCarrierProprietaryValue] CHECK CONSTRAINT [FK_ChannelCarrierProprietaryValue_ChannelCarrier]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ChannelCarrierProprietaryValue_ValueTypeReferenceItem]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ChannelCarrierProprietaryValue]'))
ALTER TABLE [nhsd].[ChannelCarrierProprietaryValue]  WITH CHECK ADD  CONSTRAINT [FK_ChannelCarrierProprietaryValue_ValueTypeReferenceItem] FOREIGN KEY([ValueTypeReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ChannelCarrierProprietaryValue_ValueTypeReferenceItem]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ChannelCarrierProprietaryValue]'))
ALTER TABLE [nhsd].[ChannelCarrierProprietaryValue] CHECK CONSTRAINT [FK_ChannelCarrierProprietaryValue_ValueTypeReferenceItem]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ChannelType]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ChannelType](
	[ChannelTypeId] [int] IDENTITY(1,1) NOT NULL,
	[DocumentChannelId] [int] NULL,
	[ChannelTypeReferenceItemId] [int] NULL,
	[DocumentFormatReferenceItemId] [int] NULL,
	[Preference] [bigint] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ChannelType] PRIMARY KEY CLUSTERED 
(
	[ChannelTypeId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ChannelType_ChannelTypeReferenceItem]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ChannelType]'))
ALTER TABLE [nhsd].[ChannelType]  WITH CHECK ADD  CONSTRAINT [FK_ChannelType_ChannelTypeReferenceItem] FOREIGN KEY([ChannelTypeReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ChannelType_ChannelTypeReferenceItem]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ChannelType]'))
ALTER TABLE [nhsd].[ChannelType] CHECK CONSTRAINT [FK_ChannelType_ChannelTypeReferenceItem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ChannelType_DocumentChannel]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ChannelType]'))
ALTER TABLE [nhsd].[ChannelType]  WITH CHECK ADD  CONSTRAINT [FK_ChannelType_DocumentChannel] FOREIGN KEY([DocumentChannelId])
REFERENCES [nhsd].[DocumentChannel] ([DocumentChannelId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ChannelType_DocumentChannel]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ChannelType]'))
ALTER TABLE [nhsd].[ChannelType] CHECK CONSTRAINT [FK_ChannelType_DocumentChannel]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ChannelType_DocumentFormatReferenceItem]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ChannelType]'))
ALTER TABLE [nhsd].[ChannelType]  WITH CHECK ADD  CONSTRAINT [FK_ChannelType_DocumentFormatReferenceItem] FOREIGN KEY([DocumentFormatReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ChannelType_DocumentFormatReferenceItem]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ChannelType]'))
ALTER TABLE [nhsd].[ChannelType] CHECK CONSTRAINT [FK_ChannelType_DocumentFormatReferenceItem]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[DocumentChannel]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[DocumentChannel](
	[DocumentChannelId] [int] IDENTITY(1,1) NOT NULL,
	[ProviderOrganisationId] [int] NULL,
	[ProviderLocationId] [int] NULL,
	[DocumentTypeReferenceItemId] [int] NOT NULL,
	[DocumentChannelPreferenceIdentifier] [varchar](20) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_DocumentChannel] PRIMARY KEY CLUSTERED 
(
	[DocumentChannelId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_DocumentChannel_DocumentTypeReferenceItem]') AND parent_object_id = OBJECT_ID(N'[nhsd].[DocumentChannel]'))
ALTER TABLE [nhsd].[DocumentChannel]  WITH CHECK ADD  CONSTRAINT [FK_DocumentChannel_DocumentTypeReferenceItem] FOREIGN KEY([DocumentTypeReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_DocumentChannel_DocumentTypeReferenceItem]') AND parent_object_id = OBJECT_ID(N'[nhsd].[DocumentChannel]'))
ALTER TABLE [nhsd].[DocumentChannel] CHECK CONSTRAINT [FK_DocumentChannel_DocumentTypeReferenceItem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_DocumentChannel_ProviderLocation]') AND parent_object_id = OBJECT_ID(N'[nhsd].[DocumentChannel]'))
ALTER TABLE [nhsd].[DocumentChannel]  WITH CHECK ADD  CONSTRAINT [FK_DocumentChannel_ProviderLocation] FOREIGN KEY([ProviderLocationId])
REFERENCES [nhsd].[ProviderLocation] ([ProviderLocationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_DocumentChannel_ProviderLocation]') AND parent_object_id = OBJECT_ID(N'[nhsd].[DocumentChannel]'))
ALTER TABLE [nhsd].[DocumentChannel] CHECK CONSTRAINT [FK_DocumentChannel_ProviderLocation]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_DocumentChannel_ProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[nhsd].[DocumentChannel]'))
ALTER TABLE [nhsd].[DocumentChannel]  WITH CHECK ADD  CONSTRAINT [FK_DocumentChannel_ProviderOrganisation] FOREIGN KEY([ProviderOrganisationId])
REFERENCES [nhsd].[ProviderOrganisation] ([ProviderOrganisationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_DocumentChannel_ProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[nhsd].[DocumentChannel]'))
ALTER TABLE [nhsd].[DocumentChannel] CHECK CONSTRAINT [FK_DocumentChannel_ProviderOrganisation]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ProprietaryValue]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ProprietaryValue](
	[ProprietaryValueId] [int] IDENTITY(1,1) NOT NULL,
	[ChannelTypeId] [int] NULL,
	[ValueTypeReferenceItemId] [int] NULL,
	[Value] [varchar](max) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProprietaryValue] PRIMARY KEY CLUSTERED 
(
	[ProprietaryValueId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProprietaryValue_ChannelType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProprietaryValue]'))
ALTER TABLE [nhsd].[ProprietaryValue]  WITH CHECK ADD  CONSTRAINT [FK_ProprietaryValue_ChannelType] FOREIGN KEY([ChannelTypeId])
REFERENCES [nhsd].[ChannelType] ([ChannelTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProprietaryValue_ChannelType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProprietaryValue]'))
ALTER TABLE [nhsd].[ProprietaryValue] CHECK CONSTRAINT [FK_ProprietaryValue_ChannelType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProprietaryValue_ValueTypeReferenceItem]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProprietaryValue]'))
ALTER TABLE [nhsd].[ProprietaryValue]  WITH CHECK ADD  CONSTRAINT [FK_ProprietaryValue_ValueTypeReferenceItem] FOREIGN KEY([ValueTypeReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProprietaryValue_ValueTypeReferenceItem]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProprietaryValue]'))
ALTER TABLE [nhsd].[ProprietaryValue] CHECK CONSTRAINT [FK_ProprietaryValue_ValueTypeReferenceItem]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ProviderEntityType]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ProviderEntityType](
	[ProviderEntityTypeId] [int] NOT NULL,
	[Description] [varchar](256) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderEntityType] PRIMARY KEY CLUSTERED 
(
	[ProviderEntityTypeId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ProviderIdentifierStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ProviderIdentifierStatus](
	[ProviderIdentifierStatusId] [int] NOT NULL,
	[Code] [varchar](40) NOT NULL,
	[Description] [varchar](256) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderIdentifierStatus] PRIMARY KEY CLUSTERED 
(
	[ProviderIdentifierStatusId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ProviderIdentifierType]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ProviderIdentifierType](
	[ProviderIdentifierTypeId] [int] IDENTITY(1,1) NOT NULL,
	[ProviderEntityTypeId] [int] NOT NULL,
	[IdentifierTypeReferenceItemId] [int] NULL,
	[Code] [varchar](40) NOT NULL,
	[Description] [varchar](256) NULL,
	[UriQualifier] [varchar](64) NULL,
	[OidQualifier] [varchar](64) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderIdentifierType] PRIMARY KEY CLUSTERED 
(
	[ProviderIdentifierTypeId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIdentifierType_ProviderEntityType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIdentifierType]'))
ALTER TABLE [nhsd].[ProviderIdentifierType]  WITH CHECK ADD  CONSTRAINT [FK_ProviderIdentifierType_ProviderEntityType] FOREIGN KEY([ProviderEntityTypeId])
REFERENCES [nhsd].[ProviderEntityType] ([ProviderEntityTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIdentifierType_ProviderEntityType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIdentifierType]'))
ALTER TABLE [nhsd].[ProviderIdentifierType] CHECK CONSTRAINT [FK_ProviderIdentifierType_ProviderEntityType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIdentifierType_ReferenceItem]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIdentifierType]'))
ALTER TABLE [nhsd].[ProviderIdentifierType]  WITH CHECK ADD  CONSTRAINT [FK_ProviderIdentifierType_ReferenceItem] FOREIGN KEY([IdentifierTypeReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIdentifierType_ReferenceItem]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIdentifierType]'))
ALTER TABLE [nhsd].[ProviderIdentifierType] CHECK CONSTRAINT [FK_ProviderIdentifierType_ReferenceItem]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ProviderIndividual]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ProviderIndividual](
	[ProviderIndividualId] [int] IDENTITY(1,1) NOT NULL,
	[ProviderStatusId] [int] NULL,
	[SexReferenceItemId] [int] NULL,
	[DateOfBirth] [datetime] NULL,
	[IsInSubscription] [bit] NOT NULL,
	[FamilyName] [varchar](80) NOT NULL,
	[GivenName] [varchar](80) NULL,
	[MiddleName] [varchar](80) NULL,
	[Title] [varchar](80) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderIndividual] PRIMARY KEY CLUSTERED 
(
	[ProviderIndividualId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIndividual_ProviderStatus]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIndividual]'))
ALTER TABLE [nhsd].[ProviderIndividual]  WITH CHECK ADD  CONSTRAINT [FK_ProviderIndividual_ProviderStatus] FOREIGN KEY([ProviderStatusId])
REFERENCES [nhsd].[ProviderStatus] ([ProviderStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIndividual_ProviderStatus]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIndividual]'))
ALTER TABLE [nhsd].[ProviderIndividual] CHECK CONSTRAINT [FK_ProviderIndividual_ProviderStatus]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIndividual_Sex]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIndividual]'))
ALTER TABLE [nhsd].[ProviderIndividual]  WITH CHECK ADD  CONSTRAINT [FK_ProviderIndividual_Sex] FOREIGN KEY([SexReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIndividual_Sex]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIndividual]'))
ALTER TABLE [nhsd].[ProviderIndividual] CHECK CONSTRAINT [FK_ProviderIndividual_Sex]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ProviderIndividualAlias]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ProviderIndividualAlias](
	[ProviderIndividualAliasId] [int] IDENTITY(1,1) NOT NULL,
	[ProviderIndividualId] [int] NOT NULL,
	[KnownAsTypeReferenceItemId] [int] NOT NULL,
	[Value] [varchar](160) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderIndividualAlias] PRIMARY KEY CLUSTERED 
(
	[ProviderIndividualAliasId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIndividualAlias_KnownAsType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIndividualAlias]'))
ALTER TABLE [nhsd].[ProviderIndividualAlias]  WITH CHECK ADD  CONSTRAINT [FK_ProviderIndividualAlias_KnownAsType] FOREIGN KEY([KnownAsTypeReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIndividualAlias_KnownAsType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIndividualAlias]'))
ALTER TABLE [nhsd].[ProviderIndividualAlias] CHECK CONSTRAINT [FK_ProviderIndividualAlias_KnownAsType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIndividualAlias_ProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIndividualAlias]'))
ALTER TABLE [nhsd].[ProviderIndividualAlias]  WITH CHECK ADD  CONSTRAINT [FK_ProviderIndividualAlias_ProviderIndividual] FOREIGN KEY([ProviderIndividualId])
REFERENCES [nhsd].[ProviderIndividual] ([ProviderIndividualId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIndividualAlias_ProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIndividualAlias]'))
ALTER TABLE [nhsd].[ProviderIndividualAlias] CHECK CONSTRAINT [FK_ProviderIndividualAlias_ProviderIndividual]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ProviderIndividualContact]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ProviderIndividualContact](
	[ProviderIndividualContactId] [int] IDENTITY(1,1) NOT NULL,
	[ProviderIndividualId] [int] NOT NULL,
	[ContactTypeReferenceItemId] [int] NOT NULL,
	[ContactPurposeReferenceItemId] [int] NOT NULL,
	[Value] [varchar](250) NOT NULL,
	[Preference] [bigint] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderIndividualContact_1] PRIMARY KEY CLUSTERED 
(
	[ProviderIndividualContactId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIndividualContact_ContactPurpose]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIndividualContact]'))
ALTER TABLE [nhsd].[ProviderIndividualContact]  WITH CHECK ADD  CONSTRAINT [FK_ProviderIndividualContact_ContactPurpose] FOREIGN KEY([ContactPurposeReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIndividualContact_ContactPurpose]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIndividualContact]'))
ALTER TABLE [nhsd].[ProviderIndividualContact] CHECK CONSTRAINT [FK_ProviderIndividualContact_ContactPurpose]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIndividualContact_ContactType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIndividualContact]'))
ALTER TABLE [nhsd].[ProviderIndividualContact]  WITH CHECK ADD  CONSTRAINT [FK_ProviderIndividualContact_ContactType] FOREIGN KEY([ContactTypeReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIndividualContact_ContactType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIndividualContact]'))
ALTER TABLE [nhsd].[ProviderIndividualContact] CHECK CONSTRAINT [FK_ProviderIndividualContact_ContactType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIndividualContact_ProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIndividualContact]'))
ALTER TABLE [nhsd].[ProviderIndividualContact]  WITH CHECK ADD  CONSTRAINT [FK_ProviderIndividualContact_ProviderIndividual] FOREIGN KEY([ProviderIndividualId])
REFERENCES [nhsd].[ProviderIndividual] ([ProviderIndividualId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIndividualContact_ProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIndividualContact]'))
ALTER TABLE [nhsd].[ProviderIndividualContact] CHECK CONSTRAINT [FK_ProviderIndividualContact_ProviderIndividual]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ProviderIndividualIdentifier]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ProviderIndividualIdentifier](
	[ProviderIndividualIdentifierId] [int] IDENTITY(1,1) NOT NULL,
	[ProviderIndividualId] [int] NOT NULL,
	[ProviderIdentifierStatusId] [int] NULL,
	[ProviderIdentifierTypeId] [int] NOT NULL,
	[Value] [varchar](128) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderIndividualCode] PRIMARY KEY CLUSTERED 
(
	[ProviderIndividualIdentifierId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIndividualIdentifier_ProviderIdentifierStatus]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIndividualIdentifier]'))
ALTER TABLE [nhsd].[ProviderIndividualIdentifier]  WITH CHECK ADD  CONSTRAINT [FK_ProviderIndividualIdentifier_ProviderIdentifierStatus] FOREIGN KEY([ProviderIdentifierStatusId])
REFERENCES [nhsd].[ProviderIdentifierStatus] ([ProviderIdentifierStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIndividualIdentifier_ProviderIdentifierStatus]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIndividualIdentifier]'))
ALTER TABLE [nhsd].[ProviderIndividualIdentifier] CHECK CONSTRAINT [FK_ProviderIndividualIdentifier_ProviderIdentifierStatus]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIndividualIdentifier_ProviderIdentifierType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIndividualIdentifier]'))
ALTER TABLE [nhsd].[ProviderIndividualIdentifier]  WITH CHECK ADD  CONSTRAINT [FK_ProviderIndividualIdentifier_ProviderIdentifierType] FOREIGN KEY([ProviderIdentifierTypeId])
REFERENCES [nhsd].[ProviderIdentifierType] ([ProviderIdentifierTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIndividualIdentifier_ProviderIdentifierType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIndividualIdentifier]'))
ALTER TABLE [nhsd].[ProviderIndividualIdentifier] CHECK CONSTRAINT [FK_ProviderIndividualIdentifier_ProviderIdentifierType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIndividualIdentifier_ProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIndividualIdentifier]'))
ALTER TABLE [nhsd].[ProviderIndividualIdentifier]  WITH CHECK ADD  CONSTRAINT [FK_ProviderIndividualIdentifier_ProviderIndividual] FOREIGN KEY([ProviderIndividualId])
REFERENCES [nhsd].[ProviderIndividual] ([ProviderIndividualId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderIndividualIdentifier_ProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIndividualIdentifier]'))
ALTER TABLE [nhsd].[ProviderIndividualIdentifier] CHECK CONSTRAINT [FK_ProviderIndividualIdentifier_ProviderIndividual]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ProviderLink]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ProviderLink](
	[ProviderLinkId] [int] IDENTITY(1,1) NOT NULL,
	[ProviderLocationId] [int] NOT NULL,
	[ProviderIndividualId] [int] NOT NULL,
	[LinkActiveEnd] [datetime] NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderLink] PRIMARY KEY CLUSTERED 
(
	[ProviderLinkId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLink_ProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLink]'))
ALTER TABLE [nhsd].[ProviderLink]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLink_ProviderIndividual] FOREIGN KEY([ProviderIndividualId])
REFERENCES [nhsd].[ProviderIndividual] ([ProviderIndividualId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLink_ProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLink]'))
ALTER TABLE [nhsd].[ProviderLink] CHECK CONSTRAINT [FK_ProviderLink_ProviderIndividual]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLink_ProviderLocation]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLink]'))
ALTER TABLE [nhsd].[ProviderLink]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLink_ProviderLocation] FOREIGN KEY([ProviderLocationId])
REFERENCES [nhsd].[ProviderLocation] ([ProviderLocationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLink_ProviderLocation]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLink]'))
ALTER TABLE [nhsd].[ProviderLink] CHECK CONSTRAINT [FK_ProviderLink_ProviderLocation]
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'nhsd', N'TABLE',N'ProviderLink', N'COLUMN',N'LinkActiveEnd'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'If the link is active, this column is null. Otherwise this column stores the date when the individual left the organisation.' , @level0type=N'SCHEMA',@level0name=N'nhsd', @level1type=N'TABLE',@level1name=N'ProviderLink', @level2type=N'COLUMN',@level2name=N'LinkActiveEnd'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ProviderLinkIdentifier]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ProviderLinkIdentifier](
	[ProviderLinkIdentifierId] [int] IDENTITY(1,1) NOT NULL,
	[ProviderLinkId] [int] NOT NULL,
	[ProviderIdentifierStatusId] [int] NOT NULL,
	[ProviderIdentifierTypeId] [int] NOT NULL,
	[Value] [varchar](128) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderLinkCode] PRIMARY KEY CLUSTERED 
(
	[ProviderLinkIdentifierId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLinkIdentifier_ProviderIdentifierStatus]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLinkIdentifier]'))
ALTER TABLE [nhsd].[ProviderLinkIdentifier]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLinkIdentifier_ProviderIdentifierStatus] FOREIGN KEY([ProviderIdentifierStatusId])
REFERENCES [nhsd].[ProviderIdentifierStatus] ([ProviderIdentifierStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLinkIdentifier_ProviderIdentifierStatus]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLinkIdentifier]'))
ALTER TABLE [nhsd].[ProviderLinkIdentifier] CHECK CONSTRAINT [FK_ProviderLinkIdentifier_ProviderIdentifierStatus]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLinkIdentifier_ProviderIdentifierType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLinkIdentifier]'))
ALTER TABLE [nhsd].[ProviderLinkIdentifier]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLinkIdentifier_ProviderIdentifierType] FOREIGN KEY([ProviderIdentifierTypeId])
REFERENCES [nhsd].[ProviderIdentifierType] ([ProviderIdentifierTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLinkIdentifier_ProviderIdentifierType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLinkIdentifier]'))
ALTER TABLE [nhsd].[ProviderLinkIdentifier] CHECK CONSTRAINT [FK_ProviderLinkIdentifier_ProviderIdentifierType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLinkIdentifier_ProviderLink]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLinkIdentifier]'))
ALTER TABLE [nhsd].[ProviderLinkIdentifier]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLinkIdentifier_ProviderLink] FOREIGN KEY([ProviderLinkId])
REFERENCES [nhsd].[ProviderLink] ([ProviderLinkId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLinkIdentifier_ProviderLink]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLinkIdentifier]'))
ALTER TABLE [nhsd].[ProviderLinkIdentifier] CHECK CONSTRAINT [FK_ProviderLinkIdentifier_ProviderLink]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ProviderLocation]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ProviderLocation](
	[ProviderLocationId] [int] IDENTITY(1,1) NOT NULL,
	[ProviderOrganisationId] [int] NOT NULL,
	[Name] [varchar](256) NULL,
	[Description] [varchar](256) NULL,
	[LocationActiveEnd] [datetime] NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderLocation] PRIMARY KEY CLUSTERED 
(
	[ProviderLocationId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocation_ProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocation]'))
ALTER TABLE [nhsd].[ProviderLocation]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLocation_ProviderOrganisation] FOREIGN KEY([ProviderOrganisationId])
REFERENCES [nhsd].[ProviderOrganisation] ([ProviderOrganisationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocation_ProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocation]'))
ALTER TABLE [nhsd].[ProviderLocation] CHECK CONSTRAINT [FK_ProviderLocation_ProviderOrganisation]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ProviderLocationAddress]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ProviderLocationAddress](
	[ProviderLocationAddressId] [int] IDENTITY(1,1) NOT NULL,
	[ProviderLocationId] [int] NOT NULL,
	[ContactPurposeReferenceItemId] [int] NOT NULL,
	[FlatTypeReferenceItemId] [int] NULL,
	[LevelTypeReferenceItemId] [int] NULL,
	[StreetTypeReferenceItemId] [int] NULL,
	[StreetSuffixReferenceItemId] [int] NULL,
	[PostalDeliveryTypeReferenceItemId] [int] NULL,
	[SuburbReferenceItemId] [int] NULL,
	[StateReferenceItemId] [int] NULL,
	[UnstructuredAddressLine] [varchar](120) NULL,
	[AddressSiteName] [varchar](30) NULL,
	[FlatNumber] [varchar](6) NULL,
	[LevelNumber] [varchar](4) NULL,
	[LotNumber] [varchar](15) NULL,
	[StreetNumber] [varchar](12) NULL,
	[StreetName] [varchar](30) NULL,
	[PostalDeliveryNumber] [varchar](11) NULL,
	[Latitude] [float] NULL,
	[Longitude] [float] NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderLocationAddress] PRIMARY KEY CLUSTERED 
(
	[ProviderLocationAddressId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationAddress_ContactPurpose]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationAddress]'))
ALTER TABLE [nhsd].[ProviderLocationAddress]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLocationAddress_ContactPurpose] FOREIGN KEY([ContactPurposeReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationAddress_ContactPurpose]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationAddress]'))
ALTER TABLE [nhsd].[ProviderLocationAddress] CHECK CONSTRAINT [FK_ProviderLocationAddress_ContactPurpose]
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationAddress_ContactType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationAddress]'))
ALTER TABLE [nhsd].[ProviderLocationAddress] CHECK CONSTRAINT [FK_ProviderLocationAddress_ContactType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationAddress_FlatType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationAddress]'))
ALTER TABLE [nhsd].[ProviderLocationAddress]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLocationAddress_FlatType] FOREIGN KEY([FlatTypeReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationAddress_FlatType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationAddress]'))
ALTER TABLE [nhsd].[ProviderLocationAddress] CHECK CONSTRAINT [FK_ProviderLocationAddress_FlatType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationAddress_LevelType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationAddress]'))
ALTER TABLE [nhsd].[ProviderLocationAddress]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLocationAddress_LevelType] FOREIGN KEY([LevelTypeReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationAddress_LevelType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationAddress]'))
ALTER TABLE [nhsd].[ProviderLocationAddress] CHECK CONSTRAINT [FK_ProviderLocationAddress_LevelType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationAddress_PostalDeliveryType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationAddress]'))
ALTER TABLE [nhsd].[ProviderLocationAddress]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLocationAddress_PostalDeliveryType] FOREIGN KEY([PostalDeliveryTypeReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationAddress_PostalDeliveryType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationAddress]'))
ALTER TABLE [nhsd].[ProviderLocationAddress] CHECK CONSTRAINT [FK_ProviderLocationAddress_PostalDeliveryType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationAddress_ProviderLocation]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationAddress]'))
ALTER TABLE [nhsd].[ProviderLocationAddress]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLocationAddress_ProviderLocation] FOREIGN KEY([ProviderLocationId])
REFERENCES [nhsd].[ProviderLocation] ([ProviderLocationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationAddress_ProviderLocation]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationAddress]'))
ALTER TABLE [nhsd].[ProviderLocationAddress] CHECK CONSTRAINT [FK_ProviderLocationAddress_ProviderLocation]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationAddress_State]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationAddress]'))
ALTER TABLE [nhsd].[ProviderLocationAddress]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLocationAddress_State] FOREIGN KEY([StateReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationAddress_State]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationAddress]'))
ALTER TABLE [nhsd].[ProviderLocationAddress] CHECK CONSTRAINT [FK_ProviderLocationAddress_State]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationAddress_StreetSuffix]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationAddress]'))
ALTER TABLE [nhsd].[ProviderLocationAddress]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLocationAddress_StreetSuffix] FOREIGN KEY([StreetSuffixReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationAddress_StreetSuffix]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationAddress]'))
ALTER TABLE [nhsd].[ProviderLocationAddress] CHECK CONSTRAINT [FK_ProviderLocationAddress_StreetSuffix]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationAddress_StreetType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationAddress]'))
ALTER TABLE [nhsd].[ProviderLocationAddress]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLocationAddress_StreetType] FOREIGN KEY([StreetTypeReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationAddress_StreetType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationAddress]'))
ALTER TABLE [nhsd].[ProviderLocationAddress] CHECK CONSTRAINT [FK_ProviderLocationAddress_StreetType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationAddress_Suburb]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationAddress]'))
ALTER TABLE [nhsd].[ProviderLocationAddress]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLocationAddress_Suburb] FOREIGN KEY([SuburbReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationAddress_Suburb]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationAddress]'))
ALTER TABLE [nhsd].[ProviderLocationAddress] CHECK CONSTRAINT [FK_ProviderLocationAddress_Suburb]
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'nhsd', N'TABLE',N'ProviderLocationAddress', N'COLUMN',N'ProviderLocationId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Specification of the Provider Organisation to which this Address belongs.' , @level0type=N'SCHEMA',@level0name=N'nhsd', @level1type=N'TABLE',@level1name=N'ProviderLocationAddress', @level2type=N'COLUMN',@level2name=N'ProviderLocationId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'nhsd', N'TABLE',N'ProviderLocationAddress', N'COLUMN',N'FlatTypeReferenceItemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The specification of the type of a separately identifiable portion within a building/complex, marina etc. to clearly distinguish it from another.' , @level0type=N'SCHEMA',@level0name=N'nhsd', @level1type=N'TABLE',@level1name=N'ProviderLocationAddress', @level2type=N'COLUMN',@level2name=N'FlatTypeReferenceItemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'nhsd', N'TABLE',N'ProviderLocationAddress', N'COLUMN',N'LevelTypeReferenceItemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor used to classify the type of floor or level of a multi-storey building/complex' , @level0type=N'SCHEMA',@level0name=N'nhsd', @level1type=N'TABLE',@level1name=N'ProviderLocationAddress', @level2type=N'COLUMN',@level2name=N'LevelTypeReferenceItemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'nhsd', N'TABLE',N'ProviderLocationAddress', N'COLUMN',N'StreetTypeReferenceItemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A code that identifies the type of public thoroughfare.' , @level0type=N'SCHEMA',@level0name=N'nhsd', @level1type=N'TABLE',@level1name=N'ProviderLocationAddress', @level2type=N'COLUMN',@level2name=N'StreetTypeReferenceItemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'nhsd', N'TABLE',N'ProviderLocationAddress', N'COLUMN',N'StreetSuffixReferenceItemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Term used to qualify Street Name used for directional references.' , @level0type=N'SCHEMA',@level0name=N'nhsd', @level1type=N'TABLE',@level1name=N'ProviderLocationAddress', @level2type=N'COLUMN',@level2name=N'StreetSuffixReferenceItemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'nhsd', N'TABLE',N'ProviderLocationAddress', N'COLUMN',N'PostalDeliveryTypeReferenceItemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identification for the channel of postal delivery.' , @level0type=N'SCHEMA',@level0name=N'nhsd', @level1type=N'TABLE',@level1name=N'ProviderLocationAddress', @level2type=N'COLUMN',@level2name=N'PostalDeliveryTypeReferenceItemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'nhsd', N'TABLE',N'ProviderLocationAddress', N'COLUMN',N'SuburbReferenceItemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The full name of the general locality containing the specific address of an individual.' , @level0type=N'SCHEMA',@level0name=N'nhsd', @level1type=N'TABLE',@level1name=N'ProviderLocationAddress', @level2type=N'COLUMN',@level2name=N'SuburbReferenceItemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'nhsd', N'TABLE',N'ProviderLocationAddress', N'COLUMN',N'StateReferenceItemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An identifier of the Australian State or Territory in which an individual is located.' , @level0type=N'SCHEMA',@level0name=N'nhsd', @level1type=N'TABLE',@level1name=N'ProviderLocationAddress', @level2type=N'COLUMN',@level2name=N'StateReferenceItemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'nhsd', N'TABLE',N'ProviderLocationAddress', N'COLUMN',N'UnstructuredAddressLine'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A composite of one or more standard address components that describes a low level of geographic/physical description of a location that, used in conjunction with other high-level address components, forms a complete geographical/physical address.' , @level0type=N'SCHEMA',@level0name=N'nhsd', @level1type=N'TABLE',@level1name=N'ProviderLocationAddress', @level2type=N'COLUMN',@level2name=N'UnstructuredAddressLine'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'nhsd', N'TABLE',N'ProviderLocationAddress', N'COLUMN',N'AddressSiteName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The full name used to identify the physical building or property as part of its location.' , @level0type=N'SCHEMA',@level0name=N'nhsd', @level1type=N'TABLE',@level1name=N'ProviderLocationAddress', @level2type=N'COLUMN',@level2name=N'AddressSiteName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'nhsd', N'TABLE',N'ProviderLocationAddress', N'COLUMN',N'FlatNumber'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The specification of the number or identifier of a building/complex, marina etc. to clearly distinguish it from another.' , @level0type=N'SCHEMA',@level0name=N'nhsd', @level1type=N'TABLE',@level1name=N'ProviderLocationAddress', @level2type=N'COLUMN',@level2name=N'FlatNumber'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'nhsd', N'TABLE',N'ProviderLocationAddress', N'COLUMN',N'LevelNumber'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor used to identify the floor or level of a multi-storey building/complex.' , @level0type=N'SCHEMA',@level0name=N'nhsd', @level1type=N'TABLE',@level1name=N'ProviderLocationAddress', @level2type=N'COLUMN',@level2name=N'LevelNumber'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'nhsd', N'TABLE',N'ProviderLocationAddress', N'COLUMN',N'LotNumber'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The Australian Lot reference allocated to an address in the absence of street numbering.' , @level0type=N'SCHEMA',@level0name=N'nhsd', @level1type=N'TABLE',@level1name=N'ProviderLocationAddress', @level2type=N'COLUMN',@level2name=N'LotNumber'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'nhsd', N'TABLE',N'ProviderLocationAddress', N'COLUMN',N'StreetNumber'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The numeric or alphanumeric reference number of a house or property that is unique within a street name.' , @level0type=N'SCHEMA',@level0name=N'nhsd', @level1type=N'TABLE',@level1name=N'ProviderLocationAddress', @level2type=N'COLUMN',@level2name=N'StreetNumber'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'nhsd', N'TABLE',N'ProviderLocationAddress', N'COLUMN',N'StreetName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name that identifies a public thoroughfare and differentiates it from others in the same suburb/town/locality.' , @level0type=N'SCHEMA',@level0name=N'nhsd', @level1type=N'TABLE',@level1name=N'ProviderLocationAddress', @level2type=N'COLUMN',@level2name=N'StreetName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'nhsd', N'TABLE',N'ProviderLocationAddress', N'COLUMN',N'PostalDeliveryNumber'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identification number for the channel of postal delivery.' , @level0type=N'SCHEMA',@level0name=N'nhsd', @level1type=N'TABLE',@level1name=N'ProviderLocationAddress', @level2type=N'COLUMN',@level2name=N'PostalDeliveryNumber'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ProviderLocationClassification]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ProviderLocationClassification](
	[ProviderLocationId] [int] NOT NULL,
	[ClassificationReferenceItemId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderOrganisationServiceClassification] PRIMARY KEY CLUSTERED 
(
	[ProviderLocationId] ASC,
	[ClassificationReferenceItemId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationClassification_ProviderLocation]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationClassification]'))
ALTER TABLE [nhsd].[ProviderLocationClassification]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLocationClassification_ProviderLocation] FOREIGN KEY([ProviderLocationId])
REFERENCES [nhsd].[ProviderLocation] ([ProviderLocationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationClassification_ProviderLocation]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationClassification]'))
ALTER TABLE [nhsd].[ProviderLocationClassification] CHECK CONSTRAINT [FK_ProviderLocationClassification_ProviderLocation]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationClassification_ReferenceItem]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationClassification]'))
ALTER TABLE [nhsd].[ProviderLocationClassification]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLocationClassification_ReferenceItem] FOREIGN KEY([ClassificationReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationClassification_ReferenceItem]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationClassification]'))
ALTER TABLE [nhsd].[ProviderLocationClassification] CHECK CONSTRAINT [FK_ProviderLocationClassification_ReferenceItem]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ProviderLocationContact]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ProviderLocationContact](
	[ProviderLocationContactId] [int] IDENTITY(1,1) NOT NULL,
	[ProviderLocationId] [int] NOT NULL,
	[ContactPurposeReferenceItemId] [int] NOT NULL,
	[ContactTypeReferenceItemId] [int] NOT NULL,
	[Value] [varchar](250) NOT NULL,
	[Preference] [bigint] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderLocationContact] PRIMARY KEY CLUSTERED 
(
	[ProviderLocationContactId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationContact_ContactPurpose]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationContact]'))
ALTER TABLE [nhsd].[ProviderLocationContact]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLocationContact_ContactPurpose] FOREIGN KEY([ContactPurposeReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationContact_ContactPurpose]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationContact]'))
ALTER TABLE [nhsd].[ProviderLocationContact] CHECK CONSTRAINT [FK_ProviderLocationContact_ContactPurpose]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationContact_ContactType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationContact]'))
ALTER TABLE [nhsd].[ProviderLocationContact]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLocationContact_ContactType] FOREIGN KEY([ContactTypeReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationContact_ContactType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationContact]'))
ALTER TABLE [nhsd].[ProviderLocationContact] CHECK CONSTRAINT [FK_ProviderLocationContact_ContactType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationContact_ProviderLocation]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationContact]'))
ALTER TABLE [nhsd].[ProviderLocationContact]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLocationContact_ProviderLocation] FOREIGN KEY([ProviderLocationId])
REFERENCES [nhsd].[ProviderLocation] ([ProviderLocationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationContact_ProviderLocation]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationContact]'))
ALTER TABLE [nhsd].[ProviderLocationContact] CHECK CONSTRAINT [FK_ProviderLocationContact_ProviderLocation]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ProviderLocationIdentifier]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ProviderLocationIdentifier](
	[ProviderLocationIdentifierId] [int] IDENTITY(1,1) NOT NULL,
	[ProviderLocationId] [int] NOT NULL,
	[ProviderIdentifierStatusId] [int] NULL,
	[ProviderIdentifierTypeId] [int] NOT NULL,
	[Value] [varchar](128) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderLocationIdentifier] PRIMARY KEY CLUSTERED 
(
	[ProviderLocationIdentifierId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationIdentifier_ProviderIdentifierStatus]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationIdentifier]'))
ALTER TABLE [nhsd].[ProviderLocationIdentifier]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLocationIdentifier_ProviderIdentifierStatus] FOREIGN KEY([ProviderIdentifierStatusId])
REFERENCES [nhsd].[ProviderIdentifierStatus] ([ProviderIdentifierStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationIdentifier_ProviderIdentifierStatus]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationIdentifier]'))
ALTER TABLE [nhsd].[ProviderLocationIdentifier] CHECK CONSTRAINT [FK_ProviderLocationIdentifier_ProviderIdentifierStatus]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationIdentifier_ProviderIdentifierType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationIdentifier]'))
ALTER TABLE [nhsd].[ProviderLocationIdentifier]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLocationIdentifier_ProviderIdentifierType] FOREIGN KEY([ProviderIdentifierTypeId])
REFERENCES [nhsd].[ProviderIdentifierType] ([ProviderIdentifierTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationIdentifier_ProviderIdentifierType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationIdentifier]'))
ALTER TABLE [nhsd].[ProviderLocationIdentifier] CHECK CONSTRAINT [FK_ProviderLocationIdentifier_ProviderIdentifierType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationIdentifier_ProviderLocation]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationIdentifier]'))
ALTER TABLE [nhsd].[ProviderLocationIdentifier]  WITH CHECK ADD  CONSTRAINT [FK_ProviderLocationIdentifier_ProviderLocation] FOREIGN KEY([ProviderLocationId])
REFERENCES [nhsd].[ProviderLocation] ([ProviderLocationId])
ON DELETE CASCADE
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderLocationIdentifier_ProviderLocation]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationIdentifier]'))
ALTER TABLE [nhsd].[ProviderLocationIdentifier] CHECK CONSTRAINT [FK_ProviderLocationIdentifier_ProviderLocation]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ProviderOccupation]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ProviderOccupation](
	[ProviderIndividualId] [int] NOT NULL,
	[OccupationReferenceItemId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderIndividualService] PRIMARY KEY CLUSTERED 
(
	[ProviderIndividualId] ASC,
	[OccupationReferenceItemId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderOccupation_ProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderOccupation]'))
ALTER TABLE [nhsd].[ProviderOccupation]  WITH CHECK ADD  CONSTRAINT [FK_ProviderOccupation_ProviderIndividual] FOREIGN KEY([ProviderIndividualId])
REFERENCES [nhsd].[ProviderIndividual] ([ProviderIndividualId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderOccupation_ProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderOccupation]'))
ALTER TABLE [nhsd].[ProviderOccupation] CHECK CONSTRAINT [FK_ProviderOccupation_ProviderIndividual]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderOccupation_ReferenceItem]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderOccupation]'))
ALTER TABLE [nhsd].[ProviderOccupation]  WITH CHECK ADD  CONSTRAINT [FK_ProviderOccupation_ReferenceItem] FOREIGN KEY([OccupationReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderOccupation_ReferenceItem]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderOccupation]'))
ALTER TABLE [nhsd].[ProviderOccupation] CHECK CONSTRAINT [FK_ProviderOccupation_ReferenceItem]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ProviderOrganisation]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ProviderOrganisation](
	[ProviderOrganisationId] [int] IDENTITY(1,1) NOT NULL,
	[ProviderStatusId] [int] NULL,
	[OrganisationDescription] [varchar](200) NULL,
	[LegalName] [varchar](255) NULL,
	[IsInSubscription] [bit] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderOrganisation] PRIMARY KEY CLUSTERED 
(
	[ProviderOrganisationId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderOrganisation_ProviderStatus]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderOrganisation]'))
ALTER TABLE [nhsd].[ProviderOrganisation]  WITH CHECK ADD  CONSTRAINT [FK_ProviderOrganisation_ProviderStatus] FOREIGN KEY([ProviderStatusId])
REFERENCES [nhsd].[ProviderStatus] ([ProviderStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderOrganisation_ProviderStatus]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderOrganisation]'))
ALTER TABLE [nhsd].[ProviderOrganisation] CHECK CONSTRAINT [FK_ProviderOrganisation_ProviderStatus]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ProviderOrganisationIdentifier]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ProviderOrganisationIdentifier](
	[ProviderOrganisationIdentifierId] [int] IDENTITY(1,1) NOT NULL,
	[ProviderOrganisationId] [int] NOT NULL,
	[ProviderIdentifierStatusId] [int] NULL,
	[ProviderIdentifierTypeId] [int] NOT NULL,
	[Value] [varchar](128) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderOrganisationIdentifier] PRIMARY KEY CLUSTERED 
(
	[ProviderOrganisationIdentifierId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderOrganisationIdentifier_ProviderIdentifierStatus]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderOrganisationIdentifier]'))
ALTER TABLE [nhsd].[ProviderOrganisationIdentifier]  WITH CHECK ADD  CONSTRAINT [FK_ProviderOrganisationIdentifier_ProviderIdentifierStatus] FOREIGN KEY([ProviderIdentifierStatusId])
REFERENCES [nhsd].[ProviderIdentifierStatus] ([ProviderIdentifierStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderOrganisationIdentifier_ProviderIdentifierStatus]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderOrganisationIdentifier]'))
ALTER TABLE [nhsd].[ProviderOrganisationIdentifier] CHECK CONSTRAINT [FK_ProviderOrganisationIdentifier_ProviderIdentifierStatus]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderOrganisationIdentifier_ProviderIdentifierType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderOrganisationIdentifier]'))
ALTER TABLE [nhsd].[ProviderOrganisationIdentifier]  WITH CHECK ADD  CONSTRAINT [FK_ProviderOrganisationIdentifier_ProviderIdentifierType] FOREIGN KEY([ProviderIdentifierTypeId])
REFERENCES [nhsd].[ProviderIdentifierType] ([ProviderIdentifierTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderOrganisationIdentifier_ProviderIdentifierType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderOrganisationIdentifier]'))
ALTER TABLE [nhsd].[ProviderOrganisationIdentifier] CHECK CONSTRAINT [FK_ProviderOrganisationIdentifier_ProviderIdentifierType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderOrganisationIdentifier_ProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderOrganisationIdentifier]'))
ALTER TABLE [nhsd].[ProviderOrganisationIdentifier]  WITH CHECK ADD  CONSTRAINT [FK_ProviderOrganisationIdentifier_ProviderOrganisation] FOREIGN KEY([ProviderOrganisationId])
REFERENCES [nhsd].[ProviderOrganisation] ([ProviderOrganisationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderOrganisationIdentifier_ProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderOrganisationIdentifier]'))
ALTER TABLE [nhsd].[ProviderOrganisationIdentifier] CHECK CONSTRAINT [FK_ProviderOrganisationIdentifier_ProviderOrganisation]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ProviderOrganisationName]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ProviderOrganisationName](
	[ProviderOrganisationId] [int] NOT NULL,
	[KnownAsTypeReferenceItemId] [int] NOT NULL,
	[Value] [varchar](60) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderOrganisationNameType] PRIMARY KEY CLUSTERED 
(
	[ProviderOrganisationId] ASC,
	[KnownAsTypeReferenceItemId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderOrganisationName_KnownAsType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderOrganisationName]'))
ALTER TABLE [nhsd].[ProviderOrganisationName]  WITH CHECK ADD  CONSTRAINT [FK_ProviderOrganisationName_KnownAsType] FOREIGN KEY([KnownAsTypeReferenceItemId])
REFERENCES [nhsd].[ReferenceItem] ([ReferenceItemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderOrganisationName_KnownAsType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderOrganisationName]'))
ALTER TABLE [nhsd].[ProviderOrganisationName] CHECK CONSTRAINT [FK_ProviderOrganisationName_KnownAsType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderOrganisationName_ProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderOrganisationName]'))
ALTER TABLE [nhsd].[ProviderOrganisationName]  WITH CHECK ADD  CONSTRAINT [FK_ProviderOrganisationName_ProviderOrganisation] FOREIGN KEY([ProviderOrganisationId])
REFERENCES [nhsd].[ProviderOrganisation] ([ProviderOrganisationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ProviderOrganisationName_ProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderOrganisationName]'))
ALTER TABLE [nhsd].[ProviderOrganisationName] CHECK CONSTRAINT [FK_ProviderOrganisationName_ProviderOrganisation]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ProviderStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ProviderStatus](
	[ProviderStatusId] [int] NOT NULL,
	[Code] [varchar](40) NOT NULL,
	[Description] [varchar](256) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderStatus] PRIMARY KEY CLUSTERED 
(
	[ProviderStatusId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ReferenceItem]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ReferenceItem](
	[ReferenceItemId] [int] IDENTITY(1,1) NOT NULL,
	[ReferenceSetId] [int] NULL,
	[Code] [varchar](64) NULL,
	[SubCode] [varchar](64) NULL,
	[Uri] [varchar](128) NOT NULL,
	[Name] [varchar](256) NULL,
	[DisplayName] [varchar](256) NULL,
	[Status] [varchar](64) NULL,
	[Description] [varchar](256) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_OrganisationService] PRIMARY KEY CLUSTERED 
(
	[ReferenceItemId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ReferenceItem_ReferenceSet]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ReferenceItem]'))
ALTER TABLE [nhsd].[ReferenceItem]  WITH CHECK ADD  CONSTRAINT [FK_ReferenceItem_ReferenceSet] FOREIGN KEY([ReferenceSetId])
REFERENCES [nhsd].[ReferenceSet] ([ReferenceSetId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ReferenceItem_ReferenceSet]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ReferenceItem]'))
ALTER TABLE [nhsd].[ReferenceItem] CHECK CONSTRAINT [FK_ReferenceItem_ReferenceSet]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ReferenceProfile]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ReferenceProfile](
	[ReferenceProfileId] [int] IDENTITY(1,1) NOT NULL,
	[Uri] [varchar](64) NOT NULL,
	[Name] [varchar](64) NULL,
	[DisplayName] [varchar](64) NULL,
	[Status] [varchar](64) NULL,
	[Owner] [varchar](64) NULL,
	[Version] [varchar](64) NULL,
	[Description] [varchar](64) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ReferenceProfile] PRIMARY KEY CLUSTERED 
(
	[ReferenceProfileId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[nhsd].[ReferenceSet]') AND type in (N'U'))
BEGIN
CREATE TABLE [nhsd].[ReferenceSet](
	[ReferenceSetId] [int] IDENTITY(1,1) NOT NULL,
	[ReferenceProfileId] [int] NOT NULL,
	[RelatedReferenceSetId] [int] NULL,
	[Uri] [varchar](128) NULL,
	[Name] [varchar](64) NULL,
	[DisplayName] [varchar](64) NULL,
	[Status] [varchar](64) NULL,
	[RelationshipType] [varchar](64) NULL,
	[Category] [varchar](64) NULL,
	[Description] [varchar](64) NULL,
	[UpdateFrequency] [int] NOT NULL,
	[DateLastUpdated] [datetime] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderType] PRIMARY KEY CLUSTERED 
(
	[ReferenceSetId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ReferenceSet_ReferenceProfile]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ReferenceSet]'))
ALTER TABLE [nhsd].[ReferenceSet]  WITH CHECK ADD  CONSTRAINT [FK_ReferenceSet_ReferenceProfile] FOREIGN KEY([ReferenceProfileId])
REFERENCES [nhsd].[ReferenceProfile] ([ReferenceProfileId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_ReferenceSet_ReferenceProfile]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ReferenceSet]'))
ALTER TABLE [nhsd].[ReferenceSet] CHECK CONSTRAINT [FK_ReferenceSet_ReferenceProfile]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_RelatedReferenceSet]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ReferenceSet]'))
ALTER TABLE [nhsd].[ReferenceSet]  WITH CHECK ADD  CONSTRAINT [FK_RelatedReferenceSet] FOREIGN KEY([RelatedReferenceSetId])
REFERENCES [nhsd].[ReferenceSet] ([ReferenceSetId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[nhsd].[FK_RelatedReferenceSet]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ReferenceSet]'))
ALTER TABLE [nhsd].[ReferenceSet] CHECK CONSTRAINT [FK_RelatedReferenceSet]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[p2p].[AccessingOrganisation]') AND type in (N'U'))
BEGIN
CREATE TABLE [p2p].[AccessingOrganisation](
	[AccessingOrganisationId] [int] IDENTITY(1,1) NOT NULL,
	[AccessingOrganisationNetworkId] [int] NOT NULL,
	[HpiO] [varchar](16) NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[SmdClientCertSerial] [varchar](32) NOT NULL,
	[NepsClientCertSerial] [varchar](32) NOT NULL,
	[SmdPayloadEncryptionCertSerial] [varchar](32) NOT NULL,
	[AuthorisedEmployeeName] [varchar](100) NULL,
	[AuthorisedEmployeeUserId] [varchar](30) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HealthProviderOrganisation] PRIMARY KEY CLUSTERED 
(
	[AccessingOrganisationId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_AccessingOrganisation_AccessingOrganisationNetwork]') AND parent_object_id = OBJECT_ID(N'[p2p].[AccessingOrganisation]'))
ALTER TABLE [p2p].[AccessingOrganisation]  WITH CHECK ADD  CONSTRAINT [FK_AccessingOrganisation_AccessingOrganisationNetwork] FOREIGN KEY([AccessingOrganisationNetworkId])
REFERENCES [p2p].[AccessingOrganisationNetwork] ([AccessingOrganisationNetworkId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_AccessingOrganisation_AccessingOrganisationNetwork]') AND parent_object_id = OBJECT_ID(N'[p2p].[AccessingOrganisation]'))
ALTER TABLE [p2p].[AccessingOrganisation] CHECK CONSTRAINT [FK_AccessingOrganisation_AccessingOrganisationNetwork]
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'p2p', N'TABLE',N'AccessingOrganisation', N'COLUMN',N'AccessingOrganisationId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Represents an organisation in the HPI-O network structure.' , @level0type=N'SCHEMA',@level0name=N'p2p', @level1type=N'TABLE',@level1name=N'AccessingOrganisation', @level2type=N'COLUMN',@level2name=N'AccessingOrganisationId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'p2p', N'TABLE',N'AccessingOrganisation', N'COLUMN',N'AccessingOrganisationNetworkId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Represents the organisation network that this organisation belongs to.' , @level0type=N'SCHEMA',@level0name=N'p2p', @level1type=N'TABLE',@level1name=N'AccessingOrganisation', @level2type=N'COLUMN',@level2name=N'AccessingOrganisationNetworkId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'p2p', N'TABLE',N'AccessingOrganisation', N'COLUMN',N'HpiO'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'National identifier for health provider organisation.' , @level0type=N'SCHEMA',@level0name=N'p2p', @level1type=N'TABLE',@level1name=N'AccessingOrganisation', @level2type=N'COLUMN',@level2name=N'HpiO'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'p2p', N'TABLE',N'AccessingOrganisation', N'COLUMN',N'Name'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name of the organisation.' , @level0type=N'SCHEMA',@level0name=N'p2p', @level1type=N'TABLE',@level1name=N'AccessingOrganisation', @level2type=N'COLUMN',@level2name=N'Name'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'p2p', N'TABLE',N'AccessingOrganisation', N'COLUMN',N'SmdClientCertSerial'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hexadecimal serial number for certificate used to establish connections to SMD Front-End Server.' , @level0type=N'SCHEMA',@level0name=N'p2p', @level1type=N'TABLE',@level1name=N'AccessingOrganisation', @level2type=N'COLUMN',@level2name=N'SmdClientCertSerial'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'p2p', N'TABLE',N'AccessingOrganisation', N'COLUMN',N'NepsClientCertSerial'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hexadecimal serial number for certificate used to establish connections to National Endpoint Proxy Service.' , @level0type=N'SCHEMA',@level0name=N'p2p', @level1type=N'TABLE',@level1name=N'AccessingOrganisation', @level2type=N'COLUMN',@level2name=N'NepsClientCertSerial'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'p2p', N'TABLE',N'AccessingOrganisation', N'COLUMN',N'SmdPayloadEncryptionCertSerial'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hexadecimal serial number for certificate used to sign and decrypt sealed messages for this organisation.' , @level0type=N'SCHEMA',@level0name=N'p2p', @level1type=N'TABLE',@level1name=N'AccessingOrganisation', @level2type=N'COLUMN',@level2name=N'SmdPayloadEncryptionCertSerial'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'p2p', N'TABLE',N'AccessingOrganisation', N'COLUMN',N'AuthorisedEmployeeName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User Name of the Authorised Employee for this HPIO.' , @level0type=N'SCHEMA',@level0name=N'p2p', @level1type=N'TABLE',@level1name=N'AccessingOrganisation', @level2type=N'COLUMN',@level2name=N'AuthorisedEmployeeName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'p2p', N'TABLE',N'AccessingOrganisation', N'COLUMN',N'AuthorisedEmployeeUserId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name of the Authorised Employee for this HPIO.' , @level0type=N'SCHEMA',@level0name=N'p2p', @level1type=N'TABLE',@level1name=N'AccessingOrganisation', @level2type=N'COLUMN',@level2name=N'AuthorisedEmployeeUserId'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[p2p].[AccessingOrganisationNetwork]') AND type in (N'U'))
BEGIN
CREATE TABLE [p2p].[AccessingOrganisationNetwork](
	[AccessingOrganisationNetworkId] [int] IDENTITY(1,1) NOT NULL,
	[SeedHpio] [varchar](16) NOT NULL,
	[SeedName] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HealthProviderOrganisationNetwork] PRIMARY KEY CLUSTERED 
(
	[AccessingOrganisationNetworkId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[p2p].[Change]') AND type in (N'U'))
BEGIN
CREATE TABLE [p2p].[Change](
	[ChangeId] [int] IDENTITY(1,1) NOT NULL,
	[ChangeTypeId] [int] NOT NULL,
	[ProviderOrganisationId] [int] NULL,
	[ProviderLocationId] [int] NULL,
	[ProviderLinkId] [int] NULL,
	[ProviderIndividualId] [int] NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Change] PRIMARY KEY CLUSTERED 
(
	[ChangeId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_Change_ChangeType]') AND parent_object_id = OBJECT_ID(N'[p2p].[Change]'))
ALTER TABLE [p2p].[Change]  WITH CHECK ADD  CONSTRAINT [FK_Change_ChangeType] FOREIGN KEY([ChangeTypeId])
REFERENCES [p2p].[ChangeType] ([ChangeTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_Change_ChangeType]') AND parent_object_id = OBJECT_ID(N'[p2p].[Change]'))
ALTER TABLE [p2p].[Change] CHECK CONSTRAINT [FK_Change_ChangeType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_Change_ProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[p2p].[Change]'))
ALTER TABLE [p2p].[Change]  WITH CHECK ADD  CONSTRAINT [FK_Change_ProviderIndividual] FOREIGN KEY([ProviderIndividualId])
REFERENCES [nhsd].[ProviderIndividual] ([ProviderIndividualId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_Change_ProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[p2p].[Change]'))
ALTER TABLE [p2p].[Change] CHECK CONSTRAINT [FK_Change_ProviderIndividual]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_Change_ProviderLink]') AND parent_object_id = OBJECT_ID(N'[p2p].[Change]'))
ALTER TABLE [p2p].[Change]  WITH CHECK ADD  CONSTRAINT [FK_Change_ProviderLink] FOREIGN KEY([ProviderLinkId])
REFERENCES [nhsd].[ProviderLink] ([ProviderLinkId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_Change_ProviderLink]') AND parent_object_id = OBJECT_ID(N'[p2p].[Change]'))
ALTER TABLE [p2p].[Change] CHECK CONSTRAINT [FK_Change_ProviderLink]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_Change_ProviderLocation]') AND parent_object_id = OBJECT_ID(N'[p2p].[Change]'))
ALTER TABLE [p2p].[Change]  WITH CHECK ADD  CONSTRAINT [FK_Change_ProviderLocation] FOREIGN KEY([ProviderLocationId])
REFERENCES [nhsd].[ProviderLocation] ([ProviderLocationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_Change_ProviderLocation]') AND parent_object_id = OBJECT_ID(N'[p2p].[Change]'))
ALTER TABLE [p2p].[Change] CHECK CONSTRAINT [FK_Change_ProviderLocation]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_Change_ProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[p2p].[Change]'))
ALTER TABLE [p2p].[Change]  WITH CHECK ADD  CONSTRAINT [FK_Change_ProviderOrganisation] FOREIGN KEY([ProviderOrganisationId])
REFERENCES [nhsd].[ProviderOrganisation] ([ProviderOrganisationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_Change_ProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[p2p].[Change]'))
ALTER TABLE [p2p].[Change] CHECK CONSTRAINT [FK_Change_ProviderOrganisation]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[p2p].[ChangeType]') AND type in (N'U'))
BEGIN
CREATE TABLE [p2p].[ChangeType](
	[ChangeTypeId] [int] NOT NULL,
	[Description] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ChangeType] PRIMARY KEY CLUSTERED 
(
	[ChangeTypeId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[p2p].[LogEntry]') AND type in (N'U'))
BEGIN
CREATE TABLE [p2p].[LogEntry](
	[LogEntryId] [int] IDENTITY(1,1) NOT NULL,
	[Level] [varchar](50) NOT NULL,
	[Logger] [varchar](255) NOT NULL,
	[Message] [varchar](max) NOT NULL,
	[Exception] [varchar](max) NULL,
	[Action] [varchar](255) NULL,
	[MessageId] [varchar](255) NULL,
	[AccessingHpio] [varchar](16) NOT NULL,
	[UserName] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_LogEntry] PRIMARY KEY CLUSTERED 
(
	[LogEntryId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[p2p].[ProviderIndividualHpii]') AND type in (N'U'))
BEGIN
CREATE TABLE [p2p].[ProviderIndividualHpii](
	[ProviderIndividualId] [int] NOT NULL,
	[AccessingOrganisationNetworkId] [int] NOT NULL,
	[ProviderIdentifierStatusId] [int] NULL,
	[FamilyName] [varchar](160) NULL,
    [GivenNames] [varchar](160) NULL,
    [AHPRA] [varchar](128) NULL,
	[Value] [varchar](16) NOT NULL,
	[DateLastValidated] [datetime] NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderIndividualHpii] PRIMARY KEY CLUSTERED 
(
	[ProviderIndividualId] ASC,
	[AccessingOrganisationNetworkId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_ProviderIndividualHpii_AccessingOrganisationNetwork]') AND parent_object_id = OBJECT_ID(N'[p2p].[ProviderIndividualHpii]'))
ALTER TABLE [p2p].[ProviderIndividualHpii]  WITH CHECK ADD  CONSTRAINT [FK_ProviderIndividualHpii_AccessingOrganisationNetwork] FOREIGN KEY([AccessingOrganisationNetworkId])
REFERENCES [p2p].[AccessingOrganisationNetwork] ([AccessingOrganisationNetworkId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_ProviderIndividualHpii_AccessingOrganisationNetwork]') AND parent_object_id = OBJECT_ID(N'[p2p].[ProviderIndividualHpii]'))
ALTER TABLE [p2p].[ProviderIndividualHpii] CHECK CONSTRAINT [FK_ProviderIndividualHpii_AccessingOrganisationNetwork]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_ProviderIndividualHpii_ProviderIdentifierStatus]') AND parent_object_id = OBJECT_ID(N'[p2p].[ProviderIndividualHpii]'))
ALTER TABLE [p2p].[ProviderIndividualHpii]  WITH CHECK ADD  CONSTRAINT [FK_ProviderIndividualHpii_ProviderIdentifierStatus] FOREIGN KEY([ProviderIdentifierStatusId])
REFERENCES [nhsd].[ProviderIdentifierStatus] ([ProviderIdentifierStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_ProviderIndividualHpii_ProviderIdentifierStatus]') AND parent_object_id = OBJECT_ID(N'[p2p].[ProviderIndividualHpii]'))
ALTER TABLE [p2p].[ProviderIndividualHpii] CHECK CONSTRAINT [FK_ProviderIndividualHpii_ProviderIdentifierStatus]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_ProviderIndividualHpii_ProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[p2p].[ProviderIndividualHpii]'))
ALTER TABLE [p2p].[ProviderIndividualHpii]  WITH CHECK ADD  CONSTRAINT [FK_ProviderIndividualHpii_ProviderIndividual] FOREIGN KEY([ProviderIndividualId])
REFERENCES [nhsd].[ProviderIndividual] ([ProviderIndividualId])
ON DELETE CASCADE
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_ProviderIndividualHpii_ProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[p2p].[ProviderIndividualHpii]'))
ALTER TABLE [p2p].[ProviderIndividualHpii] CHECK CONSTRAINT [FK_ProviderIndividualHpii_ProviderIndividual]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[p2p].[ProviderOrganisationHpio]') AND type in (N'U'))
BEGIN
CREATE TABLE [p2p].[ProviderOrganisationHpio](
	[ProviderOrganisationId] [int] NOT NULL,
	[AccessingOrganisationNetworkId] [int] NOT NULL,
	[ProviderIdentifierStatusId] [int] NULL,
	[Value] [varchar](16) NOT NULL,
	[LegalName] [varchar](200) NULL,
	[ABN] [varchar](11) NULL,
	[ACN] [varchar](9) NULL,
	[DateLastValidated] [datetime] NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ProviderOrganisationHpio] PRIMARY KEY CLUSTERED 
(
	[ProviderOrganisationId] ASC,
	[AccessingOrganisationNetworkId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_ProviderOrganisationHpio_AccessingOrganisationNetwork]') AND parent_object_id = OBJECT_ID(N'[p2p].[ProviderOrganisationHpio]'))
ALTER TABLE [p2p].[ProviderOrganisationHpio]  WITH CHECK ADD  CONSTRAINT [FK_ProviderOrganisationHpio_AccessingOrganisationNetwork] FOREIGN KEY([AccessingOrganisationNetworkId])
REFERENCES [p2p].[AccessingOrganisationNetwork] ([AccessingOrganisationNetworkId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_ProviderOrganisationHpio_AccessingOrganisationNetwork]') AND parent_object_id = OBJECT_ID(N'[p2p].[ProviderOrganisationHpio]'))
ALTER TABLE [p2p].[ProviderOrganisationHpio] CHECK CONSTRAINT [FK_ProviderOrganisationHpio_AccessingOrganisationNetwork]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_ProviderOrganisationHpio_ProviderIdentifierStatus]') AND parent_object_id = OBJECT_ID(N'[p2p].[ProviderOrganisationHpio]'))
ALTER TABLE [p2p].[ProviderOrganisationHpio]  WITH CHECK ADD  CONSTRAINT [FK_ProviderOrganisationHpio_ProviderIdentifierStatus] FOREIGN KEY([ProviderIdentifierStatusId])
REFERENCES [nhsd].[ProviderIdentifierStatus] ([ProviderIdentifierStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_ProviderOrganisationHpio_ProviderIdentifierStatus]') AND parent_object_id = OBJECT_ID(N'[p2p].[ProviderOrganisationHpio]'))
ALTER TABLE [p2p].[ProviderOrganisationHpio] CHECK CONSTRAINT [FK_ProviderOrganisationHpio_ProviderIdentifierStatus]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_ProviderOrganisationHpio_ProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[p2p].[ProviderOrganisationHpio]'))
ALTER TABLE [p2p].[ProviderOrganisationHpio]  WITH CHECK ADD  CONSTRAINT [FK_ProviderOrganisationHpio_ProviderOrganisation] FOREIGN KEY([ProviderOrganisationId])
REFERENCES [nhsd].[ProviderOrganisation] ([ProviderOrganisationId])
ON DELETE CASCADE
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[p2p].[FK_ProviderOrganisationHpio_ProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[p2p].[ProviderOrganisationHpio]'))
ALTER TABLE [p2p].[ProviderOrganisationHpio] CHECK CONSTRAINT [FK_ProviderOrganisationHpio_ProviderOrganisation]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[p2p].[ResourceAudit]') AND type in (N'U'))
BEGIN
CREATE TABLE [p2p].[ResourceAudit](
	[ResourceAuditId] [int] IDENTITY(1,1) NOT NULL,
	[LocalTableName] [varchar](256) NOT NULL,
	[LocalPrimaryKey] [int] NOT NULL,
	[NationalHealthcareIdentifier] [varchar](16) NULL,
	[Request] [xml] NULL,
	[RequestAction] [varchar](256) NULL,
	[RequestMessageId] [varchar](256) NULL,
	[Response] [xml] NULL,
	[ResponseAction] [varchar](256) NULL,
	[ResponseMessageId] [varchar](256) NULL,
	[IsResponseFault] [bit] NOT NULL,
	[AccessingHpio] [varchar](16) NOT NULL,
	[UserName] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ResourceAudit] PRIMARY KEY CLUSTERED 
(
	[ResourceAuditId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[p2p].[Setting]') AND type in (N'U'))
BEGIN
CREATE TABLE [p2p].[Setting](
	[SettingId] [int] NOT NULL,
	[Description] [varchar](200) NOT NULL,
	[Value] [varchar](1000) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Setting] PRIMARY KEY CLUSTERED 
(
	[SettingId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'p2p', N'TABLE',N'Setting', N'COLUMN',N'SettingId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PK. Uniquely identifies the setting record.' , @level0type=N'SCHEMA',@level0name=N'p2p', @level1type=N'TABLE',@level1name=N'Setting', @level2type=N'COLUMN',@level2name=N'SettingId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'p2p', N'TABLE',N'Setting', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description of the setting.' , @level0type=N'SCHEMA',@level0name=N'p2p', @level1type=N'TABLE',@level1name=N'Setting', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'p2p', N'TABLE',N'Setting', N'COLUMN',N'Value'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Value for the setting.' , @level0type=N'SCHEMA',@level0name=N'p2p', @level1type=N'TABLE',@level1name=N'Setting', @level2type=N'COLUMN',@level2name=N'Value'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'p2p', N'TABLE',N'Setting', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date/time the record was created.' , @level0type=N'SCHEMA',@level0name=N'p2p', @level1type=N'TABLE',@level1name=N'Setting', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'p2p', N'TABLE',N'Setting', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifier of the user who created the record.' , @level0type=N'SCHEMA',@level0name=N'p2p', @level1type=N'TABLE',@level1name=N'Setting', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'p2p', N'TABLE',N'Setting', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date/time the record was last modified.' , @level0type=N'SCHEMA',@level0name=N'p2p', @level1type=N'TABLE',@level1name=N'Setting', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'p2p', N'TABLE',N'Setting', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifier of the user who last modified the record.' , @level0type=N'SCHEMA',@level0name=N'p2p', @level1type=N'TABLE',@level1name=N'Setting', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'p2p', N'TABLE',N'Setting', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Captures general configuration settings for P2P.' , @level0type=N'SCHEMA',@level0name=N'p2p', @level1type=N'TABLE',@level1name=N'Setting'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[smd].[MessageDirection]') AND type in (N'U'))
BEGIN
CREATE TABLE [smd].[MessageDirection](
	[MessageDirectionId] [int] NOT NULL,
	[Description] [varchar](128) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_MessageDirection] PRIMARY KEY CLUSTERED 
(
	[MessageDirectionId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[smd].[MessagePayload]') AND type in (N'U'))
BEGIN
CREATE TABLE [smd].[MessagePayload](
	[MessagePayloadId] [int] IDENTITY(1,1) NOT NULL,
	[PayloadSchemeId] [int] NOT NULL,
	[SenderOrganisationId] [int] NULL,
	[ReceiverOrganisationId] [int] NULL,
	[SenderIndividualId] [int] NULL,
	[ReceiverIndividualId] [int] NULL,
	[SexId] [int] NULL,
	[SenderOrganisation] [varchar](1024) NULL,
	[ReceiverOrganisation] [varchar](1024) NULL,
	[SenderIndividual] [varchar](1024) NULL,
	[ReceiverIndividual] [varchar](1024) NULL,
	[Contents] [varbinary](max) NULL,
	[Ihi] [varchar](16) NULL,
	[FamilyName] [varchar](80) NULL,
	[GivenNames] [varchar](80) NULL,
	[DateOfBirth] [datetime] NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_MessagePayload] PRIMARY KEY CLUSTERED 
(
	[MessagePayloadId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_MessagePayload_PayloadScheme]') AND parent_object_id = OBJECT_ID(N'[smd].[MessagePayload]'))
ALTER TABLE [smd].[MessagePayload]  WITH CHECK ADD  CONSTRAINT [FK_MessagePayload_PayloadScheme] FOREIGN KEY([PayloadSchemeId])
REFERENCES [els].[PayloadScheme] ([PayloadSchemeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_MessagePayload_PayloadScheme]') AND parent_object_id = OBJECT_ID(N'[smd].[MessagePayload]'))
ALTER TABLE [smd].[MessagePayload] CHECK CONSTRAINT [FK_MessagePayload_PayloadScheme]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_MessagePayload_ReceiverIndividual]') AND parent_object_id = OBJECT_ID(N'[smd].[MessagePayload]'))
ALTER TABLE [smd].[MessagePayload]  WITH CHECK ADD  CONSTRAINT [FK_MessagePayload_ReceiverIndividual] FOREIGN KEY([ReceiverIndividualId])
REFERENCES [nhsd].[ProviderIndividual] ([ProviderIndividualId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_MessagePayload_ReceiverIndividual]') AND parent_object_id = OBJECT_ID(N'[smd].[MessagePayload]'))
ALTER TABLE [smd].[MessagePayload] CHECK CONSTRAINT [FK_MessagePayload_ReceiverIndividual]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_MessagePayload_ReceiverOrganisation]') AND parent_object_id = OBJECT_ID(N'[smd].[MessagePayload]'))
ALTER TABLE [smd].[MessagePayload]  WITH CHECK ADD  CONSTRAINT [FK_MessagePayload_ReceiverOrganisation] FOREIGN KEY([ReceiverOrganisationId])
REFERENCES [nhsd].[ProviderOrganisation] ([ProviderOrganisationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_MessagePayload_ReceiverOrganisation]') AND parent_object_id = OBJECT_ID(N'[smd].[MessagePayload]'))
ALTER TABLE [smd].[MessagePayload] CHECK CONSTRAINT [FK_MessagePayload_ReceiverOrganisation]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_MessagePayload_SenderIndividual]') AND parent_object_id = OBJECT_ID(N'[smd].[MessagePayload]'))
ALTER TABLE [smd].[MessagePayload]  WITH CHECK ADD  CONSTRAINT [FK_MessagePayload_SenderIndividual] FOREIGN KEY([SenderIndividualId])
REFERENCES [nhsd].[ProviderIndividual] ([ProviderIndividualId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_MessagePayload_SenderIndividual]') AND parent_object_id = OBJECT_ID(N'[smd].[MessagePayload]'))
ALTER TABLE [smd].[MessagePayload] CHECK CONSTRAINT [FK_MessagePayload_SenderIndividual]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_MessagePayload_SenderOrganisation]') AND parent_object_id = OBJECT_ID(N'[smd].[MessagePayload]'))
ALTER TABLE [smd].[MessagePayload]  WITH CHECK ADD  CONSTRAINT [FK_MessagePayload_SenderOrganisation] FOREIGN KEY([SenderOrganisationId])
REFERENCES [nhsd].[ProviderOrganisation] ([ProviderOrganisationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_MessagePayload_SenderOrganisation]') AND parent_object_id = OBJECT_ID(N'[smd].[MessagePayload]'))
ALTER TABLE [smd].[MessagePayload] CHECK CONSTRAINT [FK_MessagePayload_SenderOrganisation]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_MessagePayload_Sex]') AND parent_object_id = OBJECT_ID(N'[smd].[MessagePayload]'))
ALTER TABLE [smd].[MessagePayload]  WITH CHECK ADD  CONSTRAINT [FK_MessagePayload_Sex] FOREIGN KEY([SexId])
REFERENCES [smd].[Sex] ([SexId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_MessagePayload_Sex]') AND parent_object_id = OBJECT_ID(N'[smd].[MessagePayload]'))
ALTER TABLE [smd].[MessagePayload] CHECK CONSTRAINT [FK_MessagePayload_Sex]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[smd].[MessageStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [smd].[MessageStatus](
	[MessageStatusId] [int] NOT NULL,
	[Description] [varchar](128) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_MessageStatus] PRIMARY KEY CLUSTERED 
(
	[MessageStatusId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[smd].[SealedMessage]') AND type in (N'U'))
BEGIN
CREATE TABLE [smd].[SealedMessage](
	[SealedMessageId] [int] IDENTITY(1,1) NOT NULL,
	[MessageDirectionId] [int] NOT NULL,
	[MessageStatusId] [int] NOT NULL,
	[MessagePayloadId] [int] NOT NULL,
	[InteractionRecordId] [int] NULL,
	[RetryCount] [int] NOT NULL,
	[DigestValue] [varchar](64) NULL,
	[CreationTime] [datetime] NOT NULL,
	[ExpiryTime] [datetime] NULL,
	[InvocationIdentifier] [varchar](1024) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_SealedMessage] PRIMARY KEY CLUSTERED 
(
	[SealedMessageId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_SealedMessage_InteractionRecord]') AND parent_object_id = OBJECT_ID(N'[smd].[SealedMessage]'))
ALTER TABLE [smd].[SealedMessage]  WITH CHECK ADD  CONSTRAINT [FK_SealedMessage_InteractionRecord] FOREIGN KEY([InteractionRecordId])
REFERENCES [els].[InteractionRecord] ([InteractionRecordId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_SealedMessage_InteractionRecord]') AND parent_object_id = OBJECT_ID(N'[smd].[SealedMessage]'))
ALTER TABLE [smd].[SealedMessage] CHECK CONSTRAINT [FK_SealedMessage_InteractionRecord]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_SealedMessage_MessageDirection]') AND parent_object_id = OBJECT_ID(N'[smd].[SealedMessage]'))
ALTER TABLE [smd].[SealedMessage]  WITH CHECK ADD  CONSTRAINT [FK_SealedMessage_MessageDirection] FOREIGN KEY([MessageDirectionId])
REFERENCES [smd].[MessageDirection] ([MessageDirectionId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_SealedMessage_MessageDirection]') AND parent_object_id = OBJECT_ID(N'[smd].[SealedMessage]'))
ALTER TABLE [smd].[SealedMessage] CHECK CONSTRAINT [FK_SealedMessage_MessageDirection]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_SealedMessage_MessagePayload]') AND parent_object_id = OBJECT_ID(N'[smd].[SealedMessage]'))
ALTER TABLE [smd].[SealedMessage]  WITH CHECK ADD  CONSTRAINT [FK_SealedMessage_MessagePayload] FOREIGN KEY([MessagePayloadId])
REFERENCES [smd].[MessagePayload] ([MessagePayloadId])
ON DELETE CASCADE
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_SealedMessage_MessagePayload]') AND parent_object_id = OBJECT_ID(N'[smd].[SealedMessage]'))
ALTER TABLE [smd].[SealedMessage] CHECK CONSTRAINT [FK_SealedMessage_MessagePayload]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_SealedMessage_MessageStatus]') AND parent_object_id = OBJECT_ID(N'[smd].[SealedMessage]'))
ALTER TABLE [smd].[SealedMessage]  WITH CHECK ADD  CONSTRAINT [FK_SealedMessage_MessageStatus] FOREIGN KEY([MessageStatusId])
REFERENCES [smd].[MessageStatus] ([MessageStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_SealedMessage_MessageStatus]') AND parent_object_id = OBJECT_ID(N'[smd].[SealedMessage]'))
ALTER TABLE [smd].[SealedMessage] CHECK CONSTRAINT [FK_SealedMessage_MessageStatus]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[smd].[SealedMessageMetadata]') AND type in (N'U'))
BEGIN
CREATE TABLE [smd].[SealedMessageMetadata](
	[SealedMessageMetadataId] [int] IDENTITY(1,1) NOT NULL,
	[SealedMessageId] [int] NOT NULL,
	[MetadataType] [varchar](1024) NOT NULL,
	[MetadataValue] [varbinary](max) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_SealedMessageMetadata] PRIMARY KEY CLUSTERED 
(
	[SealedMessageMetadataId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_SealedMessageMetadata_SealedMessage]') AND parent_object_id = OBJECT_ID(N'[smd].[SealedMessageMetadata]'))
ALTER TABLE [smd].[SealedMessageMetadata]  WITH CHECK ADD  CONSTRAINT [FK_SealedMessageMetadata_SealedMessage] FOREIGN KEY([SealedMessageId])
REFERENCES [smd].[SealedMessage] ([SealedMessageId])
ON DELETE CASCADE
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_SealedMessageMetadata_SealedMessage]') AND parent_object_id = OBJECT_ID(N'[smd].[SealedMessageMetadata]'))
ALTER TABLE [smd].[SealedMessageMetadata] CHECK CONSTRAINT [FK_SealedMessageMetadata_SealedMessage]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[smd].[Sex]') AND type in (N'U'))
BEGIN
CREATE TABLE [smd].[Sex](
	[SexId] [int] NOT NULL,
	[Code] [varchar](10) NOT NULL,
	[Description] [varchar](100) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Sex] PRIMARY KEY CLUSTERED 
(
	[SexId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[smd].[TransportResponse]') AND type in (N'U'))
BEGIN
CREATE TABLE [smd].[TransportResponse](
	[TransportResponseId] [int] IDENTITY(1,1) NOT NULL,
	[TransportResponseClassId] [int] NOT NULL,
	[TransportResponseStatusId] [int] NOT NULL,
	[ReceiverOrganisationId] [int] NULL,
	[SenderOrganisationId] [int] NULL,
	[ReceiverOrganisation] [varchar](1024) NOT NULL,
	[SenderOrganisation] [varchar](1024) NOT NULL,
	[SourceOrganisation] [varchar](1024) NOT NULL,
	[InvocationIdentifier] [varchar](1024) NOT NULL,
	[SealedMessageId] [int] NULL,
	[ResponseTime] [datetime] NOT NULL,
	[ResponseIdentifier] [varchar](1024) NOT NULL,
	[Final] [bit] NOT NULL,
	[ResponseCode] [varchar](1024) NOT NULL,
	[Message] [varchar](max) NOT NULL,
	[DigestValue] [varchar](64) NULL,
	[DeliveryEndpoint] [varchar](1024) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_TransportResponse] PRIMARY KEY CLUSTERED 
(
	[TransportResponseId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_TransportResponse_ReceiverOrganisation]') AND parent_object_id = OBJECT_ID(N'[smd].[TransportResponse]'))
ALTER TABLE [smd].[TransportResponse]  WITH CHECK ADD  CONSTRAINT [FK_TransportResponse_ReceiverOrganisation] FOREIGN KEY([ReceiverOrganisationId])
REFERENCES [nhsd].[ProviderOrganisation] ([ProviderOrganisationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_TransportResponse_ReceiverOrganisation]') AND parent_object_id = OBJECT_ID(N'[smd].[TransportResponse]'))
ALTER TABLE [smd].[TransportResponse] CHECK CONSTRAINT [FK_TransportResponse_ReceiverOrganisation]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_TransportResponse_SealedMessage]') AND parent_object_id = OBJECT_ID(N'[smd].[TransportResponse]'))
ALTER TABLE [smd].[TransportResponse]  WITH CHECK ADD  CONSTRAINT [FK_TransportResponse_SealedMessage] FOREIGN KEY([SealedMessageId])
REFERENCES [smd].[SealedMessage] ([SealedMessageId])
ON DELETE CASCADE
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_TransportResponse_SealedMessage]') AND parent_object_id = OBJECT_ID(N'[smd].[TransportResponse]'))
ALTER TABLE [smd].[TransportResponse] CHECK CONSTRAINT [FK_TransportResponse_SealedMessage]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_TransportResponse_SenderOrganisation]') AND parent_object_id = OBJECT_ID(N'[smd].[TransportResponse]'))
ALTER TABLE [smd].[TransportResponse]  WITH CHECK ADD  CONSTRAINT [FK_TransportResponse_SenderOrganisation] FOREIGN KEY([SenderOrganisationId])
REFERENCES [nhsd].[ProviderOrganisation] ([ProviderOrganisationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_TransportResponse_SenderOrganisation]') AND parent_object_id = OBJECT_ID(N'[smd].[TransportResponse]'))
ALTER TABLE [smd].[TransportResponse] CHECK CONSTRAINT [FK_TransportResponse_SenderOrganisation]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_TransportResponse_TransportResponseClass]') AND parent_object_id = OBJECT_ID(N'[smd].[TransportResponse]'))
ALTER TABLE [smd].[TransportResponse]  WITH CHECK ADD  CONSTRAINT [FK_TransportResponse_TransportResponseClass] FOREIGN KEY([TransportResponseClassId])
REFERENCES [smd].[TransportResponseClass] ([TransportResponseClassId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_TransportResponse_TransportResponseClass]') AND parent_object_id = OBJECT_ID(N'[smd].[TransportResponse]'))
ALTER TABLE [smd].[TransportResponse] CHECK CONSTRAINT [FK_TransportResponse_TransportResponseClass]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_TransportResponse_TransportResponseStatus]') AND parent_object_id = OBJECT_ID(N'[smd].[TransportResponse]'))
ALTER TABLE [smd].[TransportResponse]  WITH CHECK ADD  CONSTRAINT [FK_TransportResponse_TransportResponseStatus] FOREIGN KEY([TransportResponseStatusId])
REFERENCES [smd].[TransportResponseStatus] ([TransportResponseStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_TransportResponse_TransportResponseStatus]') AND parent_object_id = OBJECT_ID(N'[smd].[TransportResponse]'))
ALTER TABLE [smd].[TransportResponse] CHECK CONSTRAINT [FK_TransportResponse_TransportResponseStatus]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[smd].[TransportResponseClass]') AND type in (N'U'))
BEGIN
CREATE TABLE [smd].[TransportResponseClass](
	[TransportResponseClassId] [int] NOT NULL,
	[Description] [varchar](64) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_TransportResponseClass] PRIMARY KEY CLUSTERED 
(
	[TransportResponseClassId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[smd].[TransportResponseMetadata]') AND type in (N'U'))
BEGIN
CREATE TABLE [smd].[TransportResponseMetadata](
	[TransportResponseMetadataId] [int] IDENTITY(1,1) NOT NULL,
	[TransportResponseId] [int] NOT NULL,
	[MetadataType] [varchar](1024) NOT NULL,
	[MetadataValue] [varbinary](max) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_TransportResponseMetadata] PRIMARY KEY CLUSTERED 
(
	[TransportResponseMetadataId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_TransportResponseMetadata_TransportResponse]') AND parent_object_id = OBJECT_ID(N'[smd].[TransportResponseMetadata]'))
ALTER TABLE [smd].[TransportResponseMetadata]  WITH CHECK ADD  CONSTRAINT [FK_TransportResponseMetadata_TransportResponse] FOREIGN KEY([TransportResponseId])
REFERENCES [smd].[TransportResponse] ([TransportResponseId])
ON DELETE CASCADE
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[smd].[FK_TransportResponseMetadata_TransportResponse]') AND parent_object_id = OBJECT_ID(N'[smd].[TransportResponseMetadata]'))
ALTER TABLE [smd].[TransportResponseMetadata] CHECK CONSTRAINT [FK_TransportResponseMetadata_TransportResponse]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[smd].[TransportResponseStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [smd].[TransportResponseStatus](
	[TransportResponseStatusId] [int] NOT NULL,
	[Description] [varchar](64) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_TransportResponseStatus] PRIMARY KEY CLUSTERED 
(
	[TransportResponseStatusId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

