
PRINT 'Creating unique index on Delegate.QualifiedIdentifier'
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_Delegate_QualifiedIdentifier] ON [els].[Delegate] ([QualifiedIdentifier])
GO

PRINT 'Creating unique index on Intermediary ServiceEndpointUri'
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_Intermediary_ServiceEndpointUri] ON [els].[Intermediary] ([ServiceEndpointUri])
GO

PRINT 'Creating unique index on PayloadScheme QualifiedIdentifier'
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_PayloadScheme_QualifiedIdentifier] ON [els].[PayloadScheme] ([QualifiedIdentifier])
GO

PRINT 'Creating unique index on ServiceInterface QualifiedIdentifier'
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_ServiceInterface_QualifiedIdentifier] ON [els].[ServiceInterface] ([QualifiedIdentifier])
GO

PRINT 'Creating unique index on DocumentType Code'
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_DocumentType_Code] ON [els].[DocumentType] ([Code])
GO

PRINT 'Creating unique index on ProviderIdentifierStatus Code'
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_ProviderIdentifierStatus_Code] ON [nhsd].[ProviderIdentifierStatus] ([Code])
GO

PRINT 'Creating non-unique index on ProviderIndividualIdentifier ProviderIdentifierTypeId, Value'
GO
CREATE NONCLUSTERED INDEX [UQ_ProviderIndividualIdentifier] ON [nhsd].[ProviderIndividualIdentifier] ([ProviderIdentifierTypeId], [Value])
GO

PRINT 'Creating non-unique index on ProviderOrganisationIdentifier ProviderIdentifierTypeId, Value'
GO
CREATE NONCLUSTERED INDEX [UQ_ProviderOrganisationIdentifier] ON [nhsd].[ProviderOrganisationIdentifier] ([ProviderIdentifierTypeId], [Value])
GO

PRINT 'Creating non-unique index on ProviderLocationIdentifier ProviderIdentifierTypeId, Value'
GO
CREATE NONCLUSTERED INDEX [UQ_ProviderLocationIdentifier] ON [nhsd].[ProviderLocationIdentifier] ([ProviderIdentifierTypeId], [Value])
GO

PRINT 'Creating non-unique index on ProviderLinkIdentifier ProviderIdentifierTypeId, Value'
GO
CREATE NONCLUSTERED INDEX [UQ_ProviderLinkIdentifier] ON [nhsd].[ProviderLinkIdentifier] ([ProviderIdentifierTypeId], [Value])
GO

