IF EXISTS (SELECT * FROM sys.check_constraints WHERE object_id = OBJECT_ID(N'[nhsd].[CHK_ProviderIndividualIdentifier_EntityType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderIndividualIdentifier]'))
ALTER TABLE [nhsd].[ProviderIndividualIdentifier] DROP CONSTRAINT [CHK_ProviderIndividualIdentifier_EntityType]

IF EXISTS (SELECT * FROM sys.check_constraints WHERE object_id = OBJECT_ID(N'[nhsd].[CHK_ProviderOrganisationIdentifier_EntityType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderOrganisationIdentifier]'))
ALTER TABLE [nhsd].[ProviderOrganisationIdentifier] DROP CONSTRAINT [CHK_ProviderOrganisationIdentifier_EntityType]

IF EXISTS (SELECT * FROM sys.check_constraints WHERE object_id = OBJECT_ID(N'[nhsd].[CHK_ProviderLinkIdentifier_EntityType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLinkIdentifier]'))
ALTER TABLE [nhsd].[ProviderLinkIdentifier] DROP CONSTRAINT [CHK_ProviderLinkIdentifier_EntityType]

IF EXISTS (SELECT * FROM sys.check_constraints WHERE object_id = OBJECT_ID(N'[nhsd].[CHK_ProviderLocationIdentifier_EntityType]') AND parent_object_id = OBJECT_ID(N'[nhsd].[ProviderLocationIdentifier]'))
ALTER TABLE [nhsd].[ProviderLocationIdentifier] DROP CONSTRAINT [CHK_ProviderLocationIdentifier_EntityType]

IF EXISTS (SELECT * FROM sys.check_constraints WHERE object_id = OBJECT_ID(N'[neps].[CHK_AreaOfInterestProviderIdentifier_EntityType]') AND parent_object_id = OBJECT_ID(N'[neps].[AreaOfInterestProviderIdentifier]'))
ALTER TABLE [neps].[AreaOfInterestProviderIdentifier] DROP CONSTRAINT [CHK_AreaOfInterestProviderIdentifier_EntityType]
GO
DROP FUNCTION [nhsd].[GetProviderEntityTypeId]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [nhsd].[GetProviderEntityTypeId]
(
	@ProviderIdentifierTypeId INT
) RETURNS INT AS 
BEGIN
	RETURN 
	(
		SELECT ProviderEntityTypeId 
		FROM nhsd.ProviderIdentifierType 
		WHERE ProviderIdentifierTypeId=@ProviderIdentifierTypeId
	)
END
GO
ALTER TABLE nhsd.ProviderIndividualIdentifier 
ADD CONSTRAINT CHK_ProviderIndividualIdentifier_EntityType 
CHECK (nhsd.GetProviderEntityTypeId(ProviderIdentifierTypeId)=1)

ALTER TABLE nhsd.ProviderOrganisationIdentifier 
ADD CONSTRAINT CHK_ProviderOrganisationIdentifier_EntityType 
CHECK (nhsd.GetProviderEntityTypeId(ProviderIdentifierTypeId)=2)

ALTER TABLE nhsd.ProviderLinkIdentifier 
ADD CONSTRAINT CHK_ProviderLinkIdentifier_EntityType 
CHECK (nhsd.GetProviderEntityTypeId(ProviderIdentifierTypeId)=3)

ALTER TABLE nhsd.ProviderLocationIdentifier 
ADD CONSTRAINT CHK_ProviderLocationIdentifier_EntityType 
CHECK (nhsd.GetProviderEntityTypeId(ProviderIdentifierTypeId)=4)

ALTER TABLE neps.AreaOfInterestProviderIdentifier 
ADD CONSTRAINT CHK_AreaOfInterestProviderIdentifier_EntityType 
CHECK (nhsd.GetProviderEntityTypeId(ProviderIdentifierTypeId) IN (1, 2))
GO

DROP FUNCTION [nhsd].[Split]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [nhsd].[Split]
(
	@ItemList NVARCHAR(MAX), 
	@delimiter CHAR(1)
)
RETURNS @ItemTable TABLE (Item VARCHAR(250))  
AS      

BEGIN    
	DECLARE @tempItemList NVARCHAR(MAX)
	SET @tempItemList = @ItemList

	DECLARE @i INT    
	DECLARE @Item NVARCHAR(4000)

	SET @i = CHARINDEX(@delimiter, @tempItemList)

	WHILE (LEN(@tempItemList) > 0)
	BEGIN
		IF @i = 0
			SET @Item = @tempItemList
		ELSE
			SET @Item = LEFT(@tempItemList, @i - 1)
		INSERT INTO @ItemTable(Item) VALUES(@Item)
		IF @i = 0
			SET @tempItemList = ''
		ELSE
			SET @tempItemList = RIGHT(@tempItemList, LEN(@tempItemList) - @i)
		SET @i = CHARINDEX(@delimiter, @tempItemList)
	END 
	RETURN
END
GO

DROP PROCEDURE [nhsd].[ProviderIndividual_Delete]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Create date:   4 Nov 2015
-- Description:   Deletes from the ProviderIndividual table
-- =============================================
CREATE PROCEDURE [nhsd].[ProviderIndividual_Delete]
	@ProviderIndividualId [int]
AS
BEGIN

DELETE FROM [nhsd].[ProviderIndividual]
WHERE @ProviderIndividualId = ProviderIndividualId

RETURN 0
END
GO

DROP PROCEDURE [nhsd].[ProviderIndividual_Insert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Create date:   4 Nov 2015
-- Description:   Inserts into the ProviderIndividual table
-- =============================================
CREATE PROCEDURE [nhsd].[ProviderIndividual_Insert]
	@ProviderStatusId [int],
	@SexReferenceItemId [int],
	@DateOfBirth [datetime],
	@IsInSubscription [bit],
	@FamilyName [varchar](80),
	@FullName [varchar](512),
	@GivenName [varchar](80),
	@MiddleName [varchar](80),
	@Title [varchar](80),
	@DateCreated [datetime],
	@UserCreated [varchar](256),
	@DateModified [datetime],
	@UserModified [varchar](256)
AS
BEGIN
DECLARE @intErrorCode INT, @ProviderIndividualId INT

INSERT INTO [nhsd].[ProviderIndividual]
           ([ProviderStatusId]
           ,[SexReferenceItemId]
           ,[DateOfBirth]
           ,[IsInSubscription]
           ,[FamilyName]
           ,[GivenName]
           ,[MiddleName]
           ,[Title]
           ,[DateCreated]
           ,[UserCreated]
           ,[DateModified]
           ,[UserModified])
     VALUES
           (@ProviderStatusId
           ,@SexReferenceItemId
           ,@DateOfBirth
           ,@IsInSubscription
           ,@FamilyName
           ,@GivenName
           ,@MiddleName
           ,@Title
           ,@DateCreated
           ,@UserCreated
           ,@DateModified
           ,@UserModified)

SELECT @intErrorCode = @@ERROR , @ProviderIndividualId = SCOPE_IDENTITY()
IF @intErrorCode = 0
BEGIN
SELECT [ProviderIndividualId]
      ,[ProviderStatusId]
      ,[SexReferenceItemId]
      ,[DateOfBirth]
      ,[IsInSubscription]
	  ,Title + ' ' + GivenName + ' ' + MiddleName + ' ' + FamilyName AS [FullName]
      ,[FamilyName]
      ,[GivenName]
      ,[MiddleName]
      ,[Title]
      ,[DateCreated]
      ,[UserCreated]
      ,[DateModified]
      ,[UserModified]
  FROM [nhsd].[ProviderIndividual]
  WHERE @ProviderIndividualId = ProviderIndividualId
END

RETURN @intErrorCode
END
GO

DROP PROCEDURE [nhsd].[ProviderIndividual_Update]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Create date:   4 Nov 2015
-- Description:   Updates the ProviderIndividual table
-- =============================================
CREATE PROCEDURE [nhsd].[ProviderIndividual_Update]
	@ProviderIndividualId [int],
	@ProviderStatusId [int],
	@SexReferenceItemId [int],
	@DateOfBirth [datetime],
	@IsInSubscription [bit],
	@FamilyName [varchar](80),
	@FullName [varchar](512),
	@GivenName [varchar](80),
	@MiddleName [varchar](80),
	@Title [varchar](80),
	@DateCreated [datetime],
	@UserCreated [varchar](256),
	@DateModified [datetime],
	@UserModified [varchar](256)
AS
BEGIN
DECLARE @intErrorCode INT

UPDATE [nhsd].[ProviderIndividual]
   SET [ProviderStatusId] = @ProviderStatusId
      ,[SexReferenceItemId] = @SexReferenceItemId
      ,[DateOfBirth] = @DateOfBirth
      ,[IsInSubscription] = @IsInSubscription
      ,[FamilyName] = @FamilyName
      ,[GivenName] = @GivenName
      ,[MiddleName] = @MiddleName
      ,[Title] = @Title
      ,[DateCreated] = @DateCreated
      ,[UserCreated] = @UserCreated
      ,[DateModified] = @DateModified
      ,[UserModified] = @UserModified
WHERE @ProviderIndividualId = ProviderIndividualId

SELECT @intErrorCode = @@ERROR

IF @intErrorCode = 0
BEGIN
	SELECT [ProviderIndividualId]
		  ,[ProviderStatusId]
		  ,[SexReferenceItemId]
		  ,[DateOfBirth]
		  ,[IsInSubscription]
		  ,Title + ' ' + GivenName + ' ' + MiddleName + ' ' + FamilyName AS [FullName]
		  ,[FamilyName]
		  ,[GivenName]
		  ,[MiddleName]
		  ,[Title]
		  ,[DateCreated]
		  ,[UserCreated]
		  ,[DateModified]
		  ,[UserModified]
	  FROM [nhsd].[ProviderIndividual]
	  WHERE @ProviderIndividualId = ProviderIndividualId
END

RETURN @intErrorCode
END
GO

IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[nhsd].[ProviderIndividualWithFullName]'))
DROP VIEW [nhsd].[ProviderIndividualWithFullName]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [nhsd].[ProviderIndividualWithFullName]
AS

	-- For Title, GivenName, MiddleName, FamilyName
	SELECT 
		 [FullName] = Split.Item + ' ' + ISNULL([GivenName] + ' ', '') + ISNULL(RTRIM([MiddleName]) + ' ', '') + ISNULL([FamilyName], '')
		 , a.*
	FROM (
		SELECT 
			[ProviderIndividualId]
		  ,[ProviderStatusId]
		  ,[SexReferenceItemId]
		  ,[DateOfBirth]
		  ,[IsInSubscription]
		  ,[FamilyName]
		  ,[GivenName]
		  ,[MiddleName]
		  ,[Title]
		  ,[DateCreated]
		  ,[UserCreated]
		  ,[DateModified]
		  ,[UserModified]
		FROM [nhsd].[ProviderIndividual]
		WHERE (Title IS NOT NULL) AND (MiddleName IS NOT NULL OR LTRIM(RTRIM(MiddleName)) != '')
	) a
	CROSS APPLY nhsd.Split(RTRIM(a.[Title]), ' ')as Split
	UNION ALL -- For Title, GivenName, FamilyName
		SELECT 
		 [FullName] = Split.Item + ' ' + ISNULL([GivenName] + ' ', '') + ISNULL([FamilyName], '')
		 , a.*
	FROM (
		SELECT 
			[ProviderIndividualId]
		  ,[ProviderStatusId]
		  ,[SexReferenceItemId]
		  ,[DateOfBirth]
		  ,[IsInSubscription]
		  ,[FamilyName]
		  ,[GivenName]
		  ,[MiddleName]
		  ,[Title]
		  ,[DateCreated]
		  ,[UserCreated]
		  ,[DateModified]
		  ,[UserModified]
		FROM [nhsd].[ProviderIndividual]
		WHERE Title IS NOT NULL
	) a
	CROSS APPLY nhsd.Split(RTRIM(a.[Title]), ' ')as Split
	UNION ALL -- For Title, FamilyName
		SELECT 
		 [FullName] = Split.Item + ' ' + ISNULL([FamilyName], '')
		 , a.*
	FROM (
		SELECT 
			[ProviderIndividualId]
		  ,[ProviderStatusId]
		  ,[SexReferenceItemId]
		  ,[DateOfBirth]
		  ,[IsInSubscription]
		  ,[FamilyName]
		  ,[GivenName]
		  ,[MiddleName]
		  ,[Title]
		  ,[DateCreated]
		  ,[UserCreated]
		  ,[DateModified]
		  ,[UserModified]
		FROM [nhsd].[ProviderIndividual]
		WHERE Title IS NOT NULL
	) a	
	CROSS APPLY nhsd.Split(RTRIM(a.[Title]), ' ')as Split
	UNION ALL
		SELECT 
			[FullName] = ISNULL([GivenName] + ' ', '') + ISNULL([MiddleName] + ' ', '') + ISNULL([FamilyName], '')
		  ,[ProviderIndividualId]
		  ,[ProviderStatusId]
		  ,[SexReferenceItemId]
		  ,[DateOfBirth]
		  ,[IsInSubscription]
		  ,[FamilyName]
		  ,[GivenName]
		  ,[MiddleName]
		  ,[Title]
		  ,[DateCreated]
		  ,[UserCreated]
		  ,[DateModified]
		  ,[UserModified]
		FROM [nhsd].[ProviderIndividual]
		WHERE Title IS NULL OR LTRIM(RTRIM(Title)) = ''
	
GO

