/*
Script to create default reference data used by the P2P App Server

You are recommended to back up your database before running this script

Script created by SQL Data Compare version 10.4.8 from Red Gate Software Ltd at 16/07/2014 3:14:30 PM

*/
		
GO
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS, NOCOUNT ON
GO
SET DATEFORMAT YMD
GO
SET XACT_ABORT ON
GO
SET TRANSACTION ISOLATION LEVEL SERIALIZABLE
GO
BEGIN TRANSACTION
-- Pointer used for text / image updates. This might not be needed, but is declared here just in case
DECLARE @pv binary(16)

DELETE FROM [p2p].[ChangeType]
DELETE FROM [smd].[MessageDirection]
DELETE FROM [smd].[MessageStatus]
DELETE FROM [nhsd].[ProviderIdentifierStatus]
DELETE FROM [els].[ServiceInterface]
DELETE FROM [smd].[Sex]
DELETE FROM [smd].[TransportResponseClass]
DELETE FROM [smd].[TransportResponseStatus]
DELETE FROM [els].[PayloadScheme]
DELETE FROM [nhsd].[ProviderIdentifierType]
DELETE FROM [els].[DocumentType]
DELETE FROM [els].[PayloadPackaging]
DELETE FROM [nhsd].[ProviderEntityType]
DELETE FROM [nhsd].[ReferenceItem]
DELETE FROM [nhsd].[ReferenceSet]
DELETE FROM [nhsd].[ReferenceProfile]
DELETE FROM [nhsd].[ProviderStatus]
GO
-- ChangeType sourced from HIPS P2P Directory Maintenance Technical Design
PRINT(N'Add 3 rows to [p2p].[ChangeType]')
GO
INSERT INTO [p2p].[ChangeType] ([ChangeTypeId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 'Add', '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [p2p].[ChangeType] ([ChangeTypeId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 'Modify', '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [p2p].[ChangeType] ([ChangeTypeId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 'Deactivate', '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')

-- DocumentType based on supported payload schemes
PRINT(N'Add 5 rows to [els].[DocumentType]')
GO
SET IDENTITY_INSERT [els].[DocumentType] ON
INSERT INTO [els].[DocumentType] ([DocumentTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, '18842-5', 'Discharge Summary', '2012-12-11 00:00:00.000', 'HIPS', '2012-12-11 00:00:00.000', 'HIPS')
INSERT INTO [els].[DocumentType] ([DocumentTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, '34133-9', 'Event Summary', '2014-01-14 00:00:00.000', 'HIPS', '2014-01-14 00:00:00.000', 'HIPS')
INSERT INTO [els].[DocumentType] ([DocumentTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, '51852-2', 'Specialist Letter', '2014-01-14 00:00:00.000', 'HIPS', '2014-01-14 00:00:00.000', 'HIPS')
INSERT INTO [els].[DocumentType] ([DocumentTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, '57133-1', 'e-Referral', '2014-01-14 00:00:00.000', 'HIPS', '2014-01-14 00:00:00.000', 'HIPS')
INSERT INTO [els].[DocumentType] ([DocumentTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, 'ACK', 'Acknowledgement', '2014-07-16 03:01:29.000', 'HIPS', '2014-07-16 03:01:29.000', 'HIPS')
SET IDENTITY_INSERT [els].[DocumentType] OFF

PRINT(N'Add 2 rows to [smd].[MessageDirection]')
GO
INSERT INTO [smd].[MessageDirection] ([MessageDirectionId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 'Inbound', '2014-07-14 10:22:46.367', 'HIPS', '2014-07-14 10:22:46.367', 'HIPS')
INSERT INTO [smd].[MessageDirection] ([MessageDirectionId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 'Outbound', '2014-07-14 10:22:46.370', 'HIPS', '2014-07-14 10:22:46.370', 'HIPS')

PRINT(N'Add 16 rows to [smd].[MessageStatus]')
GO
INSERT INTO [smd].[MessageStatus] ([MessageStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 'Inbound Received', '2014-07-14 10:22:46.370', 'HIPS', '2014-07-14 10:22:46.370', 'HIPS')
INSERT INTO [smd].[MessageStatus] ([MessageStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 'Inbound Unacknowledged', '2014-07-14 10:22:46.370', 'HIPS', '2014-07-14 10:22:46.370', 'HIPS')
INSERT INTO [smd].[MessageStatus] ([MessageStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 'Inbound Unpublished', '2014-07-14 10:22:46.370', 'HIPS', '2014-07-14 10:22:46.370', 'HIPS')
INSERT INTO [smd].[MessageStatus] ([MessageStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 'Inbound Published', '2014-07-14 10:22:46.373', 'HIPS', '2014-07-14 10:22:46.373', 'HIPS')
INSERT INTO [smd].[MessageStatus] ([MessageStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, 'Inbound Retrieved', '2014-07-14 10:22:46.373', 'HIPS', '2014-07-14 10:22:46.373', 'HIPS')
INSERT INTO [smd].[MessageStatus] ([MessageStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (6, 'Inbound Failed', '2014-07-14 10:22:46.373', 'HIPS', '2014-07-14 10:22:46.373', 'HIPS')
INSERT INTO [smd].[MessageStatus] ([MessageStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (7, 'Inbound Expired', '2014-07-14 10:22:46.377', 'HIPS', '2014-07-14 10:22:46.377', 'HIPS')
INSERT INTO [smd].[MessageStatus] ([MessageStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (8, 'Inbound Removed', '2014-07-14 10:22:46.377', 'HIPS', '2014-07-14 10:22:46.377', 'HIPS')
INSERT INTO [smd].[MessageStatus] ([MessageStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (20, 'Outbound Undelivered', '2014-07-14 10:22:46.377', 'HIPS', '2014-07-14 10:22:46.377', 'HIPS')
INSERT INTO [smd].[MessageStatus] ([MessageStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (21, 'Outbound Delivered', '2014-07-14 10:22:46.377', 'HIPS', '2014-07-14 10:22:46.377', 'HIPS')
INSERT INTO [smd].[MessageStatus] ([MessageStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (22, 'Outbound Responded', '2014-07-14 10:22:46.380', 'HIPS', '2014-07-14 10:22:46.380', 'HIPS')
INSERT INTO [smd].[MessageStatus] ([MessageStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (23, 'Outbound Acknowledged', '2014-07-14 10:22:46.380', 'HIPS', '2014-07-14 10:22:46.380', 'HIPS')
INSERT INTO [smd].[MessageStatus] ([MessageStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (24, 'Outbound Failed', '2014-07-14 10:22:46.380', 'HIPS', '2014-07-14 10:22:46.380', 'HIPS')
INSERT INTO [smd].[MessageStatus] ([MessageStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (25, 'Outbound Expired', '2014-07-14 10:22:46.380', 'HIPS', '2014-07-14 10:22:46.380', 'HIPS')
INSERT INTO [smd].[MessageStatus] ([MessageStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (26, 'Outbound Removed', '2014-07-14 10:22:46.383', 'HIPS', '2014-07-14 10:22:46.383', 'HIPS')
INSERT INTO [smd].[MessageStatus] ([MessageStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (27, 'Outbound Retried', '2014-07-14 10:22:46.383', 'HIPS', '2014-07-14 10:22:46.383', 'HIPS')
INSERT INTO [smd].[MessageStatus] ([MessageStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (28, 'Undeliverable  Expired', '2014-07-14 10:22:46.383', 'HIPS', '2014-07-14 10:22:46.383', 'HIPS')
INSERT INTO [smd].[MessageStatus] ([MessageStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (29, 'Undeliverable  Exceeded Retry Count', '2014-07-14 10:22:46.383', 'HIPS', '2014-07-14 10:22:46.383', 'HIPS')

-- PayloadPackaging based on supported payload schemes. XDM-ZIP is compliant with NEHTA P2P Specifications. HL7-MDM is included for compatibility with earlier clinical software.
PRINT(N'Add 4 rows to [els].[PayloadPackaging]')
GO
SET IDENTITY_INSERT [els].[PayloadPackaging] ON
INSERT INTO [els].[PayloadPackaging] ([PayloadPackagingId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 'xdmZip', '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [els].[PayloadPackaging] ([PayloadPackagingId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 'hl7Mdm', '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [els].[PayloadPackaging] ([PayloadPackagingId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 'binary', '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [els].[PayloadPackaging] ([PayloadPackagingId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 'print', '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
SET IDENTITY_INSERT [els].[PayloadPackaging] OFF

-- Sourced from HIPS P2P Directory Maintenance Technical Design
PRINT(N'Add 3 rows to [nhsd].[ProviderEntityType]')
GO
INSERT INTO [nhsd].[ProviderEntityType] ([ProviderEntityTypeId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 'Individual', '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [nhsd].[ProviderEntityType] ([ProviderEntityTypeId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 'Organisation', '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [nhsd].[ProviderEntityType] ([ProviderEntityTypeId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 'Link', '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [nhsd].[ProviderEntityType] ([ProviderEntityTypeId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 'Location', '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')

-- ProviderIdentifierStatus values are sourced from TECH.SIS.HI.31 service rule WR31.1
--   "The record status can be A='active', D='deactivated' or R='retired'.
-- And from NEHTA_1651_2014 UseofHIsinHealthSoftwareSystems ConformanceRequirements v3.0.
-- Alerts are flagged in identifier status because of 10613, "The software shall not include a healthcare identifier (IHI, HPI-O, HPI-I) in an eHealth message/document if an unresolved exception or alert exists for that identifier in the local system."
--   Invalid HPI before P2P send: 17571 (recipient), 18884 (author), "If a HPI-I or HPI-O cannot be validated then it shall not be included in the eHealth message/document and an alert shall be raised"
--   Invalid HPI-I after it was resolved: 23502 "If the new healthcare provider individual identifier cannot be validated with the local healthcare provider individual identifier demographic data then an alert shall be raised so an operator can determine what action should be taken."
--   Invalid HPI-I after name changed: 23503 "If the name associated with a HPI-I is changed then the software shall revalidate the HPI-I with the new demographic data. If the validation fails then the software shall raise an alert against the HPI-I."
PRINT(N'Add 6 rows to [nhsd].[ProviderIdentifierStatus]')
GO
INSERT INTO [nhsd].[ProviderIdentifierStatus] ([ProviderIdentifierStatusId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 'A', 'Active', '2014-07-14 10:22:45.590', 'HIPS', '2014-07-14 10:22:45.590', 'HIPS')
INSERT INTO [nhsd].[ProviderIdentifierStatus] ([ProviderIdentifierStatusId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 'D', 'Deactivated', '2014-07-14 10:22:45.590', 'HIPS', '2014-07-14 10:22:45.590', 'HIPS')
INSERT INTO [nhsd].[ProviderIdentifierStatus] ([ProviderIdentifierStatusId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 'R', 'Retired', '2014-07-14 10:22:45.590', 'HIPS', '2014-07-14 10:22:45.590', 'HIPS')
INSERT INTO [nhsd].[ProviderIdentifierStatus] ([ProviderIdentifierStatusId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (10, 'UA-SEND', 'Unresolved Alert - Invalid HPI for Send', '2014-07-14 10:22:45.593', 'HIPS', '2014-07-14 10:22:45.593', 'HIPS')
INSERT INTO [nhsd].[ProviderIdentifierStatus] ([ProviderIdentifierStatusId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (11, 'UA-RESOLVED', 'Unresolved Alert - Invalid Resolved HPI-I', '2014-07-14 10:22:45.593', 'HIPS', '2014-07-14 10:22:45.593', 'HIPS')
INSERT INTO [nhsd].[ProviderIdentifierStatus] ([ProviderIdentifierStatusId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (12, 'UA-NAME', 'Unresolved Alert - Invalid Name Change', '2014-07-14 10:22:45.593', 'HIPS', '2014-07-14 10:22:45.593', 'HIPS')

-- This ServiceInterface is defined in ATS 58222010  E-Health Secure Message Delivery (with Amendment 1-2010).
PRINT(N'Add 5 rows to [els].[ServiceInterface]')
GO
SET IDENTITY_INSERT [els].[ServiceInterface] ON
INSERT INTO [els].[ServiceInterface] ([ServiceInterfaceId], [QualifiedIdentifier], [Name], [AdditionalComments], [PriorityNumber], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 'http://ns.electronichealth.net.au/smd/intf/SealedMessageDelivery/TLS/2010', 'SMD TLS', 'Sealed Message Delivery with TLS Security Profile', 1, '2014-07-14 10:22:45.583', 'HIPS', '2014-07-14 10:22:45.583', 'HIPS')
INSERT INTO [els].[ServiceInterface] ([ServiceInterfaceId], [QualifiedIdentifier], [Name], [AdditionalComments], [PriorityNumber], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 'http://ns.electronichealth.net.au/smd/intf/SealedImmediateMessageDelivery/TLS/2010', 'SIMD TLS', 'Sealed Immediate Message Delivery with TLS Security Profile', 0, '2014-07-14 10:22:45.587', 'HIPS', '2014-07-14 10:22:45.587', 'HIPS')
INSERT INTO [els].[ServiceInterface] ([ServiceInterfaceId], [QualifiedIdentifier], [Name], [AdditionalComments], [PriorityNumber], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 'http://ns.electronichealth.net.au/smd/intf/SealedMessageRetrieval/TLS/2010', 'SMR TLS', 'Sealed Message Retrieval with TLS Security Profile', 0, '2014-07-14 10:22:45.587', 'HIPS', '2014-07-14 10:22:45.587', 'HIPS')
INSERT INTO [els].[ServiceInterface] ([ServiceInterfaceId], [QualifiedIdentifier], [Name], [AdditionalComments], [PriorityNumber], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 'http://ns.electronichealth.net.au/smd/intf/TransportResponseDelivery/TLS/2010', 'TRD TLS', 'Transport Response Delivery with TLS Security Profile', 0, '2014-07-14 10:22:45.587', 'HIPS', '2014-07-14 10:22:45.587', 'HIPS')
INSERT INTO [els].[ServiceInterface] ([ServiceInterfaceId], [QualifiedIdentifier], [Name], [AdditionalComments], [PriorityNumber], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, 'http://ns.electronichealth.net.au/smd/intf/TransportResponseRetrieval/TLS/2010', 'TRR TLS', 'Transport Response Retrieval with TLS Security Profile', 0, '2014-07-14 10:22:45.590', 'HIPS', '2014-07-14 10:22:45.590', 'HIPS')
SET IDENTITY_INSERT [els].[ServiceInterface] OFF

-- Sex sourced from TECH.SIS.HI.02 v4.0 June 2013
PRINT(N'Add 4 rows to [smd].[Sex]')
GO
INSERT INTO [smd].[Sex] ([SexId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 'M', 'Male', '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [smd].[Sex] ([SexId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 'F', 'Female', '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [smd].[Sex] ([SexId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 'I', 'Intersex or Indeterminate', '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [smd].[Sex] ([SexId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 'N', 'Not stated/inadequately described', '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')

PRINT(N'Add 4 rows to [smd].[TransportResponseClass]')
GO
INSERT INTO [smd].[TransportResponseClass] ([TransportResponseClassId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 'Success', '2014-07-14 10:22:46.390', 'HIPS', '2014-07-14 10:22:46.390', 'HIPS')
INSERT INTO [smd].[TransportResponseClass] ([TransportResponseClassId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 'Information', '2014-07-14 10:22:46.390', 'HIPS', '2014-07-14 10:22:46.390', 'HIPS')
INSERT INTO [smd].[TransportResponseClass] ([TransportResponseClassId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 'Warning', '2014-07-14 10:22:46.390', 'HIPS', '2014-07-14 10:22:46.390', 'HIPS')
INSERT INTO [smd].[TransportResponseClass] ([TransportResponseClassId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 'Error', '2014-07-14 10:22:46.390', 'HIPS', '2014-07-14 10:22:46.390', 'HIPS')

PRINT(N'Add 6 rows to [smd].[TransportResponseStatus]')
GO
INSERT INTO [smd].[TransportResponseStatus] ([TransportResponseStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 'Inbound Undelivered', '2014-07-14 10:22:46.383', 'HIPS', '2014-07-14 10:22:46.383', 'HIPS')
INSERT INTO [smd].[TransportResponseStatus] ([TransportResponseStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 'Inbound Delivered', '2014-07-14 10:22:46.383', 'HIPS', '2014-07-14 10:22:46.383', 'HIPS')
INSERT INTO [smd].[TransportResponseStatus] ([TransportResponseStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 'Inbound Expired', '2014-07-14 10:22:46.387', 'HIPS', '2014-07-14 10:22:46.387', 'HIPS')
INSERT INTO [smd].[TransportResponseStatus] ([TransportResponseStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 'Inbound Aborted', '2014-07-14 10:22:46.387', 'HIPS', '2014-07-14 10:22:46.387', 'HIPS')
INSERT INTO [smd].[TransportResponseStatus] ([TransportResponseStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (20, 'Outbound Received', '2014-07-14 10:22:46.387', 'HIPS', '2014-07-14 10:22:46.387', 'HIPS')
INSERT INTO [smd].[TransportResponseStatus] ([TransportResponseStatusId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (21, 'Outbound Local', '2014-07-14 10:22:46.390', 'HIPS', '2014-07-14 10:22:46.390', 'HIPS')

PRINT(N'Add 14 rows to [els].[PayloadScheme]')
GO
SET IDENTITY_INSERT [els].[PayloadScheme] ON
INSERT INTO [els].[PayloadScheme] ([PayloadSchemeId], [PayloadPackagingId], [DocumentTypeId], [QualifiedIdentifier], [Name], [AdditionalComments], [IsActive], [PriorityNumber], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 1, 1, 'http://ns.electronichealth.net.au/ds/sc/deliver/xdmZip/2012', 'Discharge Summary CDA Package', NULL, 1, 2, '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [els].[PayloadScheme] ([PayloadSchemeId], [PayloadPackagingId], [DocumentTypeId], [QualifiedIdentifier], [Name], [AdditionalComments], [IsActive], [PriorityNumber], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 2, 1, 'http://ns.electronichealth.net.au/ds/sc/deliver/hl7Mdm/2012', 'Discharge Summary CDA Package in MDM', NULL, 1, 1, '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [els].[PayloadScheme] ([PayloadSchemeId], [PayloadPackagingId], [DocumentTypeId], [QualifiedIdentifier], [Name], [AdditionalComments], [IsActive], [PriorityNumber], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 4, 1, 'http://ns.healthdirect.gov.au/neps/ds/sc/deliver/print/2014', 'Discharge Summary (Printed)', NULL, 1, 1, '2014-04-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [els].[PayloadScheme] ([PayloadSchemeId], [PayloadPackagingId], [DocumentTypeId], [QualifiedIdentifier], [Name], [AdditionalComments], [IsActive], [PriorityNumber], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 1, 2, 'http://ns.electronichealth.net.au/es/sc/deliver/xdmZip/2012', 'Event Summary CDA Package', NULL, 1, 2, '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [els].[PayloadScheme] ([PayloadSchemeId], [PayloadPackagingId], [DocumentTypeId], [QualifiedIdentifier], [Name], [AdditionalComments], [IsActive], [PriorityNumber], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, 2, 2, 'http://ns.electronichealth.net.au/es/sc/deliver/hl7Mdm/2012', 'Event Summary CDA Package in MDM', NULL, 1, 1, '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [els].[PayloadScheme] ([PayloadSchemeId], [PayloadPackagingId], [DocumentTypeId], [QualifiedIdentifier], [Name], [AdditionalComments], [IsActive], [PriorityNumber], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (6, 4, 2, 'http://ns.healthdirect.gov.au/neps/es/sc/deliver/print/2014', 'Event Summary (Printed)', NULL, 1, 1, '2014-04-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [els].[PayloadScheme] ([PayloadSchemeId], [PayloadPackagingId], [DocumentTypeId], [QualifiedIdentifier], [Name], [AdditionalComments], [IsActive], [PriorityNumber], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (7, 1, 3, 'http://ns.electronichealth.net.au/sl/sc/deliver/xdmZip/2012', 'Specialist Letter CDA Package', NULL, 1, 2, '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [els].[PayloadScheme] ([PayloadSchemeId], [PayloadPackagingId], [DocumentTypeId], [QualifiedIdentifier], [Name], [AdditionalComments], [IsActive], [PriorityNumber], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (8, 2, 3, 'http://ns.electronichealth.net.au/sl/sc/deliver/hl7Mdm/2012', 'Specialist Letter CDA Package in MDM', NULL, 1, 1, '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [els].[PayloadScheme] ([PayloadSchemeId], [PayloadPackagingId], [DocumentTypeId], [QualifiedIdentifier], [Name], [AdditionalComments], [IsActive], [PriorityNumber], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (9, 4, 3, 'http://ns.healthdirect.gov.au/neps/sl/sc/deliver/print/2014', 'Specialist Letter (Printed)', NULL, 1, 1, '2014-04-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [els].[PayloadScheme] ([PayloadSchemeId], [PayloadPackagingId], [DocumentTypeId], [QualifiedIdentifier], [Name], [AdditionalComments], [IsActive], [PriorityNumber], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (10, 1, 4, 'http://ns.electronichealth.net.au/er/sc/deliver/xdmZip/2012', 'e-Referral CDA Package', NULL, 1, 2, '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [els].[PayloadScheme] ([PayloadSchemeId], [PayloadPackagingId], [DocumentTypeId], [QualifiedIdentifier], [Name], [AdditionalComments], [IsActive], [PriorityNumber], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (11, 2, 4, 'http://ns.electronichealth.net.au/er/sc/deliver/hl7Mdm/2012', 'e-Referral CDA Package in MDM', NULL, 1, 1, '2014-03-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [els].[PayloadScheme] ([PayloadSchemeId], [PayloadPackagingId], [DocumentTypeId], [QualifiedIdentifier], [Name], [AdditionalComments], [IsActive], [PriorityNumber], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (12, 4, 4, 'http://ns.healthdirect.gov.au/neps/er/sc/deliver/print/2014', 'Referral (Printed)', NULL, 1, 1, '2014-04-12 00:00:00.000', 'HIPS', '2014-03-12 00:00:00.000', 'HIPS')
INSERT INTO [els].[PayloadScheme] ([PayloadSchemeId], [PayloadPackagingId], [DocumentTypeId], [QualifiedIdentifier], [Name], [AdditionalComments], [IsActive], [PriorityNumber], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (13, 3, 5, 'http://ns.electronichealth.net.au/ack/sc/deliver/hl7Ack/2012', 'HL7 Acknowledgement', '', 1, 0, '2014-07-16 03:00:08.000', 'HIPS', '2014-07-16 03:00:08.000', 'HIPS')
INSERT INTO [els].[PayloadScheme] ([PayloadSchemeId], [PayloadPackagingId], [DocumentTypeId], [QualifiedIdentifier], [Name], [AdditionalComments], [IsActive], [PriorityNumber], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (14, 3, 1, 'http://ns.ahml.com.au/smd/sc/2.16.840.1.113883.2.3.3.14.1.1.3.6', 'Discharge Summary HL7 2.3.1 AS4700.6-2006', '', 1, 1, '2014-07-16 03:00:08.000', 'HIPS', '2014-07-16 03:00:08.000', 'HIPS')
SET IDENTITY_INSERT [els].[PayloadScheme] OFF

DELETE FROM [p2p].[Setting]
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, N'HPI-I validity period (hours)', N'24', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, N'HPI-O validity period (hours)', N'24', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, N'Default Responsible User Identifier', N'default', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, N'Default Responsible User Name', N'default', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, N'Default Responsible User Accessing HPI-O', N'default', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (6, N'Message Publishing Interval (seconds)', N'60', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (7, N'Response Receipt Interval (seconds)', N'60', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (8, N'Response Delivery Interval (seconds)', N'60', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (9, N'Response Delivery Timeout Period (seconds)', N'86400', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (10, N'Message Publishing Target Persistence Path', N'Published Messages path', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (11, N'Message Delivery Interval (seconds)', N'60', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (12, N'IHI validation flag', N'true', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (13, N'Message Receipt Service Interval (seconds)', N'60', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (14, N'Message Receipt Service Limit (number of messages to retrieve)', N'5', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (15, N'External URL for Transport Response Delivery service endpoint', N'https://.../TransportResponseDelivery.svc', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (16, N'Error Message Interval (seconds)', N'60', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (17, N'Error Message Limit (number of error messages to retrieve)', N'5', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (18, N'Audit Smd Request Xml', N'true', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (19, N'Audit Smd Response Xml', N'true', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (20, N'Audit Neps Request Xml', N'true', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (21, N'Audit Neps Response Xml', N'true', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (22, N'Known Valid HPI-Os (comma separated)', N'', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (23, N'Max Retry Count', N'1440', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (24, N'Reference Data Interval (seconds)', N'3600', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (25, N'Synchronisation Interval (seconds)', N'60', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (26, N'Subscription Changes Batch Size', N'50', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
INSERT [p2p].[Setting] ([SettingId], [Description], [Value], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (27, N'NASH Provider OID', N'1.2.36.174030967.1.10.1.1', '2015-01-01 00:00:00', N'HIPS', '2015-01-01 00:00:00', N'HIPS')
GO

PRINT(N'Add 3 rows to [nhsd].[ReferenceProfile]')
GO
SET IDENTITY_INSERT [nhsd].[ReferenceProfile] ON 
INSERT [nhsd].[ReferenceProfile] ([ReferenceProfileId], [Uri], [Name], [DisplayName], [Status], [Owner], [Version], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (10, N'urn:x-nhsd.au:profile:hiservice;16072014', N'hiservice', N'HI Service', N'ACTIVE', N'HDA', N'16072014', N'HI Service', '2014-01-01 00:00:00', N'HIPS', '2014-01-01 00:00:00', N'HIPS')
INSERT [nhsd].[ReferenceProfile] ([ReferenceProfileId], [Uri], [Name], [DisplayName], [Status], [Owner], [Version], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (11, N'urn:x-nhsd.au:profile:general;16072014', N'general', N'General', N'ACTIVE', N'HDA', N'16072014', N'General', '2014-01-01 00:00:00', N'HIPS', '2014-01-01 00:00:00', N'HIPS')
INSERT [nhsd].[ReferenceProfile] ([ReferenceProfileId], [Uri], [Name], [DisplayName], [Status], [Owner], [Version], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (12, N'urn:x-nhsd.au:profile:ehealth;08122014', N'ehealth', N'eHealth', N'ACTIVE', N'HDA', N'08122014', N'eHealth', '2014-01-01 00:00:00', N'HIPS', '2014-01-01 00:00:00', N'HIPS')
SET IDENTITY_INSERT [nhsd].[ReferenceProfile] OFF
GO

PRINT(N'Add 25 rows to [nhsd].[ReferenceSet]')
GO
SET IDENTITY_INSERT [nhsd].[ReferenceSet] ON 
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (64, 10, NULL, 'urn:x-nhsd.au:set:hiservice;16072014;provider_organisation_type', 'Provider Organisation Type', 'Provider Organisation Type', 'ACTIVE', NULL, NULL, '[Source: HI Service] Provider Organisation Type', 30, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (65, 10, NULL, 'urn:x-nhsd.au:set:hiservice;16072014;provider_organisation_services_type', 'Provider Organisation Services Type', 'Provider Organisation Services Type', 'ACTIVE', NULL, NULL, '[Source: HI Service] Provider Organisation Services Type', 30, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (66, 10, NULL, 'urn:x-nhsd.au:set:hiservice;16072014;provider_organisation_service_unit', 'Provider Organisation Service Unit', 'Provider Organisation Service Unit', 'ACTIVE', NULL, NULL, '[Source: HI Service] Provider Organisation Service Unit', 30, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (67, 10, NULL, 'urn:x-nhsd.au:set:hiservice;16072014;provider_individual_type', 'Provider Individual Type', 'Provider Individual Type', 'ACTIVE', NULL, NULL, '[Source: HI Service] Provider Individual Type', 30, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (68, 10, NULL, 'urn:x-nhsd.au:set:hiservice;16072014;provider_individual_specialty', 'Provider Individual Specialty', 'Provider Individual Specialty', 'ACTIVE', NULL, NULL, '[Source: HI Service] Provider Individual Specialty', 30, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (69, 10, NULL, 'urn:x-nhsd.au:set:hiservice;16072014;provider_individual_specialisation', 'Provider Individual Specialisation', 'Provider Individual Specialisation', 'ACTIVE', NULL, NULL, '[Source: HI Service] Provider Individual Specialisation', 30, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (70, 11, NULL, 'urn:x-nhsd.au:set:general;16072014;identifier_type', 'Identifier Type', 'Identifier Type', 'ACTIVE', NULL, NULL, '[Source: Business] Identifier Type', 7, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (71, 11, NULL, 'urn:x-nhsd.au:set:general;16072014;contact_purpose', 'Contact Purpose', 'Contact Purpose', 'ACTIVE', NULL, NULL, '[Source: Business] Contact Purpose', 7, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (72, 11, NULL, 'urn:x-nhsd.au:set:general;16072014;contact_type', 'Contact Type', 'Contact Type', 'ACTIVE', NULL, NULL, '[Source: Business] Contact Type', 7, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (73, 11, NULL, 'urn:x-nhsd.au:set:general;16072014;known_as', 'Known As', 'Known As', 'ACTIVE', NULL, NULL, '[Source: Business] Known As', 7, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (74, 11, NULL, 'urn:x-nhsd.au:set:general;16072014;organisation_relationship', 'Organisation Relationship', 'Organisation Relationship', 'ACTIVE', NULL, NULL, '[Source: Business] Organisation Relationship', 7, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (75, 11, NULL, 'urn:x-nhsd.au:set:general;16072014;organisation_status', 'Organisation Status', 'Organisation Status', 'ACTIVE', NULL, NULL, '[Source: Business] Organisation Status', 7, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (76, 11, NULL, 'urn:x-nhsd.au:set:general;16072014;person_status', 'Person Status', 'Person Status', 'ACTIVE', NULL, NULL, '[Source: Business] Person Status', 7, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (77, 11, NULL, 'urn:x-nhsd.au:set:general;16072014;level_type', 'Level Type', 'Level Type', 'ACTIVE', NULL, NULL, '[Source: G-NAF] Level Type', 7, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (78, 11, NULL, 'urn:x-nhsd.au:set:general;16072014;flat_type', 'Flat Type', 'Flat Type', 'ACTIVE', NULL, NULL, '[Source: G-NAF] Flat Type', 7, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (79, 11, NULL, 'urn:x-nhsd.au:set:general;16072014;street_suffix', 'Street Suffix', 'Street Suffix', 'ACTIVE', NULL, NULL, '[Source: G-NAF] Street Suffix', 7, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (80, 11, NULL, 'urn:x-nhsd.au:set:general;16072014;street_type', 'Street Type', 'Street Type', 'ACTIVE', NULL, NULL, '[Source: G-NAF] Street Type', 7, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (81, 11, NULL, 'urn:x-nhsd.au:set:general;16072014;state', 'State', 'State', 'ACTIVE', NULL, NULL, '[Source: Australia Post] State', 7, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (82, 11, NULL, 'urn:x-nhsd.au:set:general;16072014;gender', 'Gender', 'Gender', 'ACTIVE', NULL, NULL, '[Source: HI Service] Gender', 30, '2015-01-01', '2015-01-01', 'HIPS', '2015-01-01', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (83, 12, NULL, 'urn:x-nhsd.au:set:ehealth;08122014;document_type', 'Document Type', 'Document Type', 'ACTIVE', NULL, NULL, '[Source: EHealth]', 7, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (84, 12, NULL, 'urn:x-nhsd.au:set:ehealth;08122014;channel_type', 'Channel Type', 'Channel Type', 'ACTIVE', NULL, NULL, '[Source: EHealth]', 7, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (85, 12, NULL, 'urn:x-nhsd.au:set:ehealth;08122014;channel_carrier', 'Channel Carrier', 'Channel Carrier', 'ACTIVE', NULL, NULL, '[Source: EHealth]', 7, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (86, 12, NULL, 'urn:x-nhsd.au:set:ehealth;08122014;document_format', 'Document Format', 'Document Format', 'ACTIVE', NULL, NULL, '[Source: EHealth]', 7, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (87, 12, NULL, 'urn:x-nhsd.au:set:ehealth;08122014;ehealth_identifier_type', 'Ehealth Identifier Type', 'Ehealth Identifier Type', 'ACTIVE', NULL, NULL, '[Source: EHealth]', 7, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
INSERT [nhsd].[ReferenceSet] ([ReferenceSetId], [ReferenceProfileId], [RelatedReferenceSetId], [Uri], [Name], [DisplayName], [Status], [RelationshipType], [Category], [Description], [UpdateFrequency], [DateLastUpdated], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (95, 11, NULL, 'urn:x-nhsd.au:set:general;16072014;suburb', 'Suburb', 'Suburb', 'ACTIVE', NULL, NULL, '[Source: Australia Post] Suburb', 7, '2014-01-01 00:00:00', '2014-01-01 00:00:00', 'HIPS', '2014-01-01 00:00:00', 'HIPS')
SET IDENTITY_INSERT [nhsd].[ReferenceSet] OFF
GO

PRINT(N'Add 15 rows to [nhsd].[ReferenceItem]')
GO
SET IDENTITY_INSERT [nhsd].[ReferenceItem] ON
INSERT [nhsd].[ReferenceItem] ([ReferenceItemId], [ReferenceSetId], [Code], [SubCode], [Uri], [Name], [DisplayName], [Status], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 70, 'Provider_Number', NULL, 'urn:x-nhsd.au:item:general;16072014;identifier_type;provider_number', 'Provider Number', 'Provider Number', 'ACTIVE', 'Provider Number', '2015-01-01', 'HIPS', '2015-01-01', 'HIPS')
INSERT [nhsd].[ReferenceItem] ([ReferenceItemId], [ReferenceSetId], [Code], [SubCode], [Uri], [Name], [DisplayName], [Status], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 70, 'AHPRA_Registration_Number', NULL, 'urn:x-nhsd.au:item:general;16072014;identifier_type;ahpra_registration_number', 'AHPRA Registration Number', 'AHPRA Registration Number', 'ACTIVE', 'AHPRA Registration Number', '2015-01-01', 'HIPS', '2015-01-01', 'HIPS')
INSERT [nhsd].[ReferenceItem] ([ReferenceItemId], [ReferenceSetId], [Code], [SubCode], [Uri], [Name], [DisplayName], [Status], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 70, 'AHPRA_Profession_Number', NULL, 'urn:x-nhsd.au:item:general;16072014;identifier_type;ahpra_profession_number', 'AHPRA Profession Number', 'AHPRA Profession Number', 'ACTIVE', 'AHPRA Profession Number', '2015-01-01', 'HIPS', '2015-01-01', 'HIPS')
INSERT [nhsd].[ReferenceItem] ([ReferenceItemId], [ReferenceSetId], [Code], [SubCode], [Uri], [Name], [DisplayName], [Status], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 70, 'HPI-O', NULL, 'urn:x-nhsd.au:item:general;16072014;identifier_type;hpi-o', 'HPI-O', 'HPI-O', 'ACTIVE', 'HPI-O', '2015-01-01', 'HIPS', '2015-01-01', 'HIPS')
INSERT [nhsd].[ReferenceItem] ([ReferenceItemId], [ReferenceSetId], [Code], [SubCode], [Uri], [Name], [DisplayName], [Status], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, 70, 'HPI-I', NULL, 'urn:x-nhsd.au:item:general;16072014;identifier_type;hpi-i', 'HPI-I', 'HPI-I', 'ACTIVE', 'HPI-I', '2015-01-01', 'HIPS', '2015-01-01', 'HIPS')
INSERT [nhsd].[ReferenceItem] ([ReferenceItemId], [ReferenceSetId], [Code], [SubCode], [Uri], [Name], [DisplayName], [Status], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (6, 70, 'IH-I', NULL, 'urn:x-nhsd.au:item:general;16072014;identifier_type;ih-i', 'IH-I', 'IH-I', 'ACTIVE', 'IH-I', '2015-01-01', 'HIPS', '2015-01-01', 'HIPS')
INSERT [nhsd].[ReferenceItem] ([ReferenceItemId], [ReferenceSetId], [Code], [SubCode], [Uri], [Name], [DisplayName], [Status], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (7, 70, 'ABN', NULL, 'urn:x-nhsd.au:item:general;16072014;identifier_type;abn', 'ABN', 'ABN', 'ACTIVE', 'ABN', '2015-01-01', 'HIPS', '2015-01-01', 'HIPS')
INSERT [nhsd].[ReferenceItem] ([ReferenceItemId], [ReferenceSetId], [Code], [SubCode], [Uri], [Name], [DisplayName], [Status], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (8, 70, 'ACN', NULL, 'urn:x-nhsd.au:item:general;16072014;identifier_type;acn', 'ACN', 'ACN', 'ACTIVE', 'ACN', '2015-01-01', 'HIPS', '2015-01-01', 'HIPS')
INSERT [nhsd].[ReferenceItem] ([ReferenceItemId], [ReferenceSetId], [Code], [SubCode], [Uri], [Name], [DisplayName], [Status], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (9, 70, 'NHSD_URI', NULL, 'urn:x-nhsd.au:item:general;16072014;identifier_type;nhsd_uri', 'NHSD URI', 'NHSD URI', 'ACTIVE', 'NHSD URI', '2015-01-01', 'HIPS', '2015-01-01', 'HIPS')
INSERT [nhsd].[ReferenceItem] ([ReferenceItemId], [ReferenceSetId], [Code], [SubCode], [Uri], [Name], [DisplayName], [Status], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (10, 70, 'Site_ID', NULL, 'urn:x-nhsd.au:item:general;16072014;identifier_type;site_id', 'Site ID', 'Site ID', 'ACTIVE', 'Site ID', '2015-01-01', 'HIPS', '2015-01-01', 'HIPS')
INSERT [nhsd].[ReferenceItem] ([ReferenceItemId], [ReferenceSetId], [Code], [SubCode], [Uri], [Name], [DisplayName], [Status], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (11, 70, 'Agency_ID', NULL, 'urn:x-nhsd.au:item:general;16072014;identifier_type;agency_id', 'Agency ID', 'Agency ID', 'ACTIVE', 'Agency ID', '2015-01-01', 'HIPS', '2015-01-01', 'HIPS')
INSERT [nhsd].[ReferenceItem] ([ReferenceItemId], [ReferenceSetId], [Code], [SubCode], [Uri], [Name], [DisplayName], [Status], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (12, 70, 'SSID', NULL, 'urn:x-nhsd.au:item:general;16072014;identifier_type;ssid', 'SSID', 'SSID', 'ACTIVE', 'SSID', '2015-01-01', 'HIPS', '2015-01-01', 'HIPS')
INSERT [nhsd].[ReferenceItem] ([ReferenceItemId], [ReferenceSetId], [Code], [SubCode], [Uri], [Name], [DisplayName], [Status], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (13, 70, 'ABRN', NULL, 'urn:x-nhsd.au:item:general;16072014;identifier_type;abrn', 'ABRN', 'ABRN', 'ACTIVE', 'ABRN', '2015-01-01', 'HIPS', '2015-01-01', 'HIPS')
INSERT [nhsd].[ReferenceItem] ([ReferenceItemId], [ReferenceSetId], [Code], [SubCode], [Uri], [Name], [DisplayName], [Status], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (14, 70, 'URI', NULL, 'urn:x-nhsd.au:item:general;16072014;identifier_type;uri', 'URI', 'URI', 'ACTIVE', 'Uniform Resource Identifier', '2015-01-01', 'HIPS', '2015-01-01', 'HIPS')
INSERT [nhsd].[ReferenceItem] ([ReferenceItemId], [ReferenceSetId], [Code], [SubCode], [Uri], [Name], [DisplayName], [Status], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (15, 70, 'AHPRA_ID', NULL, 'urn:x-nhsd.au:item:general;16072014;identifier_type;ahpra_id', 'AHPRA ID', 'AHPRA ID', 'ACTIVE', 'AHPRA ID', '2015-01-01', 'HIPS', '2015-01-01', 'HIPS')
SET IDENTITY_INSERT [nhsd].[ReferenceItem] OFF
GO

-- Sourced from HIPS P2P Directory Maintenance Technical Design
PRINT(N'Add 10 rows to [nhsd].[ProviderIdentifierType]')
GO
SET IDENTITY_INSERT [nhsd].[ProviderIdentifierType] ON
INSERT INTO [nhsd].[ProviderIdentifierType] ([ProviderIdentifierTypeId], [ProviderEntityTypeId], [IdentifierTypeReferenceItemId], [Code], [Description], [UriQualifier], [OidQualifier], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 1, 9, 'NHSDI', 'National Health Service Directory - Individual', 'urn:x-nhsd.au:pers:', '', '2014-07-14 10:22:45.603', 'HIPS', '2014-07-14 10:22:45.603', 'HIPS')
INSERT INTO [nhsd].[ProviderIdentifierType] ([ProviderIdentifierTypeId], [ProviderEntityTypeId], [IdentifierTypeReferenceItemId], [Code], [Description], [UriQualifier], [OidQualifier], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 2, 9, 'NHSDO', 'National Health Service Directory - Organisation', 'urn:x-nhsd.au:org:', '', '2014-07-14 10:22:45.607', 'HIPS', '2014-07-14 10:22:45.607', 'HIPS')
INSERT INTO [nhsd].[ProviderIdentifierType] ([ProviderIdentifierTypeId], [ProviderEntityTypeId], [IdentifierTypeReferenceItemId], [Code], [Description], [UriQualifier], [OidQualifier], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, 1, 5, 'HPII', 'Healthcare Provider Identifier - Individual', 'http://ns.electronichealth.net.au/id/hi/hpii/1.0/', '', '2014-07-14 10:22:45.607', 'HIPS', '2014-07-14 10:22:45.607', 'HIPS')
INSERT INTO [nhsd].[ProviderIdentifierType] ([ProviderIdentifierTypeId], [ProviderEntityTypeId], [IdentifierTypeReferenceItemId], [Code], [Description], [UriQualifier], [OidQualifier], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (6, 2, 4, 'HPIO', 'Healthcare Provider Identifier - Organisation', 'http://ns.electronichealth.net.au/id/hi/hpio/1.0/', '', '2014-07-14 10:22:45.607', 'HIPS', '2014-07-14 10:22:45.607', 'HIPS')
INSERT INTO [nhsd].[ProviderIdentifierType] ([ProviderIdentifierTypeId], [ProviderEntityTypeId], [IdentifierTypeReferenceItemId], [Code], [Description], [UriQualifier], [OidQualifier], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (7, 1, 2, 'AHPRA', 'AHPRA Registration Number', '', '', '2014-07-14 10:22:45.607', 'HIPS', '2014-07-14 10:22:45.607', 'HIPS')
INSERT INTO [nhsd].[ProviderIdentifierType] ([ProviderIdentifierTypeId], [ProviderEntityTypeId], [IdentifierTypeReferenceItemId], [Code], [Description], [UriQualifier], [OidQualifier], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (8, 2, 7, 'ABN', 'Australian Business Number', '', '', '2014-07-14 10:22:45.610', 'HIPS', '2014-07-14 10:22:45.610', 'HIPS')
INSERT INTO [nhsd].[ProviderIdentifierType] ([ProviderIdentifierTypeId], [ProviderEntityTypeId], [IdentifierTypeReferenceItemId], [Code], [Description], [UriQualifier], [OidQualifier], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (9, 2, 8, 'ACN', 'Australian Company Number', '', '', '2014-07-14 10:22:45.610', 'HIPS', '2014-07-14 10:22:45.610', 'HIPS')
INSERT INTO [nhsd].[ProviderIdentifierType] ([ProviderIdentifierTypeId], [ProviderEntityTypeId], [IdentifierTypeReferenceItemId], [Code], [Description], [UriQualifier], [OidQualifier], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (10, 3, NULL, 'PLID', 'Provider Link Identifier', '', '', '2014-07-14 10:22:45.610', 'HIPS', '2014-07-14 10:22:45.610', 'HIPS')
INSERT INTO [nhsd].[ProviderIdentifierType] ([ProviderIdentifierTypeId], [ProviderEntityTypeId], [IdentifierTypeReferenceItemId], [Code], [Description], [UriQualifier], [OidQualifier], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (11, 4, 9, 'NHSDS', 'National Health Service Directory - Site ID', 'urn:x-nhsd.au:serv:', '', '2014-07-14 10:22:45.610', 'HIPS', '2014-07-14 10:22:45.610', 'HIPS')
INSERT INTO [nhsd].[ProviderIdentifierType] ([ProviderIdentifierTypeId], [ProviderEntityTypeId], [IdentifierTypeReferenceItemId], [Code], [Description], [UriQualifier], [OidQualifier], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (12, 3, 1, 'PVN', 'Medicare Provider Number', '', '', '2014-07-14 10:22:45.610', 'HIPS', '2014-07-14 10:22:45.610', 'HIPS')
SET IDENTITY_INSERT [nhsd].[ProviderIdentifierType] OFF
DBCC CHECKIDENT ('nhsd.ProviderIdentifierType', RESEED, 19)
GO

-- ProviderStatus values based on NEPS IndividualStatusTypeEnum
INSERT INTO [nhsd].[ProviderStatus] ([ProviderStatusId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 'A', 'Active', '2015-05-22', 'HIPS', '2015-05-22', 'HIPS')
INSERT INTO [nhsd].[ProviderStatus] ([ProviderStatusId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 'D', 'Deactivated', '2015-05-22', 'HIPS', '2015-05-22', 'HIPS')
INSERT INTO [nhsd].[ProviderStatus] ([ProviderStatusId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 'R', 'Retired', '2015-05-22', 'HIPS', '2015-05-22', 'HIPS')
GO

COMMIT TRANSACTION
GO
