/*
 ******************************************************************************
 * This script grants permission for the 'RunStoredProcedure' role to run the
 * stored procedures, functions and views required for HIPS P2P application to
 * operate.
 ******************************************************************************
 */

DECLARE @SQLST  [nvarchar](500)
DECLARE @SP_NAME  [nvarchar](80)
DECLARE @VIEW_NAME  [nvarchar](80)

/* EXECUTE PERMISSIONS ON STORED PROCEDURES (P) AND SCALAR FUNCTIONS (FN) */

DECLARE storproc_cursor CURSOR FOR  
	SELECT 
	  name
	FROM 
	  sys.objects
	WHERE type IN ('P', 'FN')
	AND schema_Name(schema_id) = 'nhsd'   
	ORDER BY name

OPEN storproc_cursor   
FETCH NEXT FROM storproc_cursor INTO @SP_NAME

WHILE @@FETCH_STATUS = 0   
BEGIN   
        
		SET @SQLST = N'GRANT EXECUTE ON [nhsd].['+RTRIM(@SP_NAME)+'] TO [RunStoredProcedure]'
		PRINT @SQLST
		
		EXECUTE sp_executesql @SQLST;
		
		FETCH NEXT FROM storproc_cursor INTO @SP_NAME
		
END   

CLOSE storproc_cursor   
DEALLOCATE storproc_cursor 

/* SELECT PERMISSIONS ON VIEWS (V) AND TABLE VALUED FUNCTIONS (FN) */

DECLARE view_cursor CURSOR FOR  
	SELECT 
	  name
	FROM 
	  sys.objects
	WHERE type IN ('V','TF')
	AND schema_Name(schema_id) = 'nhsd'
	ORDER BY name

OPEN view_cursor   
FETCH NEXT FROM view_cursor INTO @VIEW_NAME

WHILE @@FETCH_STATUS = 0   
BEGIN   
        
		SET @SQLST = N'GRANT SELECT ON [nhsd].['+RTRIM(@VIEW_NAME)+'] TO [RunStoredProcedure]'
		PRINT @SQLST
		
		EXECUTE sp_executesql @SQLST;
		
		FETCH NEXT FROM view_cursor INTO @VIEW_NAME
		
END   

CLOSE view_cursor   
DEALLOCATE view_cursor 

