-- ------------------------------------------------------------------------------
-- IMPORT FILES
-- ------------------------------------------------------------------------------

-- Set the database schema to owner of SCTAU tables
USE `sctau`;

-- RF2_CONCEPTS_FULL
TRUNCATE TABLE rf2_concepts_full
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Full/Terminology/sct2_Concept_Full_AU1000036_20150531.txt' INTO TABLE rf2_concepts_full CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, definitionstatusid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;

-- RF2_DESCRIPTIONS_FULL
TRUNCATE TABLE rf2_descriptions_full
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Full/Terminology/sct2_Description_Full-en-AU_AU1000036_20150531.txt' INTO TABLE rf2_descriptions_full CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, conceptid, languagecode, typeid, term, casesignificanceid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;

-- RF2_RELATIONSHIPS_FULL
TRUNCATE TABLE rf2_relationships_full
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Full/Terminology/sct2_Relationship_Full_AU1000036_20150531.txt' INTO TABLE rf2_relationships_full CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, sourceid, destinationid, relationshipgroup, typeid, characteristictypeid, modifierid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;

-- RF2_LANGUAGE_REFSET_FULL
TRUNCATE TABLE rf2_language_refset_full
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Full/Refset/Language/der2_cRefset_LanguageFull-en-AU_AU1000036_20150531.txt' INTO TABLE rf2_language_refset_full CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid, acceptabilityid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;

-- RF2_REFSET_FULL
-- NOTE: This SQL Statement will have to be used for every Refset File to ensure that all the Refsets in the release are in the table.
TRUNCATE TABLE rf2_refset_full
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Full/Refset/Content/der2_Refset_<REFSETNAME>Full_AU1000036_20150531.txt' INTO TABLE rf2_refset_full CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;
