/* --------------------------------------------------------------------------
-- Demonstration SNOMED CT-AU Schema creation script
-- The script creates the schema and associated SNAPSHOT tables 
-- to provide platform for installing & querying SNOMED CT-AU 
-- content:
------------------------------------------------------------------------*/

-- Set the database schema to owner of SCTAU tables
USE `sctau`;

--
-- Table structure for table `rf2_concepts_snapshot`
--

DROP TABLE IF EXISTS `rf2_concepts_snapshot`;
CREATE TABLE IF NOT EXISTS `rf2_concepts_snapshot` (
  `id` bigint(18) NOT NULL,
  `effectivetime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `active` int(1) NOT NULL,
  `moduleid` bigint(18) NOT NULL,
  `definitionstatusid` bigint(18) NOT NULL,
  PRIMARY KEY  (`id`,`effectivetime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


--
-- Table structure for table `rf2_descriptions_snapshot`
--

DROP TABLE IF EXISTS `rf2_descriptions_snapshot`;
CREATE TABLE IF NOT EXISTS `rf2_descriptions_snapshot` (
  `id` bigint(18) NOT NULL,
  `effectivetime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `active` int(1) NOT NULL,
  `moduleid` bigint(18) NOT NULL,
  `conceptid` bigint(18) NOT NULL,
  `languagecode` varchar(10) collate utf8_unicode_ci NOT NULL,
  `typeid` bigint(18) NOT NULL,
  `term` varchar(2048) collate utf8_unicode_ci NOT NULL,
  `casesignificanceid` bigint(18) NOT NULL,
  PRIMARY KEY  (`id`,`effectivetime`),
  CONSTRAINT FOREIGN KEY (conceptid) 
	REFERENCES rf2_concepts_snapshot(id) ON DELETE CASCADE,
  CONSTRAINT FOREIGN KEY (moduleid) 
	REFERENCES rf2_concepts_snapshot(id) ON DELETE CASCADE,
  CONSTRAINT FOREIGN KEY (typeid) 
	REFERENCES rf2_concepts_snapshot(id) ON DELETE CASCADE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



--
-- Table structure for table `rf2_relationships_snapshot`
--

DROP TABLE IF EXISTS `rf2_relationships_snapshot`;
CREATE TABLE IF NOT EXISTS `rf2_relationships_snapshot` (
  `id` bigint(18) NOT NULL,
  `effectivetime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `active` int(1) NOT NULL,
  `moduleid` bigint(18) NOT NULL,
  `sourceid` bigint(18) NOT NULL,
  `destinationid` bigint(18) NOT NULL,
  `relationshipgroup` bigint(18) NOT NULL,
  `typeid` bigint(18) NOT NULL,
  `characteristictypeid` bigint(18) NOT NULL,
  `modifierid` bigint(18) NOT NULL,
  PRIMARY KEY  (`id`,`effectivetime`),
  CONSTRAINT FOREIGN KEY (moduleid) 
	REFERENCES rf2_concepts_snapshot(id) ON DELETE CASCADE,
  CONSTRAINT FOREIGN KEY (typeid) 
	REFERENCES rf2_concepts_snapshot(id) ON DELETE CASCADE,
  CONSTRAINT FOREIGN KEY (characteristictypeid) 
	REFERENCES rf2_concepts_snapshot(id) ON DELETE CASCADE,
  CONSTRAINT FOREIGN KEY (sourceid) 
	REFERENCES rf2_concepts_snapshot(id) ON DELETE CASCADE,
  CONSTRAINT FOREIGN KEY (destinationid) 
	REFERENCES rf2_concepts_snapshot(id) ON DELETE CASCADE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


--
-- Table structure for table `rf2_language_refset_snapshot`
--

DROP TABLE IF EXISTS `rf2_language_refset_snapshot`;
CREATE TABLE IF NOT EXISTS `rf2_language_refset_snapshot` (
  `id` varchar(36) collate utf8_unicode_ci NOT NULL,
  `effectivetime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `active` int(1) NOT NULL,
  `moduleid` bigint(18) NOT NULL,
  `refsetid` bigint(18) NOT NULL,
  `referencedcomponentid` bigint(18) NOT NULL,
  `acceptabilityid` bigint(18) NOT NULL,
  PRIMARY KEY  (`id`,`effectivetime`),
  CONSTRAINT FOREIGN KEY (moduleid) 
	REFERENCES rf2_concepts_snapshot(id) ON DELETE CASCADE,
  CONSTRAINT FOREIGN KEY (refsetid) 
	REFERENCES rf2_concepts_snapshot(id) ON DELETE CASCADE,
  CONSTRAINT FOREIGN KEY (referencedcomponentid) 
	REFERENCES rf2_descriptions_snapshot(id) ON DELETE CASCADE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


--
-- Table structure for table `rf2_refset_snapshot`
--

DROP TABLE IF EXISTS `rf2_refset_snapshot`;
CREATE TABLE IF NOT EXISTS `rf2_refset_snapshot` (
  `id` varchar(36) collate utf8_unicode_ci NOT NULL,
  `effectivetime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `active` int(1) NOT NULL,
  `moduleid` bigint(18) NOT NULL,
  `refsetid` bigint(18) NOT NULL,
  `referencedcomponentid` bigint(18) NOT NULL,
  PRIMARY KEY  (`id`,`effectivetime`),
  CONSTRAINT FOREIGN KEY (moduleid) 
	REFERENCES rf2_concepts_snapshot(id) ON DELETE CASCADE,
  CONSTRAINT FOREIGN KEY (refsetid) 
	REFERENCES rf2_concepts_snapshot(id) ON DELETE CASCADE,
  CONSTRAINT FOREIGN KEY (referencedcomponentid) 
	REFERENCES rf2_concepts_snapshot(id) ON DELETE CASCADE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;






