-- 1.Search the Musculoskeletal finding reference set for all concepts that are related to the Foot structure based on Finding site
SELECT referencedcomponentid 
FROM rf2_refset_snapshot AS MSrefset
WHERE MSrefset.refsetId = 32570351000036105 -- Musculoskeletal finding reference set
AND MSrefset.active = 1
AND MSrefset.referencedcomponentid in 
	(SELECT sourceId 
	FROM rf2_relationships_snapshot
	WHERE active = 1 
	AND typeId = 363698007 -- Finding site
	AND destinationId = 56459004 -- Foot structure

);


-- 2. Identify inactive members of the Emergency department diagnosis reference set
SELECT referencedcomponentid 
FROM rf2_refset_snapshot as EDDrefset
INNER JOIN rf2_concepts_snapshot ON 
EDDrefset.referencedcomponentid = rf2_concepts_snapshot.id
WHERE EDDrefset.refsetid = 32570481000036109 -- Emergency department diagnosis reference set
AND EDDrefset.active = 1
AND rf2_concepts_snapshot.active=0;

-- 3. List all available descriptions for conceptId 387517004 Paracetamol
SELECT conceptId,id,term 
FROM rf2_descriptions_snapshot
WHERE conceptId = 387517004;


-- 4. List all descriptions that are referenced in the ADRS for concept 387517004 Paracetamol
SELECT conceptId,D.id,term, acceptabilityid 
FROM rf2_descriptions_snapshot AS D
INNER JOIN rf2_language_refset_snapshot AS ADRS 
ON D.id = ADRS.referencedcomponentid
WHERE D.conceptId = 387517004;


-- 5. The current Preferred Term for concept 387517004 Paracetamol
SELECT conceptId,D.id,term, acceptabilityid 
FROM rf2_descriptions_snapshot AS D
INNER JOIN rf2_language_refset_snapshot AS ADRS 
ON D.id = ADRS.referencedcomponentid
WHERE D.conceptId = 387517004
AND ADRS.acceptabilityid = 900000000000548007 -- ConceptId for 'Preferred'
AND ADRS.active = 1;


-- 6. Restrict the search for term ulcer to Clinical findings reference set
SELECT term 
FROM rf2_descriptions_snapshot 
WHERE term LIKE 'ulcer'
AND conceptId IN 
		(SELECT referencedcomponentId 
		FROM rf2_refset_snapshot 
		WHERE refsetId = 32570071000036102 -- Clinical finding foundation reference set
);


-- 7. List Animal bite wound concepts, excluding the Arthropod bite wounds.
SELECT sourceId 
FROM rf2_transitive_closure
WHERE destinationId = 399907009 -- Animal bite wound
-- exclude the concepts that are 409985002|Arthropod bite wound| descendants
AND sourceId NOT IN (SELECT sourceId FROM rf2_transitive_closure
		    WHERE destinationId = 409985002 -- Arthropod bite wound
		    );


-- 8. Intersection of Congenital diseases and Anaemias 
SELECT anaemia.sourceId 
FROM rf2_transitive_closure AS anaemia
INNER JOIN rf2_transitive_closure AS congenital
ON anaemia.sourceId = congenital.sourceId
WHERE anaemia.destinationId = 271737000 -- | anaemia | 
AND congenital.destinationId = 66091009; -- | congenital disease |


-- 9. Alternative query to list intersection of Congenital diseases and Anaemias 
SELECT sourceId FROM rf2_transitive_closure AS anaemia
WHERE anaemia.destinationId = 271737000 -- | anaemia | 
AND sourceId IN (
		SELECT sourceId FROM rf2_transitive_closure AS congenital
		WHERE congenital.destinationId = 66091009 -- | congenital disease |
			);





