﻿/*
 * Copyright 2013 NEHTA
 *
 * Licensed under the NEHTA Open Source (Apache) License; you may not use this
 * file except in compliance with the License. A copy of the License is in the
 * 'license.txt' file, which should be provided with this work.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

using Nehta.VendorLibrary.CDA.Common;

namespace CDA.Generator.Common.Common.Time.Enum
{
        /// <summary>
        /// OperationTypes
        /// </summary>
    public enum OperationTypes
        {
            /// <summary>
            /// Form the union with the value.
            /// </summary>
            [Name(Code = "I", Name = "include")]
            Include,

            /// <summary>
            /// Form the set-difference.
            /// </summary>
            [Name(Code = "E", Name = "exclude")]
            Exclude,

            /// <summary>
            /// Form the intersection with the value.
            /// </summary>
            [Name(Code = "A", Name = "intersect")]
            Intersect,

            /// <summary>
            /// Form the convex hull with the value. The convex hull is
            /// defined over ordered domains and is the smallest
            /// contiguous superset (interval) that of all the operand sets.
            /// </summary>
            [Name(Code = "H", Name = "convexhull")]
            ConvexHull,

            /// <summary>
            /// Form the periodic hull with the value. The periodic hull is
            /// defined over ordered domains and is the periodic set that
            /// contains all contiguous supersets of pairs of intervals
            /// generated by the operand periodic intervals.
            /// </summary>
            [Name(Code = "P", Name = "periodichull")]
            PeriodicHull
        }
}
