﻿/*
 * Copyright 2013 NEHTA
 *
 * Licensed under the NEHTA Open Source (Apache) License; you may not use this
 * file except in compliance with the License. A copy of the License is in the
 * 'license.txt' file, which should be provided with this work.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

using System.Collections.Generic;
using System.Runtime.Serialization;
using JetBrains.Annotations;
using Nehta.VendorLibrary.CDA.SCSModel.Common;
using Nehta.VendorLibrary.Common;
using Nehta.VendorLibrary.CDA.Common.Enums;

namespace Nehta.VendorLibrary.CDA.SCSModel
{
    /// <summary>
    /// The IParticipationServiceRequester who has the overall responsibility for the care given to the patient 
    /// </summary>
     public interface IParticipationServiceRequester
    {
        /// <summary>
        /// The time interval during which the participation in 0..1 performer/time the health care event occurred.
        /// </summary>
        [CanBeNull]
        [DataMember]
        CdaInterval ParticipationPeriod { get; set; }

        /// <summary>
        /// The involvement or role of the participant in the related action from a healthcare 
        /// perspective rather than the specific participation perspective.
        /// </summary>
        [CanBeNull]
        ICodableText Role { get; set; }

        /// <summary>
        /// The involvement or role of the participant in the related action from a healthcare perspective rather than the specific participation perspective.
        /// </summary>
        [CanBeNull]
        RoleClassCodeAssociative? RoleClassCodeCode { get; set; }

        /// <summary>
        /// The Participant
        /// </summary>
        [CanBeNull]
        [DataMember]
        IServiceRequester Participant { get; set; }

        /// <summary>
        /// Validates this Participation Service Requester
        /// </summary>
        /// <param name="path">The path to this object as a string</param>
        /// <param name="messages">the validation messages, these may be added to within this method</param>
        void Validate(string path, List<ValidationMessage> messages);
    }
}
