-- Search for all MPPs and TPPs based on MPs, MPPs and TPPs containing a word starting with 'amox'
select
	v3_mpp_to_tpp.mppid,
	v3_mpp_to_tpp.mppterm,
	v3_mpp_to_tpp.tppid,
	v3_mpp_to_tpp.tppterm
from v3_mpp_to_tpp
    join v3_ingredient_strength
		on v3_mpp_to_tpp.mppid = v3_ingredient_strength.mppid
where v3_ingredient_strength.substanceterm regexp (

		@search_term:='(^|[^a-zA-Z]+)amox' collate utf8_unicode_ci

	)
	or v3_mpp_to_tpp.mppterm regexp @search_term
	or v3_mpp_to_tpp.tppterm regexp @search_term

group by v3_mpp_to_tpp.tppid, v3_mpp_to_tpp.mppid
;

-- Show dose forms of 4 sample MPPs
select
    v3_ingredient_strength.mppid,
    v3_ingredient_strength.mppterm,
    v3_ingredient_strength.bossterm,
    toPt(hasDoseForm.destinationid)
from v3_ingredient_strength

    join rf2_ss_relationships hasDoseForm
        on hasDoseForm.sourceid = v3_ingredient_strength.mpuuid
        and hasDoseForm.typeid = (
            select conceptid from rf2_ss_descriptions
            where term = 'has manufactured dose form (relationship type)')
        and hasDoseForm.active = 1

where v3_ingredient_strength.mppid in (
	26624011000036107, -- 'amoxycillin 100 mg/mL oral...'
	51572011000036101, -- 'goserelin 3.6 mg implant [...'
	26781011000036107, -- 'peginterferon alfa-2a 135 ...'
	28051011000036109  -- 'peginterferon alfa-2b 150 ...'
)
;

-- List ingredient strengths for a given MPP
select *
from v3_ingredient_strength
where mppid = 26624011000036107
;

-- List unit of use size and quantity for a given MPP
select *
from v3_unit_of_use
where mppid = 26624011000036107
;

-- List acceptable TPPs (for dispensing) for a given MPP
select tppid, tppterm
from v3_mpp_to_tpp
where mppid = 26563011000036109
;

-- List acceptable substitutable TPPs (for dispensing) for a given TPP
select
    mppToTpp.tppid as tppid,
    mppToTpp.tppterm as tppterm,
    hasTpp.sourceid as ctppid,
    toPt(hasTpp.sourceid) as ctppterm
from v3_mpp_to_tpp mppToTpp

    join (
        select mppid
        from v3_mpp_to_tpp
        where tppid = 12809011000036105
        and tppterm = 'Amoxil 250 mg capsule: hard, 20 capsules'
    ) as t on t.mppid = mppToTpp.mppid

    join rf2_ss_relationships hasTpp
        on hasTpp.destinationid = mppToTpp.tppid
        and hasTpp.typeid = (
            select conceptid from rf2_ss_descriptions
            where term = 'has TPP (relationship type)')
        and hasTpp.active = 1
;

-- Find all MPUUs containing more than 10 milligrams of codeine, in tablet form
select
    v3_ingredient_strength.mpuuid,
    v3_ingredient_strength.mpuuterm,
    v3_ingredient_strength.bossterm,
    v3_ingredient_strength.substanceterm,
    v3_ingredient_strength.strengthvalue,
    v3_ingredient_strength.unitterm,
    toPt(hasDoseForm.destinationid)
from v3_ingredient_strength

    join rf2_ss_relationships hasDoseForm
        on hasDoseForm.sourceid = v3_ingredient_strength.mpuuid
        and hasDoseForm.typeid = (
            select conceptid from rf2_ss_descriptions
            where term = 'has manufactured dose form (relationship type)')
        and hasDoseForm.active = 1

where v3_ingredient_strength.strengthvalue > 10
                and v3_ingredient_strength.unitid = (
                                select distinct conceptid from rf2_ss_descriptions where term = 'mg/each'
                )
                and v3_ingredient_strength.substanceid = (
                                select distinct conceptid from rf2_ss_descriptions where term = 'codeine (AU substance)'
                )
                and hasDoseForm.destinationid = (
                                select distinct conceptid from rf2_ss_descriptions where term = 'tablet dose form (AU qualifier)'
                )

group by v3_ingredient_strength.mpuuid
;

-- Find all MPUUs containing dihydrocodeine, in tablet (OR SUBTYPE OF TABLET) form
select
    v3_ingredient_strength.mpuuid,
    v3_ingredient_strength.mpuuterm,
    v3_ingredient_strength.bossterm,
    v3_ingredient_strength.substanceterm,
    v3_ingredient_strength.strengthvalue,
    v3_ingredient_strength.unitterm,
    toPt(hasDoseForm.destinationid)
from v3_ingredient_strength

    join rf2_ss_relationships hasDoseForm
       on hasDoseForm.sourceid = v3_ingredient_strength.mpuuid
        and hasDoseForm.typeid = (
            select conceptid from rf2_ss_descriptions
            where term = 'has manufactured dose form (relationship type)')
        and hasDoseForm.active = 1

where v3_ingredient_strength.substanceid = (
                                select distinct conceptid from rf2_ss_descriptions where term = 'dihydrocodeine (AU substance)'
                )
                and (
                                hasDoseForm.destinationid = (
                                                select distinct conceptid from rf2_ss_descriptions where term = 'tablet dose form (AU qualifier)'
                                )
                                or hasDoseForm.destinationid in (
                                                select source from v3_tc where dest = (
                                                                select distinct conceptid from rf2_ss_descriptions where term = 'tablet dose form (AU qualifier)'
                                                )
                                )
                )

group by v3_ingredient_strength.mpuuid
;

-- Query subroles for 'has MPUU' relationship to 'paracetamol 500 mg'
select
	hasMpuu.sourceid as mppid,
	toPt(hasMpuu.sourceid) as mppterm,
	hasMpuu.typeid as hasmpuu_typeid,
	toPt(hasMpuu.typeid) as hasmpuu_typeterm,
	hasMpuu.destinationid as mpuuid,
	toPt(hasMpuu.destinationid) as mpuuterm,
	subRole.sourceid as sub_sourceid,
	toPt(subRole.sourceid) as sub_sourceterm,
	subRole.typeid as sub_typeid,
	toPt(subRole.typeid) as sub_typeterm,
	subRole.destinationid as sub_destinationid,
	toPt(subRole.destinationid) as sub_destinationterm
from v3_mpp as mpp

	join rf2_ss_relationships hasMpuu
		on hasMpuu.sourceid = mpp.id
		and hasMpuu.active = 1
		and hasMpuu.typeid = (
			select distinct conceptid from rf2_ss_descriptions where term = 'has MPUU'
		)
		and hasMpuu.destinationid = (
			select distinct conceptid from rf2_ss_descriptions where term = 'paracetamol 500 mg tablet'
		)

	join rf2_ss_relationships subRole
		on subRole.active = 1
		and exists (
			select 1
			from v3_tc
			where dest = hasMpuu.destinationid
				and source = subRole.destinationid
		)
		and exists (
			select 1
			from v3_tc
			where dest = hasMpuu.sourceid
				and source = subRole.sourceid
		)
;

