-- ------------------------------------------------------------------------------
-- IMPORT FILES
-- ------------------------------------------------------------------------------
-- RF2_FULL_CONCEPTS
TRUNCATE TABLE rf2_full_concepts
;
-- NOTE: WE ARE LOADING THE SNAPSHOT FILES INTO THE FULL TABLES FOR BETA SO WE DO NOT NEED TO CHANGE OUR QUERIES FOR PRODUCTION (WHICH WILL HAVE THE FULL FILES)
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Terminology/sct2_Concept_Snapshot_AU1000036_20121231.txt' INTO TABLE rf2_full_concepts CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, definitionstatusid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;

-- RF2_FULL_DESCRIPTIONS
TRUNCATE TABLE rf2_full_descriptions
;
-- NOTE: WE ARE LOADING THE SNAPSHOT FILES INTO THE FULL TABLES FOR BETA SO WE DO NOT NEED TO CHANGE OUR QUERIES FOR PRODUCTION (WHICH WILL HAVE THE FULL FILES)
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Terminology/sct2_Description_Snapshot-en-AU_AU1000036_20121231.txt' INTO TABLE rf2_full_descriptions CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, conceptid, languagecode, typeid, term, casesignificanceid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;

-- RF2_FULL_RELATIONSHIPS
TRUNCATE TABLE rf2_full_relationships
;
-- NOTE: WE ARE LOADING THE SNAPSHOT FILES INTO THE FULL TABLES FOR BETA SO WE DO NOT NEED TO CHANGE OUR QUERIES FOR PRODUCTION (WHICH WILL HAVE THE FULL FILES)
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Terminology/sct2_Relationship_Snapshot_AU1000036_20121231.txt' INTO TABLE rf2_full_relationships CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, sourceid, destinationid, relationshipgroup, typeid, characteristictypeid, modifierid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;

-- RF2_FULL_LANGUAGE
TRUNCATE TABLE rf2_full_language_refset
;
-- NOTE: WE ARE LOADING THE SNAPSHOT FILES INTO THE FULL TABLES FOR BETA SO WE DO NOT NEED TO CHANGE OUR QUERIES FOR PRODUCTION (WHICH WILL HAVE THE FULL FILES)
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Language/der2_cRefset_LanguageSnapshot-en-AU_AU1000036_20121231.txt' INTO TABLE rf2_full_language_refset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid, valueid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;

-- RF2_SS_CREFSET
TRUNCATE TABLE rf2_ss_cRefset
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_cRefset_ContaineredTradeProductPackSnapshot_AU1000036_20121231.txt' INTO TABLE rf2_ss_cRefset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid, valueid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_cRefset_MedicinalProductSnapshot_AU1000036_20121231.txt' INTO TABLE rf2_ss_cRefset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid, valueid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_cRefset_MedicinalProductPackSnapshot_AU1000036_20121231.txt' INTO TABLE rf2_ss_cRefset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid, valueid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_cRefset_MedicinalProductUnitOfUseSnapshot_AU1000036_20121231.txt' INTO TABLE rf2_ss_cRefset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid, valueid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_cRefset_TradeProductSnapshot_AU1000036_20121231.txt' INTO TABLE rf2_ss_cRefset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid, valueid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_cRefset_TradeProductPackSnapshot_AU1000036_20121231.txt' INTO TABLE rf2_ss_cRefset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid, valueid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_cRefset_TradeProductUnitOfUseSnapshot_AU1000036_20121231.txt' INTO TABLE rf2_ss_cRefset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid, valueid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Language/der2_cRefset_LanguageSnapshot-en-AU_AU1000036_20121231.txt' INTO TABLE rf2_ss_cRefset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid, valueid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;

-- RF2 CONCRETE DOMAIN REFSETS
TRUNCATE TABLE rf2_ss_strength_refset
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_ccsRefset_StrengthSnapshot_AU1000036_20121231.txt' INTO TABLE rf2_ss_strength_refset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid, unitid, operatorid, value)
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;
TRUNCATE TABLE rf2_ss_unit_of_use_size_refset
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_ccsRefset_UnitOfUseSizeSnapshot_AU1000036_20121231.txt' INTO TABLE rf2_ss_unit_of_use_size_refset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid, unitid, operatorid, value)
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;
TRUNCATE TABLE rf2_ss_unit_of_use_quantity_refset
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_ccsRefset_UnitOfUseQuantitySnapshot_AU1000036_20121231.txt' INTO TABLE rf2_ss_unit_of_use_quantity_refset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid, unitid, operatorid, value)
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;
