-- --------------------------------------------------------------------------------
-- POPULATE THE PRE-COORDINATED TABLES
-- --------------------------------------------------------------------------------
TRUNCATE TABLE v3_ingredient_strength
;
INSERT INTO v3_ingredient_strength
select 
    mpp.id as mppid,
    toPt(mpp.id) as mppterm,
    hasMpuu.destinationid as mpuuid,
    toPt(hasMpuu.destinationid) as mpuuterm,
	hasIngredient.destinationid as substanceid,
    toPt(hasIngredient.destinationid) as substanceterm,
    hasAuBoss.destinationid as bossid,
    toPt(hasAuBoss.destinationid) as bossterm,
    strength.operatorid as operatorid,
    toPt(strength.operatorid) as operatorterm,
    strength.value as strengthvalue,
    strength.unitid as unitid,
    toPt(strength.unitid) as unitterm
from v3_mpp mpp

    join rf2_ss_relationships hasMpuu
        on hasMpuu.sourceid = mpp.id
        and hasMpuu.typeid = (
            select conceptid from rf2_ss_descriptions
            where term = 'has mpuu (relationship type)'
            and active = 1)
        and hasMpuu.active = 1

    join rf2_ss_relationships hasIngredient
        on hasIngredient.sourceid = hasMpuu.destinationid
        and hasIngredient.typeid = (
            select conceptid from rf2_ss_descriptions
            where term = 'has intended active ingredient (attribute)'
            and active = 1)
        and hasIngredient.active = 1

    join rf2_ss_relationships hasAuBoss
        on hasAuBoss.sourceid = hasMpuu.destinationid
        and hasAuBoss.typeid = (
            select conceptid from rf2_ss_descriptions
            where term = 'has australian boss (relationship type)'
            and active = 1)
        and hasAuBoss.relationshipgroup = hasIngredient.relationshipgroup
        and hasAuBoss.active = 1

    left outer join rf2_ss_strength_refset strength
        on strength.referencedcomponentid = hasAuBoss.id
        and strength.active = 1    
;

TRUNCATE TABLE v3_unit_of_use
;
INSERT INTO v3_unit_of_use
select
    mpp.id as mppid,
    toPt(mpp.id) as mppterm,
    mpuu.id as mpuuid,
    toPt(mpuu.id) as mpuuterm,
    uouSize.operatorid as sizeoperatorid,
    toPt(uouSize.operatorid) as sizeoperatorterm,
    uouSize.value as sizevalue,
    uouSize.unitid as sizeunitid,
    toPt(uouSize.unitid) as sizeunitterm,
    uouQty.operatorid as quantityoperatorid,
    toPt(uouQty.operatorid) as quantityoperatorterm,
    uouQty.value as quantityvalue,
    uouQty.unitid as quantityunitid,
    toPt(uouQty.unitid) as quantityunitterm
from v3_mpp mpp

    join rf2_ss_relationships hasMpuu
        on hasMpuu.sourceid = mpp.id
        and hasMpuu.typeid = (
            select conceptid from rf2_ss_descriptions
            where term = 'has mpuu (relationship type)'
            and active = 1)
        and hasMpuu.active = 1

    join v3_mpuu mpuu
        on mpuu.id = hasMpuu.destinationid

    join rf2_ss_relationships hasUnitOfUse
        on hasUnitOfUse.sourceid = mpuu.id
        and hasUnitOfUse.typeid = (
            select conceptid from rf2_ss_descriptions
            where term = 'has unit of use (relationship type)'
            and active = 1)
        and hasUnitOfUse.active = 1

    join rf2_ss_unit_of_use_quantity_refset uouQty
        on uouQty.referencedcomponentid = hasMpuu.id
        and uouQty.active = 1

    left outer join rf2_ss_unit_of_use_size_refset uouSize
        on uouSize.referencedcomponentid = hasUnitOfUse.id
        and uouSize.active = 1
;

TRUNCATE TABLE v3_mpp_to_tpp
;
INSERT INTO v3_mpp_to_tpp
select
    mpp.id as mppid,
    toPt(mpp.id) as mppterm,
    tpp.id as tppid,
    toPt(tpp.id) as tppterm
from v3_tpp tpp

    join rf2_ss_relationships hasTpp
        on hasTpp.sourceid in (
            select id from v3_ctpp)
        and hasTpp.typeid = (
            select conceptid from rf2_ss_descriptions
            where term = 'has tpp (relationship type)'
            and active = 1)
        and hasTpp.destinationid = tpp.id
        and hasTpp.active = 1

    join rf2_ss_relationships isaMpp
        on isaMpp.sourceid = hasTpp.sourceid
        and isaMpp.typeid = (
            select conceptid from rf2_ss_descriptions
            where term = 'is a (attribute)'
            and active = 1)
        and isaMpp.destinationid in (
            select id from v3_mpp)
        and isaMpp.active = 1

    join v3_mpp mpp
        on mpp.id = isaMpp.destinationid

	group by mpp.id, tpp.id
;

TRUNCATE TABLE v3_total_ingredient_quantity
;
INSERT INTO v3_total_ingredient_quantity
SELECT 
    mpuu.id as mpuuid, 
    toPt(mpuu.id) as mpuuterm, 
    hasAuBoss.destinationid as bossid,
    toPt(hasAuBoss.destinationid) as bossterm,
    strength.value as strengthvalue,
    strength.unitid as strenthunitid,
    toPt(strength.unitid) as strengthunitterm,
    hasActiveIngredient.destinationid as activeingredientid,
    toPt(hasActiveIngredient.destinationid) as activeingredientterm,
    uouSize.value as sizevalue,
    uouSize.unitid as sizeunitid,
    toPt(uouSize.unitid) as sizeunitterm,
    round(strength.value * uouSize.value, 6) as totalquantity,
    hasNumeratorUnits.destinationid as totalquantityunitid,
    toPt(hasNumeratorUnits.destinationid) as totalquantityunitterm

from v3_mpuu mpuu

    join rf2_ss_relationships hasUnitOfUse
        on hasUnitOfUse.sourceid = mpuu.id
        and hasUnitOfUse.typeid = (
            select conceptid from rf2_ss_descriptions
            where term = 'has unit of use (relationship type)')
        and hasUnitOfUse.active = 1

    join rf2_ss_unit_of_use_size_refset uouSize
        on uouSize.referencedcomponentid = hasUnitOfUse.id
        and uouSize.active = 1

    join rf2_ss_relationships hasAuBoss
        on hasAuBoss.sourceid = mpuu.id
        and hasAuBoss.typeid in (
            select conceptid from rf2_ss_descriptions
            where term = 'has australian boss (relationship type)')
        and hasAuBoss.active = 1

    join rf2_ss_strength_refset strength
        on strength.referencedcomponentid = hasAuBoss.id
        and strength.active = 1
        
    join rf2_ss_relationships hasActiveIngredient
        on hasActiveIngredient.sourceid = mpuu.id
        and hasActiveIngredient.typeid in (
            select conceptid from rf2_ss_descriptions
            where term = 'has intended active ingredient (attribute)')
        and hasActiveIngredient.relationshipgroup = hasAuBoss.relationshipgroup
        and hasActiveIngredient.active = 1


    join rf2_ss_relationships hasNumeratorUnits
        on hasNumeratorUnits.sourceid = strength.unitid
        and hasNumeratorUnits.typeid = (
            select conceptid from rf2_ss_descriptions
            where term = 'has numerator units (attribute)')
        and hasNumeratorUnits.active = 1

    join rf2_ss_relationships hasDenominatorUnits
        on hasDenominatorUnits.sourceid = strength.unitid
        and hasDenominatorUnits.typeid = (
            select conceptid from rf2_ss_descriptions
            where term = 'has denominator units (attribute)')
        and hasDenominatorUnits.active = 1
;
