-- ------------------------------------------------------------------------------
-- IMPORT FILES
-- ------------------------------------------------------------------------------
-- RF2_FULL_CONCEPTS
TRUNCATE TABLE rf2_full_concepts
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Full/Terminology/sct2_Concept_Full_AU1000168_20140630.txt' INTO TABLE rf2_full_concepts CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, definitionstatusid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;

-- RF2_FULL_DESCRIPTIONS
TRUNCATE TABLE rf2_full_descriptions
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Full/Terminology/sct2_Description_Full-en-AU_AU1000168_20140630.txt' INTO TABLE rf2_full_descriptions CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, conceptid, languagecode, typeid, term, casesignificanceid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;

-- RF2_FULL_RELATIONSHIPS
TRUNCATE TABLE rf2_full_relationships
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Full/Terminology/sct2_Relationship_Full_AU1000168_20140630.txt' INTO TABLE rf2_full_relationships CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, sourceid, destinationid, relationshipgroup, typeid, characteristictypeid, modifierid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;

-- RF2_FULL_LANGUAGE
TRUNCATE TABLE rf2_full_language_refset
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Full/Refset/Language/der2_cRefset_LanguageFull-en-AU_AU1000168_20140630.txt' INTO TABLE rf2_full_language_refset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid, valueid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;

-- RF2_SS_REFSET
TRUNCATE TABLE rf2_ss_refset
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_Refset_ContaineredTradeProductPackSnapshot_AU1000168_20140630.txt' INTO TABLE rf2_ss_refset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_Refset_MedicinalProductSnapshot_AU1000168_20140630.txt' INTO TABLE rf2_ss_refset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_Refset_MedicinalProductPackSnapshot_AU1000168_20140630.txt' INTO TABLE rf2_ss_refset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_Refset_MedicinalProductUnitOfUseSnapshot_AU1000168_20140630.txt' INTO TABLE rf2_ss_refset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_Refset_TradeProductSnapshot_AU1000168_20140630.txt' INTO TABLE rf2_ss_refset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_Refset_TradeProductPackSnapshot_AU1000168_20140630.txt' INTO TABLE rf2_ss_refset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_Refset_TradeProductUnitOfUseSnapshot_AU1000168_20140630.txt' INTO TABLE rf2_ss_refset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;

-- RF2 CONCRETE DOMAIN REFSETS
TRUNCATE TABLE rf2_ss_strength_refset
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_ccsRefset_StrengthSnapshot_AU1000168_20140630.txt' INTO TABLE rf2_ss_strength_refset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid, unitid, operatorid, value)
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;
TRUNCATE TABLE rf2_ss_unit_of_use_size_refset
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_ccsRefset_UnitOfUseSizeSnapshot_AU1000168_20140630.txt' INTO TABLE rf2_ss_unit_of_use_size_refset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid, unitid, operatorid, value)
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;
TRUNCATE TABLE rf2_ss_unit_of_use_quantity_refset
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_ccsRefset_UnitOfUseQuantitySnapshot_AU1000168_20140630.txt' INTO TABLE rf2_ss_unit_of_use_quantity_refset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid, unitid, operatorid, value)
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;
TRUNCATE TABLE rf2_ss_subpack_quantity_refset
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_cciRefset_SubpackQuantitySnapshot_AU1000168_20140630.txt' INTO TABLE rf2_ss_subpack_quantity_refset CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid, unitid, operatorid, value)
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;