/*
 * Copyright 2012 NEHTA
 *
 * Licensed under the NEHTA Open Source (Apache) License; you may not use this
 * file except in compliance with the License. A copy of the License is in the
 * 'license.txt' file, which should be provided with this work.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package au.gov.nehta.vendorlibrary.pcehr.sample.common.constants;

/**
 * Sample endpoints used in sample code. These should be replaced with the appropriate,
 * PCEHR endpoints.
 */
public final class SampleEndpoints {

  /**
   * Sample Does PCEHR Exist service endpoint.
   */
  public static final String DOES_PCEHR_EXIST = "https://exampleendpoint.com/doesPCEHRExist";

  /**
   * Sample Gain PCEHR Access service endpoint.
   */
  public static final String GAIN_PCEHR_ACCESS = "https://exampleendpoint.com/gainPCEHRAccess";

  /**
   * Sample Get Document List service endpoint.
   */
  public static final String GET_DOCUMENT_LIST = "https://exampleendpoint.com/getDocumentList";

  /**
   * Sample Remove Document service endpoint.
   */
  public static final String REMOVE_DOCUMENT = "https://exampleendpoint.com/removeDocument";

  /**
   * Sample Upload Document service endpoint.
   */
  public static final String UPLOAD_DOCUMENT = "https://exampleendpoint.com/uploadDocument";

  /**
   * Sample Get Document service endpoint.
   */
  public static final String GET_DOCUMENT = "https://exampleendpoint.com/getDocument";

  /**
   * Sample Get Change History View service endpoint.
   */
  public static final String GET_CHANGE_HISTORY_VIEW = "https://exampleendpoint.com/getChangeHistoryView";

  /**
   * Sample Get Audit View service endpoint.
   */
  public static final String GET_AUDIT_VIEW = "https://exampleendpoint.com/getAuditView";

  /**
   * Sample Get Consolidated View service endpoint.
   */
  public static final String GET_CONSOLIDATED_VIEW = "https://exampleendpoint.com/getConsolidatedView";

  /**
   * Sample Search Template service endpoint.
   */
  public static final String SEARCH_TEMPLATE = "https://exampleendpoint.com/searchTemplate";

  /**
   * Sample Get Template service endpoint.
   */
  public static final String GET_TEMPLATE = "https://exampleendpoint.com/getTemplate";

  /**
   * Sample Upload Document Metadata service endpoint.
   */
  public static final String UPLOAD_DOCUMENT_METADATA = "https://exampleendpoint.com/uploadDocumentMetadata";

  /**
   * Sample Get Representative List service endpoint.
   */
  public static final String GET_REPRESENTATIVE_LIST = "https://exampleendpoint.com/getRepresentativeList";

  /**
   * Sample Register PCEHR service endpoint.
   */
  public static final String REGISTER_PCEHR = "https://exampleendpoint.com/registerPCEHR";

  /**
   * Private constructor to prevent instantiation.
   */
  private SampleEndpoints() {
  }
}
