﻿/*
 * Copyright 2013 NEHTA
 *
 * Licensed under the NEHTA Open Source (Apache) License; you may not use this
 * file except in compliance with the License. A copy of the License is in the
 * 'license.txt' file, which should be provided with this work.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nehta.VendorLibrary.CDA.Common;

namespace CDA.Generator.Common.Common.Time.Enum
{
        /// <summary>
        /// OperationTypes
        /// </summary>
    public enum EventCodes
        {
            /// <summary>
            /// before meal (from lat. ante cibus)
            /// </summary>
            [Name(Code = "AC", Name = "before meal")]
            BeforeMeal,

            /// <summary>
            /// before breakfast (from lat. ante cibus matutinus)
            /// </summary>
            [Name(Code = "ACM", Name = "before breakfast")]
            BeforeBreakfast,

            /// <summary>
            /// before lunch (from lat. ante cibus diurnus)
            /// </summary>
            [Name(Code = "ACD", Name = "before lunch")]
            BeforeLunch,

            /// <summary>
            /// at the hour of sleep.
            /// </summary>
            [Name(Code = "HS", Name = "hour of sleep")]
            HourOfSleep,

            /// <summary>
            /// between meals (from lat. inter cibus)
            /// </summary>
            [Name(Code = "IC", Name = "between meals")]
            BetweenMeals,

            /// <summary>
            /// between breakfast and lunch
            /// </summary>
            [Name(Code = "ICM", Name = "between breakfast and lunch")]
            BetweenBreakfastAndLunch,

            /// <summary>
            /// between lunch and dinner
            /// </summary>
            [Name(Code = "ICD", Name = "between lunch and dinner")]
            BetweenLunchAndAinner,

            /// <summary>
            /// between dinner and the hour of sleep
            /// </summary>
            [Name(Code = "ICD", Name = "between dinner and the hour of sleep")]
            BetweenDinnerAndTheHourOfSleep,

            /// <summary>
            /// after meal (from lat. post cibus)
            /// </summary>
            [Name(Code = "PC", Name = "after meals")]
            AfterMeals,

            /// <summary>
            /// after breakfast (from lat. post cibus matutinus)
            /// </summary>
            [Name(Code = "PCM", Name = "after breakfast")]
            AfterBreakfast,

            /// <summary>
            /// after lunch (from lat. post cibus diurnus)
            /// </summary>
            [Name(Code = "PCM", Name = "after lunch")]
            AfterLunch,

            /// <summary>
            /// after dinner (from lat. post cibus vespertinus)
            /// </summary>
            [Name(Code = "PCV", Name = "after dinner")]
            AfterDinner,
        }
}
