-- --------------------------------------------------------------------------------
-- POPULATE THE PRE-COORDINATED TABLES
-- --------------------------------------------------------------------------------
TRUNCATE TABLE v3_ingredient_strength
;
INSERT INTO v3_ingredient_strength
select 
    MPPhasMPUU.sourceId as mppid,
    toPt(MPPhasMPUU.sourceId) as mppterm,
    MPPhasMPUU.destinationid as mpuuid,
    toPt(MPPhasMPUU.destinationid) as mpuuterm,
    hasIngredient.destinationid as substanceid,
    toPt(hasIngredient.destinationid) as substanceterm,
    hasBoSS.destinationid as bossid,
    toPt(hasBoSS.destinationid) as bossterm,
    strength.operatorid as operatorid,
    toPt(strength.operatorid) as operatorterm,
    strength.value as strengthvalue,
    strength.unitid as unitid,
    toPt(strength.unitid) as unitterm
from rf2_ss_relationships MPPhasMPUU

    join rf2_ss_relationships hasIngredient
        on MPPhasMPUU.destinationId = hasIngredient.sourceId
        and MPPhasMPUU.sourceId in (select id from v3_mpp)
        and MPPhasMPUU.destinationId in (select id from v3_mpuu)
        and MPPhasMPUU.typeId = 30348011000036104 -- has MPUU (relationship type)
        and MPPhasMPUU.active = 1
        and hasIngredient.typeId = 700000081000036101 -- has intended active ingredient (attribute)
        and hasIngredient.active = 1

    join rf2_ss_relationships hasBoSS
        on hasIngredient.sourceId = hasBoSS.sourceId and hasIngredient.relationshipgroup = hasBoSS.relationshipgroup
        and hasBoSS.typeId = 30364011000036101 -- has Australian BoSS (relationship type)
        and hasBoSS.active = 1

    left outer join rf2_ss_strength_refset strength
        on hasBoSS.id = strength.referencedcomponentid
        and strength.active = 1
;

TRUNCATE TABLE v3_unit_of_use
;
INSERT INTO v3_unit_of_use
select 
    MPPhasMPUU.sourceId as mppid,
    toPt(MPPhasMPUU.sourceId) as mppterm,
    MPPhasMPUU.destinationId as mpuuid,
    toPt(MPPhasMPUU.destinationId) as mpuuterm,
    
    hasUnitOfUse.destinationId as unitofuseid,
    toPt(hasUnitOfUse.destinationId) as unitofuseterm,

    uouSize.operatorid as sizeoperatorid,
    toPt(uouSize.operatorid) as sizeoperatorterm,
    uouSize.value as sizevalue,
    uouSize.unitid as sizeunitid,
    toPt(uouSize.unitid) as sizeunitterm,

    uouQty.operatorid as quantityoperatorid,
    toPt(uouQty.operatorid) as quantityoperatorterm,
    uouQty.value as quantityvalue,
    uouQty.unitid as quantityunitid,
    toPt(uouQty.unitid) as quantityunitterm
from rf2_ss_relationships MPPhasMPUU

    left outer join rf2_ss_relationships hasUnitOfUse
        on MPPhasMPUU.destinationId = hasUnitOfUse.sourceId
        and MPPhasMPUU.sourceId in (select id from v3_mpp)
        and MPPhasMPUU.destinationId in (select id from v3_mpuu)
        and hasUnitOfUse.typeId = 30548011000036101 -- has unit of use (relationship type)
        and hasUnitOfUse.active = 1

    join rf2_ss_unit_of_use_size_refset uouSize
        on hasUnitOfUse.id = uouSize.referencedcomponentid
        and uouSize.active = 1

    join rf2_ss_unit_of_use_quantity_refset uouQty
        on MPPhasMPUU.id = uouQty.referencedcomponentid
        and uouQty.active = 1
;


TRUNCATE TABLE v3_mpp_to_tpp
;
INSERT INTO v3_mpp_to_tpp
select 
    destinationId as mppid,
    toPt(destinationId) as mppterm,
    sourceId as tppid,
    toPt(sourceId) as tppterm
from rf2_ss_relationships TPPisMPP
        where TPPisMPP.sourceId in (select id from v3_tpp)
        and TPPisMPP.destinationId in (select id from v3_mpp)
        and TPPisMPP.typeId = 116680003 -- Is a
        and TPPisMPP.active = 1
;

TRUNCATE TABLE v3_total_ingredient_quantity
;
INSERT INTO v3_total_ingredient_quantity
select 
    strength.mpuuid as mpuuid, 
    strength.mpuuterm as mpuuterm, 
    strength.bossid as bossid,
    strength.bossterm as bossterm,
    strength.strengthvalue as strengthvalue,
    strength.unitid as strengthunitid,
    unitterm as strengthunitterm,
    substanceid as activeingredientid,
    substanceterm as activeingredientterm,
    sizevalue as sizevalue,
    sizeunitid as sizeunitid,
    sizeunitterm as sizeunitterm,
    round(strength.strengthvalue * sizevalue, 6) as totalquantity,
    hasNumeratorUnits.destinationid as totalquantityunitid,
    toPt(hasNumeratorUnits.destinationid) as totalquantityunitterm
from v3_ingredient_strength strength
    join v3_unit_of_use uousize
        on strength.mpuuid = uousize.mpuuid

    join rf2_ss_relationships hasNumeratorUnits
        on strength.unitid = sourceId
        and typeid = 700000091000036104
        and active = 1
;
