-- --------------------------------------------------------------------------------
-- CREATE ROUTINES
-- --------------------------------------------------------------------------------
DELIMITER //

DROP PROCEDURE IF EXISTS createTc //
CREATE PROCEDURE createTc()
BEGIN
    drop table if exists v3_tc;

    CREATE TABLE v3_tc (
        source BIGINT NOT NULL ,
        dest BIGINT NOT NULL ,
        PRIMARY KEY (source, dest) )
    ENGINE = MyISAM;

    insert into v3_tc (source, dest)
        select distinct rel.sourceid, rel.destinationid
        from rf2_ss_relationships rel inner join rf2_ss_concepts con
			on rel.sourceid = con.id and con.active = 1
		where rel.typeid = (select distinct conceptid from rf2_ss_descriptions where term = 'is a')
        and rel.active = 1;

    REPEAT

        insert into v3_tc (source, dest)
            select distinct b.source, a.dest
            from v3_tc a
            join v3_tc b on a.source = b.dest
            left join v3_tc c on c.source = b.source and c.dest = a.dest
            where c.source is null;

        set @x = row_count();

        select concat('Inserted ', @x);

    UNTIL @x = 0 END REPEAT;
    create index idx_v3_tc_source on v3_tc (source);
    create index idx_v3_tc_dest on v3_tc (dest);
END //

DROP FUNCTION IF EXISTS toFsn //
CREATE FUNCTION toFsn(in_conceptid BIGINT) RETURNS varchar(2048)
BEGIN
        DECLARE result varchar(2048);

        select fsn.term into result
        from rf2_ss_descriptions fsn
        where fsn.typeid = (
            select conceptid from rf2_ss_descriptions
            where term = 'fully specified name (core metadata concept)'
            and active = 1)
        and fsn.active = 1
        and fsn.conceptid = in_conceptid;

        RETURN result;
END //

DROP FUNCTION IF EXISTS toPt //
CREATE FUNCTION toPt(in_conceptid BIGINT) RETURNS varchar(2048)
BEGIN
        DECLARE result varchar(2048);

        select preferred.term into result
        from v3_ss_pts preferred
        where preferred.active = 1
        and preferred.conceptid = in_conceptid;

        RETURN result;
END //

call createTc() //

DELIMITER ;
