-- ------------------------------------------------------------------------------
-- CREATE TABLES
-- ------------------------------------------------------------------------------
DROP TABLE IF EXISTS rf2_full_concepts
;
CREATE TABLE IF NOT EXISTS rf2_full_concepts (
  id bigint(20) NOT NULL,
  effectivetime timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  active int(11) NOT NULL,
  moduleid bigint(20) NOT NULL,
  definitionstatusid bigint(20) NOT NULL
--  PRIMARY KEY  (id,effective_time)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci
;

DROP TABLE IF EXISTS rf2_full_descriptions
;
CREATE TABLE IF NOT EXISTS rf2_full_descriptions (
  id bigint(20) NOT NULL,
  effectivetime timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  active int(11) NOT NULL,
  moduleid bigint(20) NOT NULL,
  conceptid bigint(20) NOT NULL,
  languagecode varchar(10) collate utf8_unicode_ci NOT NULL,
  typeid bigint(20) NOT NULL,
  term varchar(1024) collate utf8_unicode_ci NOT NULL,
  casesignificanceid bigint(20) NOT NULL
--  PRIMARY KEY  (id,effective_time)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci
;

DROP TABLE IF EXISTS rf2_full_relationships
;
CREATE TABLE IF NOT EXISTS rf2_full_relationships (
  id bigint(20) NOT NULL,
  effectivetime timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  active int(11) NOT NULL,
  moduleid bigint(20) NOT NULL,
  sourceid bigint(20) NOT NULL,
  destinationid bigint(20) NOT NULL,
  relationshipgroup bigint(20) NOT NULL,
  typeid bigint(20) NOT NULL,
  characteristictypeid bigint(20) NOT NULL,
  modifierid bigint(20) NOT NULL
--  PRIMARY KEY  (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci
;

DROP TABLE IF EXISTS rf2_full_language_refset
;
CREATE TABLE IF NOT EXISTS rf2_full_language_refset (
  id varchar(36) collate utf8_unicode_ci NOT NULL,
  effectivetime timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  active int(11) NOT NULL,
  moduleid bigint(20) NOT NULL,
  refsetid bigint(20) NOT NULL,
  referencedcomponentid bigint(20) NOT NULL,
  valueid bigint(20) NOT NULL DEFAULT 0
--  PRIMARY KEY  (id,effective_time)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci
;

DROP TABLE IF EXISTS `rf2_ss_refset`
;
CREATE TABLE IF NOT EXISTS `rf2_ss_refset` (
  `id` varchar(36) collate utf8_unicode_ci NOT NULL,
  `effectivetime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `active` int(11) NOT NULL,
  `moduleid` bigint(20) NOT NULL,
  `refsetid` bigint(20) NOT NULL,
  `referencedcomponentid` bigint(20) NOT NULL
--  PRIMARY KEY  (`id`,`effective_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci
;

DROP TABLE IF EXISTS rf2_ss_strength_refset
;
CREATE TABLE IF NOT EXISTS rf2_ss_strength_refset (
  id varchar(36) collate utf8_unicode_ci NOT NULL,
  effectivetime timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  active int(11) NOT NULL,
  moduleid bigint(20) NOT NULL,
  refsetid bigint(20) NOT NULL,
  referencedcomponentid bigint(20) NOT NULL,
  unitid bigint(20) NOT NULL,
  operatorid bigint(20) NOT NULL,
  value varchar(255) collate utf8_unicode_ci NOT NULL
--  PRIMARY KEY  (id,effective_time)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci
;

DROP TABLE IF EXISTS rf2_ss_unit_of_use_size_refset
;
CREATE TABLE IF NOT EXISTS rf2_ss_unit_of_use_size_refset (
  id varchar(36) collate utf8_unicode_ci NOT NULL,
  effectivetime timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  active int(11) NOT NULL,
  moduleid bigint(20) NOT NULL,
  refsetid bigint(20) NOT NULL,
  referencedcomponentid bigint(20) NOT NULL,
  unitid bigint(20) NOT NULL,
  operatorid bigint(20) NOT NULL,
  value varchar(255) collate utf8_unicode_ci NOT NULL
--  PRIMARY KEY  (id,effective_time)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci
;

DROP TABLE IF EXISTS rf2_ss_unit_of_use_quantity_refset
;
CREATE TABLE IF NOT EXISTS rf2_ss_unit_of_use_quantity_refset (
  id varchar(36) collate utf8_unicode_ci NOT NULL,
  effectivetime timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  active int(11) NOT NULL,
  moduleid bigint(20) NOT NULL,
  refsetid bigint(20) NOT NULL,
  referencedcomponentid bigint(20) NOT NULL,
  unitid bigint(20) NOT NULL,
  operatorid bigint(20) NOT NULL,
  value varchar(255) collate utf8_unicode_ci NOT NULL
--  PRIMARY KEY  (id,effective_time)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci
;

DROP TABLE IF EXISTS rf2_ss_subpack_quantity_refset
;
CREATE TABLE IF NOT EXISTS rf2_ss_subpack_quantity_refset (
  id varchar(36) collate utf8_unicode_ci NOT NULL,
  effectivetime timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  active int(11) NOT NULL,
  moduleid bigint(20) NOT NULL,
  refsetid bigint(20) NOT NULL,
  referencedcomponentid bigint(20) NOT NULL,
  unitid bigint(20) NOT NULL,
  operatorid bigint(20) NOT NULL,
  value INT UNSIGNED NOT NULL
--  PRIMARY KEY  (id,effective_time)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci
;

DROP TABLE IF EXISTS v3_tc
;
CREATE TABLE v3_tc (
    source BIGINT NOT NULL ,
    dest BIGINT NOT NULL ,
    PRIMARY KEY (source, dest) )
ENGINE = MyISAM
;

-- ------------------------------------------------------------------------------
-- CREATE SNAPSHOT VIEWS
-- ------------------------------------------------------------------------------
DROP VIEW IF EXISTS rf2_ss_concepts
;
CREATE VIEW rf2_ss_concepts AS
select t1.* from rf2_full_concepts t1
where
    t1.effectivetime = (
        select max(t2.effectivetime)
        from rf2_full_concepts t2
        where t1.id = t2.id
    )
;

DROP VIEW IF EXISTS rf2_ss_descriptions
;
CREATE VIEW rf2_ss_descriptions AS
select t1.* from rf2_full_descriptions t1
where
    t1.effectivetime = (
        select max(t2.effectivetime)
        from rf2_full_descriptions t2
        where t1.id = t2.id
    )
;

DROP VIEW IF EXISTS rf2_ss_relationships
;
CREATE VIEW rf2_ss_relationships AS
select t1.* from rf2_full_relationships t1
where
    t1.effectivetime = (
        select max(t2.effectivetime)
        from rf2_full_relationships t2
        where t1.id = t2.id
    )
;

DROP VIEW IF EXISTS rf2_ss_language_refset
;
CREATE VIEW rf2_ss_language_refset AS
select t1.* from rf2_full_language_refset t1
where
    t1.effectivetime = (
        select max(t2.effectivetime)
        from rf2_full_language_refset t2
        where t1.id = t2.id
    )
;

DROP VIEW IF EXISTS v3_ss_pts
;
CREATE VIEW v3_ss_pts AS
select
    preferred.*    
from rf2_ss_descriptions preferred

    join rf2_ss_language_refset member
        on member.referencedcomponentid = preferred.id
        and member.active = 1

where member.valueid = (
    select conceptid from rf2_ss_descriptions
    where term = 'Preferred (foundation metadata concept)'
    and active = 1)
;

DROP VIEW IF EXISTS v3_mp
;
CREATE VIEW v3_mp AS
select
    t1.referencedcomponentid AS id
from
    rf2_ss_refset t1
where t1.refsetid = (
        select distinct conceptid
        from rf2_ss_descriptions
        where term = 'Medicinal product reference set (foundation metadata concept)'
    ) and t1.active = 1
;

DROP VIEW IF EXISTS v3_mpuu
;
CREATE VIEW v3_mpuu AS
select
    t1.referencedcomponentid AS id
from
    rf2_ss_refset t1
where t1.refsetid = (
        select distinct conceptid
        from rf2_ss_descriptions
        where term = 'Medicinal product unit of use reference set (foundation metadata concept)'
    ) and t1.active = 1
;

DROP VIEW IF EXISTS v3_mpp
;
CREATE VIEW v3_mpp AS
select
    t1.referencedcomponentid AS id
from
    rf2_ss_refset t1
where t1.refsetid = (
        select distinct conceptid
        from rf2_ss_descriptions
        where term = 'Medicinal product pack reference set (foundation metadata concept)'
    ) and t1.active = 1
;

DROP VIEW IF EXISTS v3_tp
;
CREATE VIEW v3_tp AS
select
    t1.referencedcomponentid AS id
from
    rf2_ss_refset t1
where t1.refsetid = (
        select distinct conceptid
        from rf2_ss_descriptions
        where term = 'Trade product reference set (foundation metadata concept)'
    ) and t1.active = 1
;

DROP VIEW IF EXISTS v3_tpuu
;
CREATE VIEW v3_tpuu AS
select
    t1.referencedcomponentid AS id
from
    rf2_ss_refset t1
where t1.refsetid = (
        select distinct conceptid
        from rf2_ss_descriptions
        where term = 'Trade product unit of use reference set (foundation metadata concept)'
    ) and t1.active = 1
;

DROP VIEW IF EXISTS v3_tpp
;
CREATE VIEW v3_tpp AS
select
    t1.referencedcomponentid AS id
from
    rf2_ss_refset t1
where t1.refsetid = (
        select distinct conceptid
        from rf2_ss_descriptions
        where term = 'Trade product pack reference set (foundation metadata concept)'
    ) and t1.active = 1
;

DROP VIEW IF EXISTS v3_ctpp
;
CREATE VIEW v3_ctpp AS
select
    t1.referencedcomponentid AS id
from
    rf2_ss_refset t1
where t1.refsetid = (
        select distinct conceptid
        from rf2_ss_descriptions
        where term = 'Containered trade product pack reference set (foundation metadata concept)'
    ) and t1.active = 1
;

DROP VIEW IF EXISTS v3_medicinal_substance
;
CREATE VIEW v3_medicinal_substance AS
select source as id
from v3_tc 
where dest = (
    select distinct conceptid from rf2_ss_descriptions
    where term = 'medicinal substance'
    and active = 1)
;
